(ns exoscale.checkmate.manifold
  (:require [exoscale.checkmate.impl :as impl]
            [manifold.deferred :as d]))

(defn- effects!
  [k conditions ctx]
  (apply d/zip
         (keep #(when-let [f (get % k)]
                  (fn [] (f ctx)))
               conditions)))

(defn run
  ([f conditions] (run f conditions {}))
  ([f conditions opts]
   (impl/assert-conditions-valid! conditions)
   (let [{:as opts :exoscale.checkmate.hook/keys [success error failure]}
         (merge impl/default-options opts)
         ctx (impl/setup-conditions conditions opts :manifold)]
     (effects! :exoscale.checkmate/setup-effect! conditions ctx)
     (d/loop [ctx ctx]
       (-> (f)
           (d/chain
            (fn [ret]
              (let [ctx (impl/success-ctx ctx ret)]
                (success ret)
                (d/chain (effects! :exoscale.checkmate/success-effect! conditions ctx)
                         (fn [_] ret)))))
           (d/catch Exception
                    (fn [ret]
                      (let [ctx (impl/error-ctx ctx ret)]
                        (if-let [ctx (impl/abort-ctx conditions ctx)]
                          (do
                            (failure ctx)
                            (d/chain (effects! :exoscale.checkmate/failure-effect! conditions ctx)
                                     (fn [_] (d/error-deferred ret))))
                          (do
                            (error ctx)
                            (d/chain (effects! :exoscale.checkmate/error-effect! conditions ctx)
                                     (fn [_] (d/recur (impl/update-conditions conditions ctx))))))))))))))
