(ns exoscale.checkmate.sync
  (:require [exoscale.checkmate.impl :as impl]))

(defn- attempt!
  "because loop will not allow recur from catch"
  [f ctx]
  (try
    (assoc ctx :exoscale.checkmate/success (f))
    (catch Exception e
      (assoc ctx :exoscale.checkmate/error e))
    (catch AssertionError e
      (assoc ctx :exoscale.checkmate/error e))))

(defn- effects!
  [k conditions ctx]
  (run! (fn [cd]
          (when-let [f (get cd k)]
            (f ctx)))
        conditions))

(defn run
  ([f conditions] (run f conditions {}))
  ([f conditions opts]
   (impl/assert-conditions-valid! conditions)
   (let [{:as opts :exoscale.checkmate.hook/keys [success error failure]}
         (merge impl/default-options opts)
         ctx (impl/setup-conditions conditions opts :sync)]
     (effects! :exoscale.checkmate/setup-effect! conditions ctx)
     (loop [ctx ctx]
       (let [ctx (attempt! f ctx)]
         (if-let [ret (:exoscale.checkmate/success ctx)]
           (do
             (success ctx)
             (effects! :exoscale.checkmate/success-effect! conditions ctx)
             ret)
           ;; got an error
           ;; check continue on all conditions, abort on first false
           (if-let [ctx (impl/abort-ctx conditions ctx)]
             (do
               (failure ctx)
               (effects! :exoscale.checkmate/failure-effect! conditions ctx)
               (throw (:exoscale.checkmate/error ctx)))
             (do
               (error ctx)
               (effects! :exoscale.checkmate/error-effect! conditions ctx)
               (recur (impl/update-conditions conditions ctx))))))))))

;; (def fail! #(exoscale.ex/ex-fault! "asdf"))
;; (run fail! [])
