(ns exoscale.checkmate.auspex
  (:require [exoscale.checkmate.impl :as impl]
            [qbits.auspex :as a]))

(defn- effects!
  [k {:as ctx :exoscale.checkmate/keys [conditions]}]
  (apply a/zip
         (keep #(when-let [f (get % k)]
                  (fn [] (f ctx)))
               conditions)))

(defn- attempt!
  [handler f ctx]
  (let [ctx (dissoc ctx :exoscale.checkmate/error)]
    (->
     (a/chain ctx
              f
              (fn [ctx']
                (handler ctx ctx')))
     (a/catch
         (fn [e] (impl/error-ctx ctx e))))))

(defn run
  ([f conditions] (run f conditions {}))
  ([f conditions opts]
   (impl/assert-conditions-valid! conditions)
   (let [{:as opts
          :exoscale.checkmate.hook/keys [success error failure]
          :exoscale.checkmate/keys [handler return]}
         (merge impl/default-options opts)
         ctx (-> (impl/init-ctx opts conditions)
                 (impl/setup-conditions :auspex))]
     (effects! :exoscale.checkmate/setup-effect! ctx)
     (a/loop [ctx ctx]
       (-> (attempt! handler f ctx)
           (a/chain
            (fn [ctx]
              (if (impl/error? ctx)
                (let [ctx (impl/abort-ctx ctx)]
                  (if (impl/fail? ctx)
                    (do
                      (failure ctx)
                      (a/chain (effects! :exoscale.checkmate/failure-effect! ctx)
                               (fn [_]
                                 (a/error-future (:exoscale.checkmate/error ctx)))))
                    (do
                      (error ctx)
                      (a/chain (effects! :exoscale.checkmate/error-effect! ctx)
                               (fn [_] (a/recur (impl/update-conditions ctx)))))))
                (do
                  (success ctx)
                  (a/chain (effects! :exoscale.checkmate/success-effect! ctx)
                           (fn [_]
                             (-> ctx
                                 impl/teardown-conditions
                                 return))))))))))))
