(ns exoscale.perf)

(require '[malli.core :as m])
(require '[malli.transform :as transform])
(require '[criterium.core :as cc])

(let [schema [:map [:id int?] [:name string?]]
      transform (m/decoder schema transform/string-transformer)]
  (dotimes [_ 5 ]
    (time (dotimes [i 10000]
            (transform {:id "1", :name i})))))

(require '[clojure.spec.alpha :as s])
(require '[exoscale.coax :as cx])

(s/def ::id int?)
(s/def ::name string?)
(s/def ::schema (s/keys :req-un [::id ::name]))

(dotimes [_ 5 ]
  (time (dotimes [i 10000]
          (cx/coerce ::schema {:id "1", :name i}))))
