# Clojure Kubectl

A Clojure wrapper for the `kubectl` CLI.

[![cljdoc badge](https://cljdoc.xyz/badge/exoscale/kubectl)](https://cljdoc.xyz/d/exoscale/kubectl/CURRENT)

[![Clojars Project](https://img.shields.io/clojars/v/exoscale/kubectl.svg)](https://clojars.org/exoscale/kubectl)

## Usage

Commands are represented as a map. Valid keys are:

- `:path`: the path to the kubectl binary.
- `:command`: the kubectl command to execute (`get` for example).
- `:type`: the resource type (`:pods` for example).
- `:resource`: the resource name.
- `:flags`: a vector of flags. Flags can be a keyword (`:--dry-run`) or a vector (`[:-n :backend]`).

For example, the command `kubectl get pods -n backend -o json my-pod` can be described as:

```clojure
{:path "kubectl"
 :command :get
 :type :pods
 :resource :my-pod
 :flags [[:-n :backend]
         [:-o :json]]}
```

### Helper functions

The `exoscale.kubectl.helpers` namespace contains helper functions to build command maps. For example, the previous command can be generated with:

```clojure
(require '[exoscale.kubectl.helpers :as h])

(-> (h/kubectl)
    (h/command :get)
    (h/type :pods)
    (h/resource :my-pod)
    (h/namespace :backend)
    h/json)

```

The namespace also provides some high level functions. For example the previous command can also be generated by:

```clojure
(h/get-pods {:namespace :backend :resource :my-pod :json? true})
```

You can even pass a manifest as a string to apply with the `apply-stdin` helper:

```clojure
(h/apply-stdin {:stdin "blablabla" :json? true})
```

### Running the command

The command map can be run with `exoscale.kubectl/run-command`.
If the command is successful (i.e the status code is 0), the stdout of the command will be returned.
If the command fails, an exception will be thrown. The exception data will contain the executed command, the stdout, stderr, and the status code.
