(ns seql.result-set
  (:require [next.jdbc.result-set :as rs]
            [seql.schema          :as schema])
  (:import java.sql.ResultSet
           java.sql.ResultSetMetaData))

(defn- get-column-names
  [schema ^ResultSetMetaData rsmeta]
  (mapv (fn [^Integer i]
          (schema/unresolve-column schema
                                   (.getTableName rsmeta i)
                                   (.getColumnLabel rsmeta i)))
        (range 1 (inc (if rsmeta (.getColumnCount rsmeta) 0)))))

(defn builder-fn
  [schema]
  (fn [^ResultSet rs _]
    (let [rsmeta (.getMetaData rs)]
      (rs/->MapResultSetBuilder rs rsmeta (get-column-names schema rsmeta)))))
