(ns exoscale.specs.net
  (:require [clojure.spec.alpha :as s]
            [clojure.string :as str])
  (:import (exoscale.specs.validator InetAddressValidator)))

(def ^:private ^InetAddressValidator validator
  (InetAddressValidator/getInstance))

(s/def ::ipv4 (s/and string? #(.isValidInet4Address validator %)))
(s/def ::ipv6 (s/and string? #(.isValidInet6Address validator %)))
(s/def ::ip (s/or :ipv4 ::ipv4
                  :ipv6 ::ipv6))

(s/def ::mac-address
  (s/and string?
         #(re-matches #"([0-9a-fA-F]{2}:??){5}([0-9a-fA-F]{2})" %)))

(s/def ::port (s/int-in 0 65353))

(s/def ::url
  (s/and string?
         #(try
            (->> %
                 (java.net.URI.)
                 (.getScheme)
                 str/lower-case
                 (contains? #{"https" "http"}))
            (catch Exception _))))
