(defproject facjure/mesh "0.4.0"
  :description "A responsive grid & typography toolkit, built on Clojure(Script)"
  :url "https://github.com/facjure/mesh"
  :license {:name "Eclipse Public License" :url "http://www.eclipse.org/legal/epl-v10.html"}
  :scm {:name "git" :url "https://github.com/facjure/mesh"}
  :min-lein-version "2.5.0"
  :jvm-opts ["-Xms512m" "-server"]
  :global-vars {*warn-on-reflection* false *assert* false}

  :dependencies [[org.clojure/clojure "1.7.0"]
                 [org.clojure/clojurescript "1.7.28"]
                 [com.gfredericks/cljs-numbers "0.1.2"]
                 [facjure/gardener "0.1.0"]]

  :node-dependencies [[autoprefixer "5.1.0"]]

  :source-paths ["src" "target/classes"]

  :clean-targets ^{:protect false} ["resources/public/js" "target/classes"]

  :cljsbuild {:builds
              [{:id "dev"
                :source-paths ["examples" "env/dev"]
                :compiler {:output-to "resources/public/js/mesh.js"
                           :output-dir "resources/public/js/out"
                           :main dev.repl
                           :asset-path "js/out"
                           :optimizations :none
                           :cache-analysis true
                           :source-map true}}
               {:id "prod"
                        :source-paths ["src"]
                        :compiler {:output-to "dist/mesh.min.js"
                                   :optimizations :advanced
                                   :pretty-print false}}]}

  :garden {:builds
           [{:id "typography"
             :source-paths ["src" "examples"]
             :stylesheet typography.styles/index
             :compiler {:output-to "resources/public/css/typography.css"
                        :pretty-print true}}
            {:id "grids"
             :source-paths ["src" "examples"]
             :stylesheet grids.styles/index
             :compiler {:output-to "resources/public/css/grids.css"
                        :pretty-print true}}]}

  :profiles {:dev
             {:dependencies [[figwheel "0.3.3"]
                             [figwheel-sidecar "0.3.3"]
                             [brutha "0.1.4"]
                             [org.omcljs/om "0.9.0"]
                             [sablono "0.3.4"]]
              :figwheel {:http-server-root "public"
                         :server-port 3449
                         :nrepl-port 7888
                         :css-dirs ["resources/public/css"]
                         :open-file-command "emacsclient"}}}

  :plugins [[lein-cljsbuild "1.0.6"]
            [lein-garden "0.2.5"]
            [lein-npm "0.5.0"]
            [lein-pdo "0.1.1"]
            [lein-figwheel "0.3.3"]]

  :aliases {"clean-all"  ["pdo" "clean," "garden" "clean"]
            "dev" ["pdo" "garden" "auto," "figwheel"]
            "release" ["pdo" "clean," "cljsbuild" "once" "prod"]})
