// Compiled by ClojureScript 1.7.228 {}
goog.provide('figwheel.client');
goog.require('cljs.core');
goog.require('goog.userAgent.product');
goog.require('goog.Uri');
goog.require('cljs.core.async');
goog.require('figwheel.client.socket');
goog.require('figwheel.client.file_reloading');
goog.require('clojure.string');
goog.require('figwheel.client.utils');
goog.require('cljs.repl');
goog.require('figwheel.client.heads_up');
figwheel.client.figwheel_repl_print = (function figwheel$client$figwheel_repl_print(args){
figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),"figwheel-repl-print",new cljs.core.Keyword(null,"content","content",15833224),args], null));

return args;
});
figwheel.client.autoload_QMARK_ = (cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))?(function (){
var pred__34220 = cljs.core._EQ_;
var expr__34221 = (function (){var or__27541__auto__ = (function (){try{return localStorage.getItem("figwheel_autoload");
}catch (e34224){if((e34224 instanceof Error)){
var e = e34224;
return false;
} else {
throw e34224;

}
}})();
if(cljs.core.truth_(or__27541__auto__)){
return or__27541__auto__;
} else {
return "true";
}
})();
if(cljs.core.truth_(pred__34220.call(null,"true",expr__34221))){
return true;
} else {
if(cljs.core.truth_(pred__34220.call(null,"false",expr__34221))){
return false;
} else {
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(expr__34221)].join('')));
}
}
}):(function (){
return true;
}));
figwheel.client.toggle_autoload = (function figwheel$client$toggle_autoload(){
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
try{localStorage.setItem("figwheel_autoload",cljs.core.not.call(null,figwheel.client.autoload_QMARK_.call(null)));

return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str("Figwheel autoloading "),cljs.core.str((cljs.core.truth_(figwheel.client.autoload_QMARK_.call(null))?"ON":"OFF"))].join(''));
}catch (e34226){if((e34226 instanceof Error)){
var e = e34226;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str("Unable to access localStorage")].join(''));
} else {
throw e34226;

}
}} else {
return null;
}
});
goog.exportSymbol('figwheel.client.toggle_autoload', figwheel.client.toggle_autoload);
figwheel.client.console_print = (function figwheel$client$console_print(args){
console.log.apply(console,cljs.core.into_array.call(null,args));

return args;
});
figwheel.client.repl_print_fn = (function figwheel$client$repl_print_fn(var_args){
var args__28606__auto__ = [];
var len__28599__auto___34228 = arguments.length;
var i__28600__auto___34229 = (0);
while(true){
if((i__28600__auto___34229 < len__28599__auto___34228)){
args__28606__auto__.push((arguments[i__28600__auto___34229]));

var G__34230 = (i__28600__auto___34229 + (1));
i__28600__auto___34229 = G__34230;
continue;
} else {
}
break;
}

var argseq__28607__auto__ = ((((0) < args__28606__auto__.length))?(new cljs.core.IndexedSeq(args__28606__auto__.slice((0)),(0))):null);
return figwheel.client.repl_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__28607__auto__);
});

figwheel.client.repl_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.figwheel_repl_print.call(null,figwheel.client.console_print.call(null,args));

return null;
});

figwheel.client.repl_print_fn.cljs$lang$maxFixedArity = (0);

figwheel.client.repl_print_fn.cljs$lang$applyTo = (function (seq34227){
return figwheel.client.repl_print_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq34227));
});
figwheel.client.enable_repl_print_BANG_ = (function figwheel$client$enable_repl_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

return cljs.core._STAR_print_fn_STAR_ = figwheel.client.repl_print_fn;
});
figwheel.client.get_essential_messages = (function figwheel$client$get_essential_messages(ed){
if(cljs.core.truth_(ed)){
return cljs.core.cons.call(null,cljs.core.select_keys.call(null,ed,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"class","class",-2030961996)], null)),figwheel$client$get_essential_messages.call(null,new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(ed)));
} else {
return null;
}
});
figwheel.client.error_msg_format = (function figwheel$client$error_msg_format(p__34231){
var map__34234 = p__34231;
var map__34234__$1 = ((((!((map__34234 == null)))?((((map__34234.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34234.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34234):map__34234);
var message = cljs.core.get.call(null,map__34234__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var class$ = cljs.core.get.call(null,map__34234__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
return [cljs.core.str(class$),cljs.core.str(" : "),cljs.core.str(message)].join('');
});
figwheel.client.format_messages = cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.map,figwheel.client.error_msg_format),figwheel.client.get_essential_messages);
figwheel.client.focus_msgs = (function figwheel$client$focus_msgs(name_set,msg_hist){
return cljs.core.cons.call(null,cljs.core.first.call(null,msg_hist),cljs.core.filter.call(null,cljs.core.comp.call(null,name_set,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863)),cljs.core.rest.call(null,msg_hist)));
});
figwheel.client.reload_file_QMARK__STAR_ = (function figwheel$client$reload_file_QMARK__STAR_(msg_name,opts){
var or__27541__auto__ = new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__27541__auto__)){
return or__27541__auto__;
} else {
return cljs.core.not_EQ_.call(null,msg_name,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356));
}
});
figwheel.client.reload_file_state_QMARK_ = (function figwheel$client$reload_file_state_QMARK_(msg_names,opts){
var and__27529__auto__ = cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563));
if(and__27529__auto__){
return figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts);
} else {
return and__27529__auto__;
}
});
figwheel.client.block_reload_file_state_QMARK_ = (function figwheel$client$block_reload_file_state_QMARK_(msg_names,opts){
return (cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))) && (cljs.core.not.call(null,figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts)));
});
figwheel.client.warning_append_state_QMARK_ = (function figwheel$client$warning_append_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.warning_state_QMARK_ = (function figwheel$client$warning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),cljs.core.first.call(null,msg_names));
});
figwheel.client.rewarning_state_QMARK_ = (function figwheel$client$rewarning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(3),msg_names));
});
figwheel.client.compile_fail_state_QMARK_ = (function figwheel$client$compile_fail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),cljs.core.first.call(null,msg_names));
});
figwheel.client.compile_refail_state_QMARK_ = (function figwheel$client$compile_refail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.css_loaded_state_QMARK_ = (function figwheel$client$css_loaded_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874),cljs.core.first.call(null,msg_names));
});
figwheel.client.file_reloader_plugin = (function figwheel$client$file_reloader_plugin(opts){
var ch = cljs.core.async.chan.call(null);
var c__29898__auto___34396 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29898__auto___34396,ch){
return (function (){
var f__29899__auto__ = (function (){var switch__29786__auto__ = ((function (c__29898__auto___34396,ch){
return (function (state_34365){
var state_val_34366 = (state_34365[(1)]);
if((state_val_34366 === (7))){
var inst_34361 = (state_34365[(2)]);
var state_34365__$1 = state_34365;
var statearr_34367_34397 = state_34365__$1;
(statearr_34367_34397[(2)] = inst_34361);

(statearr_34367_34397[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34366 === (1))){
var state_34365__$1 = state_34365;
var statearr_34368_34398 = state_34365__$1;
(statearr_34368_34398[(2)] = null);

(statearr_34368_34398[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34366 === (4))){
var inst_34318 = (state_34365[(7)]);
var inst_34318__$1 = (state_34365[(2)]);
var state_34365__$1 = (function (){var statearr_34369 = state_34365;
(statearr_34369[(7)] = inst_34318__$1);

return statearr_34369;
})();
if(cljs.core.truth_(inst_34318__$1)){
var statearr_34370_34399 = state_34365__$1;
(statearr_34370_34399[(1)] = (5));

} else {
var statearr_34371_34400 = state_34365__$1;
(statearr_34371_34400[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34366 === (15))){
var inst_34325 = (state_34365[(8)]);
var inst_34340 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_34325);
var inst_34341 = cljs.core.first.call(null,inst_34340);
var inst_34342 = new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(inst_34341);
var inst_34343 = [cljs.core.str("Figwheel: Not loading code with warnings - "),cljs.core.str(inst_34342)].join('');
var inst_34344 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),inst_34343);
var state_34365__$1 = state_34365;
var statearr_34372_34401 = state_34365__$1;
(statearr_34372_34401[(2)] = inst_34344);

(statearr_34372_34401[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34366 === (13))){
var inst_34349 = (state_34365[(2)]);
var state_34365__$1 = state_34365;
var statearr_34373_34402 = state_34365__$1;
(statearr_34373_34402[(2)] = inst_34349);

(statearr_34373_34402[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34366 === (6))){
var state_34365__$1 = state_34365;
var statearr_34374_34403 = state_34365__$1;
(statearr_34374_34403[(2)] = null);

(statearr_34374_34403[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34366 === (17))){
var inst_34347 = (state_34365[(2)]);
var state_34365__$1 = state_34365;
var statearr_34375_34404 = state_34365__$1;
(statearr_34375_34404[(2)] = inst_34347);

(statearr_34375_34404[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34366 === (3))){
var inst_34363 = (state_34365[(2)]);
var state_34365__$1 = state_34365;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34365__$1,inst_34363);
} else {
if((state_val_34366 === (12))){
var inst_34324 = (state_34365[(9)]);
var inst_34338 = figwheel.client.block_reload_file_state_QMARK_.call(null,inst_34324,opts);
var state_34365__$1 = state_34365;
if(cljs.core.truth_(inst_34338)){
var statearr_34376_34405 = state_34365__$1;
(statearr_34376_34405[(1)] = (15));

} else {
var statearr_34377_34406 = state_34365__$1;
(statearr_34377_34406[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34366 === (2))){
var state_34365__$1 = state_34365;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34365__$1,(4),ch);
} else {
if((state_val_34366 === (11))){
var inst_34325 = (state_34365[(8)]);
var inst_34330 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34331 = figwheel.client.file_reloading.reload_js_files.call(null,opts,inst_34325);
var inst_34332 = cljs.core.async.timeout.call(null,(1000));
var inst_34333 = [inst_34331,inst_34332];
var inst_34334 = (new cljs.core.PersistentVector(null,2,(5),inst_34330,inst_34333,null));
var state_34365__$1 = state_34365;
return cljs.core.async.ioc_alts_BANG_.call(null,state_34365__$1,(14),inst_34334);
} else {
if((state_val_34366 === (9))){
var inst_34325 = (state_34365[(8)]);
var inst_34351 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),"Figwheel: code autoloading is OFF");
var inst_34352 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_34325);
var inst_34353 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_34352);
var inst_34354 = [cljs.core.str("Not loading: "),cljs.core.str(inst_34353)].join('');
var inst_34355 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_34354);
var state_34365__$1 = (function (){var statearr_34378 = state_34365;
(statearr_34378[(10)] = inst_34351);

return statearr_34378;
})();
var statearr_34379_34407 = state_34365__$1;
(statearr_34379_34407[(2)] = inst_34355);

(statearr_34379_34407[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34366 === (5))){
var inst_34318 = (state_34365[(7)]);
var inst_34320 = [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null];
var inst_34321 = (new cljs.core.PersistentArrayMap(null,2,inst_34320,null));
var inst_34322 = (new cljs.core.PersistentHashSet(null,inst_34321,null));
var inst_34323 = figwheel.client.focus_msgs.call(null,inst_34322,inst_34318);
var inst_34324 = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),inst_34323);
var inst_34325 = cljs.core.first.call(null,inst_34323);
var inst_34326 = figwheel.client.autoload_QMARK_.call(null);
var state_34365__$1 = (function (){var statearr_34380 = state_34365;
(statearr_34380[(8)] = inst_34325);

(statearr_34380[(9)] = inst_34324);

return statearr_34380;
})();
if(cljs.core.truth_(inst_34326)){
var statearr_34381_34408 = state_34365__$1;
(statearr_34381_34408[(1)] = (8));

} else {
var statearr_34382_34409 = state_34365__$1;
(statearr_34382_34409[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34366 === (14))){
var inst_34336 = (state_34365[(2)]);
var state_34365__$1 = state_34365;
var statearr_34383_34410 = state_34365__$1;
(statearr_34383_34410[(2)] = inst_34336);

(statearr_34383_34410[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34366 === (16))){
var state_34365__$1 = state_34365;
var statearr_34384_34411 = state_34365__$1;
(statearr_34384_34411[(2)] = null);

(statearr_34384_34411[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34366 === (10))){
var inst_34357 = (state_34365[(2)]);
var state_34365__$1 = (function (){var statearr_34385 = state_34365;
(statearr_34385[(11)] = inst_34357);

return statearr_34385;
})();
var statearr_34386_34412 = state_34365__$1;
(statearr_34386_34412[(2)] = null);

(statearr_34386_34412[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34366 === (8))){
var inst_34324 = (state_34365[(9)]);
var inst_34328 = figwheel.client.reload_file_state_QMARK_.call(null,inst_34324,opts);
var state_34365__$1 = state_34365;
if(cljs.core.truth_(inst_34328)){
var statearr_34387_34413 = state_34365__$1;
(statearr_34387_34413[(1)] = (11));

} else {
var statearr_34388_34414 = state_34365__$1;
(statearr_34388_34414[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29898__auto___34396,ch))
;
return ((function (switch__29786__auto__,c__29898__auto___34396,ch){
return (function() {
var figwheel$client$file_reloader_plugin_$_state_machine__29787__auto__ = null;
var figwheel$client$file_reloader_plugin_$_state_machine__29787__auto____0 = (function (){
var statearr_34392 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34392[(0)] = figwheel$client$file_reloader_plugin_$_state_machine__29787__auto__);

(statearr_34392[(1)] = (1));

return statearr_34392;
});
var figwheel$client$file_reloader_plugin_$_state_machine__29787__auto____1 = (function (state_34365){
while(true){
var ret_value__29788__auto__ = (function (){try{while(true){
var result__29789__auto__ = switch__29786__auto__.call(null,state_34365);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29789__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29789__auto__;
}
break;
}
}catch (e34393){if((e34393 instanceof Object)){
var ex__29790__auto__ = e34393;
var statearr_34394_34415 = state_34365;
(statearr_34394_34415[(5)] = ex__29790__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34365);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34393;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29788__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34416 = state_34365;
state_34365 = G__34416;
continue;
} else {
return ret_value__29788__auto__;
}
break;
}
});
figwheel$client$file_reloader_plugin_$_state_machine__29787__auto__ = function(state_34365){
switch(arguments.length){
case 0:
return figwheel$client$file_reloader_plugin_$_state_machine__29787__auto____0.call(this);
case 1:
return figwheel$client$file_reloader_plugin_$_state_machine__29787__auto____1.call(this,state_34365);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloader_plugin_$_state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloader_plugin_$_state_machine__29787__auto____0;
figwheel$client$file_reloader_plugin_$_state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloader_plugin_$_state_machine__29787__auto____1;
return figwheel$client$file_reloader_plugin_$_state_machine__29787__auto__;
})()
;})(switch__29786__auto__,c__29898__auto___34396,ch))
})();
var state__29900__auto__ = (function (){var statearr_34395 = f__29899__auto__.call(null);
(statearr_34395[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29898__auto___34396);

return statearr_34395;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29900__auto__);
});})(c__29898__auto___34396,ch))
);


return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.truncate_stack_trace = (function figwheel$client$truncate_stack_trace(stack_str){
return cljs.core.take_while.call(null,(function (p1__34417_SHARP_){
return cljs.core.not.call(null,cljs.core.re_matches.call(null,/.*eval_javascript_STAR__STAR_.*/,p1__34417_SHARP_));
}),clojure.string.split_lines.call(null,stack_str));
});
figwheel.client.get_ua_product = (function figwheel$client$get_ua_product(){
if(cljs.core.truth_(figwheel.client.utils.node_env_QMARK_.call(null))){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
}
});
var base_path_34424 = figwheel.client.utils.base_url_path.call(null);
figwheel.client.eval_javascript_STAR__STAR_ = ((function (base_path_34424){
return (function figwheel$client$eval_javascript_STAR__STAR_(code,opts,result_handler){
try{var _STAR_print_fn_STAR_34422 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR_34423 = cljs.core._STAR_print_newline_STAR_;
cljs.core._STAR_print_fn_STAR_ = figwheel.client.repl_print_fn;

cljs.core._STAR_print_newline_STAR_ = false;

try{return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"success","success",1890645906),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),figwheel.client.utils.eval_helper.call(null,code,opts)], null));
}finally {cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR_34423;

cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR_34422;
}}catch (e34421){if((e34421 instanceof Error)){
var e = e34421;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),clojure.string.join.call(null,"\n",figwheel.client.truncate_stack_trace.call(null,e.stack)),new cljs.core.Keyword(null,"base-path","base-path",495760020),base_path_34424], null));
} else {
var e = e34421;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),"No stacktrace available."], null));

}
}});})(base_path_34424))
;
/**
 * The REPL can disconnect and reconnect lets ensure cljs.user exists at least.
 */
figwheel.client.ensure_cljs_user = (function figwheel$client$ensure_cljs_user(){
if(cljs.core.truth_(cljs.user)){
return null;
} else {
return cljs.user = {};
}
});
figwheel.client.repl_plugin = (function figwheel$client$repl_plugin(p__34425){
var map__34432 = p__34425;
var map__34432__$1 = ((((!((map__34432 == null)))?((((map__34432.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34432.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34432):map__34432);
var opts = map__34432__$1;
var build_id = cljs.core.get.call(null,map__34432__$1,new cljs.core.Keyword(null,"build-id","build-id",1642831089));
return ((function (map__34432,map__34432__$1,opts,build_id){
return (function (p__34434){
var vec__34435 = p__34434;
var map__34436 = cljs.core.nth.call(null,vec__34435,(0),null);
var map__34436__$1 = ((((!((map__34436 == null)))?((((map__34436.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34436.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34436):map__34436);
var msg = map__34436__$1;
var msg_name = cljs.core.get.call(null,map__34436__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = cljs.core.nthnext.call(null,vec__34435,(1));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"repl-eval","repl-eval",-1784727398),msg_name)){
figwheel.client.ensure_cljs_user.call(null);

return figwheel.client.eval_javascript_STAR__STAR_.call(null,new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(msg),opts,((function (vec__34435,map__34436,map__34436__$1,msg,msg_name,_,map__34432,map__34432__$1,opts,build_id){
return (function (res){
return figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),new cljs.core.Keyword(null,"callback-name","callback-name",336964714).cljs$core$IFn$_invoke$arity$1(msg),new cljs.core.Keyword(null,"content","content",15833224),res], null));
});})(vec__34435,map__34436,map__34436__$1,msg,msg_name,_,map__34432,map__34432__$1,opts,build_id))
);
} else {
return null;
}
});
;})(map__34432,map__34432__$1,opts,build_id))
});
figwheel.client.css_reloader_plugin = (function figwheel$client$css_reloader_plugin(opts){
return (function (p__34442){
var vec__34443 = p__34442;
var map__34444 = cljs.core.nth.call(null,vec__34443,(0),null);
var map__34444__$1 = ((((!((map__34444 == null)))?((((map__34444.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34444.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34444):map__34444);
var msg = map__34444__$1;
var msg_name = cljs.core.get.call(null,map__34444__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = cljs.core.nthnext.call(null,vec__34443,(1));
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874))){
return figwheel.client.file_reloading.reload_css_files.call(null,opts,msg);
} else {
return null;
}
});
});
figwheel.client.compile_fail_warning_plugin = (function figwheel$client$compile_fail_warning_plugin(p__34446){
var map__34456 = p__34446;
var map__34456__$1 = ((((!((map__34456 == null)))?((((map__34456.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34456.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34456):map__34456);
var on_compile_warning = cljs.core.get.call(null,map__34456__$1,new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947));
var on_compile_fail = cljs.core.get.call(null,map__34456__$1,new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036));
return ((function (map__34456,map__34456__$1,on_compile_warning,on_compile_fail){
return (function (p__34458){
var vec__34459 = p__34458;
var map__34460 = cljs.core.nth.call(null,vec__34459,(0),null);
var map__34460__$1 = ((((!((map__34460 == null)))?((((map__34460.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34460.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34460):map__34460);
var msg = map__34460__$1;
var msg_name = cljs.core.get.call(null,map__34460__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = cljs.core.nthnext.call(null,vec__34459,(1));
var pred__34462 = cljs.core._EQ_;
var expr__34463 = msg_name;
if(cljs.core.truth_(pred__34462.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),expr__34463))){
return on_compile_warning.call(null,msg);
} else {
if(cljs.core.truth_(pred__34462.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),expr__34463))){
return on_compile_fail.call(null,msg);
} else {
return null;
}
}
});
;})(map__34456,map__34456__$1,on_compile_warning,on_compile_fail))
});
figwheel.client.heads_up_plugin_msg_handler = (function figwheel$client$heads_up_plugin_msg_handler(opts,msg_hist_SINGLEQUOTE_){
var msg_hist = figwheel.client.focus_msgs.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null], null), null),msg_hist_SINGLEQUOTE_);
var msg_names = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),msg_hist);
var msg = cljs.core.first.call(null,msg_hist);
var c__29898__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29898__auto__,msg_hist,msg_names,msg){
return (function (){
var f__29899__auto__ = (function (){var switch__29786__auto__ = ((function (c__29898__auto__,msg_hist,msg_names,msg){
return (function (state_34679){
var state_val_34680 = (state_34679[(1)]);
if((state_val_34680 === (7))){
var inst_34603 = (state_34679[(2)]);
var state_34679__$1 = state_34679;
if(cljs.core.truth_(inst_34603)){
var statearr_34681_34727 = state_34679__$1;
(statearr_34681_34727[(1)] = (8));

} else {
var statearr_34682_34728 = state_34679__$1;
(statearr_34682_34728[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34680 === (20))){
var inst_34673 = (state_34679[(2)]);
var state_34679__$1 = state_34679;
var statearr_34683_34729 = state_34679__$1;
(statearr_34683_34729[(2)] = inst_34673);

(statearr_34683_34729[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34680 === (27))){
var inst_34669 = (state_34679[(2)]);
var state_34679__$1 = state_34679;
var statearr_34684_34730 = state_34679__$1;
(statearr_34684_34730[(2)] = inst_34669);

(statearr_34684_34730[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34680 === (1))){
var inst_34596 = figwheel.client.reload_file_state_QMARK_.call(null,msg_names,opts);
var state_34679__$1 = state_34679;
if(cljs.core.truth_(inst_34596)){
var statearr_34685_34731 = state_34679__$1;
(statearr_34685_34731[(1)] = (2));

} else {
var statearr_34686_34732 = state_34679__$1;
(statearr_34686_34732[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34680 === (24))){
var inst_34671 = (state_34679[(2)]);
var state_34679__$1 = state_34679;
var statearr_34687_34733 = state_34679__$1;
(statearr_34687_34733[(2)] = inst_34671);

(statearr_34687_34733[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34680 === (4))){
var inst_34677 = (state_34679[(2)]);
var state_34679__$1 = state_34679;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34679__$1,inst_34677);
} else {
if((state_val_34680 === (15))){
var inst_34675 = (state_34679[(2)]);
var state_34679__$1 = state_34679;
var statearr_34688_34734 = state_34679__$1;
(statearr_34688_34734[(2)] = inst_34675);

(statearr_34688_34734[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34680 === (21))){
var inst_34634 = (state_34679[(2)]);
var state_34679__$1 = state_34679;
var statearr_34689_34735 = state_34679__$1;
(statearr_34689_34735[(2)] = inst_34634);

(statearr_34689_34735[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34680 === (31))){
var inst_34658 = figwheel.client.css_loaded_state_QMARK_.call(null,msg_names);
var state_34679__$1 = state_34679;
if(cljs.core.truth_(inst_34658)){
var statearr_34690_34736 = state_34679__$1;
(statearr_34690_34736[(1)] = (34));

} else {
var statearr_34691_34737 = state_34679__$1;
(statearr_34691_34737[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34680 === (32))){
var inst_34667 = (state_34679[(2)]);
var state_34679__$1 = state_34679;
var statearr_34692_34738 = state_34679__$1;
(statearr_34692_34738[(2)] = inst_34667);

(statearr_34692_34738[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34680 === (33))){
var inst_34656 = (state_34679[(2)]);
var state_34679__$1 = state_34679;
var statearr_34693_34739 = state_34679__$1;
(statearr_34693_34739[(2)] = inst_34656);

(statearr_34693_34739[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34680 === (13))){
var inst_34617 = figwheel.client.heads_up.clear.call(null);
var state_34679__$1 = state_34679;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34679__$1,(16),inst_34617);
} else {
if((state_val_34680 === (22))){
var inst_34638 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_34639 = figwheel.client.heads_up.append_message.call(null,inst_34638);
var state_34679__$1 = state_34679;
var statearr_34694_34740 = state_34679__$1;
(statearr_34694_34740[(2)] = inst_34639);

(statearr_34694_34740[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34680 === (36))){
var inst_34665 = (state_34679[(2)]);
var state_34679__$1 = state_34679;
var statearr_34695_34741 = state_34679__$1;
(statearr_34695_34741[(2)] = inst_34665);

(statearr_34695_34741[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34680 === (29))){
var inst_34649 = (state_34679[(2)]);
var state_34679__$1 = state_34679;
var statearr_34696_34742 = state_34679__$1;
(statearr_34696_34742[(2)] = inst_34649);

(statearr_34696_34742[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34680 === (6))){
var inst_34598 = (state_34679[(7)]);
var state_34679__$1 = state_34679;
var statearr_34697_34743 = state_34679__$1;
(statearr_34697_34743[(2)] = inst_34598);

(statearr_34697_34743[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34680 === (28))){
var inst_34645 = (state_34679[(2)]);
var inst_34646 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_34647 = figwheel.client.heads_up.display_warning.call(null,inst_34646);
var state_34679__$1 = (function (){var statearr_34698 = state_34679;
(statearr_34698[(8)] = inst_34645);

return statearr_34698;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34679__$1,(29),inst_34647);
} else {
if((state_val_34680 === (25))){
var inst_34643 = figwheel.client.heads_up.clear.call(null);
var state_34679__$1 = state_34679;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34679__$1,(28),inst_34643);
} else {
if((state_val_34680 === (34))){
var inst_34660 = figwheel.client.heads_up.flash_loaded.call(null);
var state_34679__$1 = state_34679;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34679__$1,(37),inst_34660);
} else {
if((state_val_34680 === (17))){
var inst_34625 = (state_34679[(2)]);
var state_34679__$1 = state_34679;
var statearr_34699_34744 = state_34679__$1;
(statearr_34699_34744[(2)] = inst_34625);

(statearr_34699_34744[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34680 === (3))){
var inst_34615 = figwheel.client.compile_refail_state_QMARK_.call(null,msg_names);
var state_34679__$1 = state_34679;
if(cljs.core.truth_(inst_34615)){
var statearr_34700_34745 = state_34679__$1;
(statearr_34700_34745[(1)] = (13));

} else {
var statearr_34701_34746 = state_34679__$1;
(statearr_34701_34746[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34680 === (12))){
var inst_34611 = (state_34679[(2)]);
var state_34679__$1 = state_34679;
var statearr_34702_34747 = state_34679__$1;
(statearr_34702_34747[(2)] = inst_34611);

(statearr_34702_34747[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34680 === (2))){
var inst_34598 = (state_34679[(7)]);
var inst_34598__$1 = figwheel.client.autoload_QMARK_.call(null);
var state_34679__$1 = (function (){var statearr_34703 = state_34679;
(statearr_34703[(7)] = inst_34598__$1);

return statearr_34703;
})();
if(cljs.core.truth_(inst_34598__$1)){
var statearr_34704_34748 = state_34679__$1;
(statearr_34704_34748[(1)] = (5));

} else {
var statearr_34705_34749 = state_34679__$1;
(statearr_34705_34749[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34680 === (23))){
var inst_34641 = figwheel.client.rewarning_state_QMARK_.call(null,msg_names);
var state_34679__$1 = state_34679;
if(cljs.core.truth_(inst_34641)){
var statearr_34706_34750 = state_34679__$1;
(statearr_34706_34750[(1)] = (25));

} else {
var statearr_34707_34751 = state_34679__$1;
(statearr_34707_34751[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34680 === (35))){
var state_34679__$1 = state_34679;
var statearr_34708_34752 = state_34679__$1;
(statearr_34708_34752[(2)] = null);

(statearr_34708_34752[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34680 === (19))){
var inst_34636 = figwheel.client.warning_append_state_QMARK_.call(null,msg_names);
var state_34679__$1 = state_34679;
if(cljs.core.truth_(inst_34636)){
var statearr_34709_34753 = state_34679__$1;
(statearr_34709_34753[(1)] = (22));

} else {
var statearr_34710_34754 = state_34679__$1;
(statearr_34710_34754[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34680 === (11))){
var inst_34607 = (state_34679[(2)]);
var state_34679__$1 = state_34679;
var statearr_34711_34755 = state_34679__$1;
(statearr_34711_34755[(2)] = inst_34607);

(statearr_34711_34755[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34680 === (9))){
var inst_34609 = figwheel.client.heads_up.clear.call(null);
var state_34679__$1 = state_34679;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34679__$1,(12),inst_34609);
} else {
if((state_val_34680 === (5))){
var inst_34600 = new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(opts);
var state_34679__$1 = state_34679;
var statearr_34712_34756 = state_34679__$1;
(statearr_34712_34756[(2)] = inst_34600);

(statearr_34712_34756[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34680 === (14))){
var inst_34627 = figwheel.client.compile_fail_state_QMARK_.call(null,msg_names);
var state_34679__$1 = state_34679;
if(cljs.core.truth_(inst_34627)){
var statearr_34713_34757 = state_34679__$1;
(statearr_34713_34757[(1)] = (18));

} else {
var statearr_34714_34758 = state_34679__$1;
(statearr_34714_34758[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34680 === (26))){
var inst_34651 = figwheel.client.warning_state_QMARK_.call(null,msg_names);
var state_34679__$1 = state_34679;
if(cljs.core.truth_(inst_34651)){
var statearr_34715_34759 = state_34679__$1;
(statearr_34715_34759[(1)] = (30));

} else {
var statearr_34716_34760 = state_34679__$1;
(statearr_34716_34760[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34680 === (16))){
var inst_34619 = (state_34679[(2)]);
var inst_34620 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_34621 = figwheel.client.format_messages.call(null,inst_34620);
var inst_34622 = new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(msg);
var inst_34623 = figwheel.client.heads_up.display_error.call(null,inst_34621,inst_34622);
var state_34679__$1 = (function (){var statearr_34717 = state_34679;
(statearr_34717[(9)] = inst_34619);

return statearr_34717;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34679__$1,(17),inst_34623);
} else {
if((state_val_34680 === (30))){
var inst_34653 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_34654 = figwheel.client.heads_up.display_warning.call(null,inst_34653);
var state_34679__$1 = state_34679;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34679__$1,(33),inst_34654);
} else {
if((state_val_34680 === (10))){
var inst_34613 = (state_34679[(2)]);
var state_34679__$1 = state_34679;
var statearr_34718_34761 = state_34679__$1;
(statearr_34718_34761[(2)] = inst_34613);

(statearr_34718_34761[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34680 === (18))){
var inst_34629 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_34630 = figwheel.client.format_messages.call(null,inst_34629);
var inst_34631 = new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(msg);
var inst_34632 = figwheel.client.heads_up.display_error.call(null,inst_34630,inst_34631);
var state_34679__$1 = state_34679;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34679__$1,(21),inst_34632);
} else {
if((state_val_34680 === (37))){
var inst_34662 = (state_34679[(2)]);
var state_34679__$1 = state_34679;
var statearr_34719_34762 = state_34679__$1;
(statearr_34719_34762[(2)] = inst_34662);

(statearr_34719_34762[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34680 === (8))){
var inst_34605 = figwheel.client.heads_up.flash_loaded.call(null);
var state_34679__$1 = state_34679;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34679__$1,(11),inst_34605);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29898__auto__,msg_hist,msg_names,msg))
;
return ((function (switch__29786__auto__,c__29898__auto__,msg_hist,msg_names,msg){
return (function() {
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__29787__auto__ = null;
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__29787__auto____0 = (function (){
var statearr_34723 = [null,null,null,null,null,null,null,null,null,null];
(statearr_34723[(0)] = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__29787__auto__);

(statearr_34723[(1)] = (1));

return statearr_34723;
});
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__29787__auto____1 = (function (state_34679){
while(true){
var ret_value__29788__auto__ = (function (){try{while(true){
var result__29789__auto__ = switch__29786__auto__.call(null,state_34679);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29789__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29789__auto__;
}
break;
}
}catch (e34724){if((e34724 instanceof Object)){
var ex__29790__auto__ = e34724;
var statearr_34725_34763 = state_34679;
(statearr_34725_34763[(5)] = ex__29790__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34679);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34724;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29788__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34764 = state_34679;
state_34679 = G__34764;
continue;
} else {
return ret_value__29788__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__29787__auto__ = function(state_34679){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__29787__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__29787__auto____1.call(this,state_34679);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__29787__auto____0;
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__29787__auto____1;
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__29787__auto__;
})()
;})(switch__29786__auto__,c__29898__auto__,msg_hist,msg_names,msg))
})();
var state__29900__auto__ = (function (){var statearr_34726 = f__29899__auto__.call(null);
(statearr_34726[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29898__auto__);

return statearr_34726;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29900__auto__);
});})(c__29898__auto__,msg_hist,msg_names,msg))
);

return c__29898__auto__;
});
figwheel.client.heads_up_plugin = (function figwheel$client$heads_up_plugin(opts){
var ch = cljs.core.async.chan.call(null);
figwheel.client.heads_up_config_options_STAR__STAR_ = opts;

var c__29898__auto___34827 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29898__auto___34827,ch){
return (function (){
var f__29899__auto__ = (function (){var switch__29786__auto__ = ((function (c__29898__auto___34827,ch){
return (function (state_34810){
var state_val_34811 = (state_34810[(1)]);
if((state_val_34811 === (1))){
var state_34810__$1 = state_34810;
var statearr_34812_34828 = state_34810__$1;
(statearr_34812_34828[(2)] = null);

(statearr_34812_34828[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34811 === (2))){
var state_34810__$1 = state_34810;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34810__$1,(4),ch);
} else {
if((state_val_34811 === (3))){
var inst_34808 = (state_34810[(2)]);
var state_34810__$1 = state_34810;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34810__$1,inst_34808);
} else {
if((state_val_34811 === (4))){
var inst_34798 = (state_34810[(7)]);
var inst_34798__$1 = (state_34810[(2)]);
var state_34810__$1 = (function (){var statearr_34813 = state_34810;
(statearr_34813[(7)] = inst_34798__$1);

return statearr_34813;
})();
if(cljs.core.truth_(inst_34798__$1)){
var statearr_34814_34829 = state_34810__$1;
(statearr_34814_34829[(1)] = (5));

} else {
var statearr_34815_34830 = state_34810__$1;
(statearr_34815_34830[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34811 === (5))){
var inst_34798 = (state_34810[(7)]);
var inst_34800 = figwheel.client.heads_up_plugin_msg_handler.call(null,opts,inst_34798);
var state_34810__$1 = state_34810;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34810__$1,(8),inst_34800);
} else {
if((state_val_34811 === (6))){
var state_34810__$1 = state_34810;
var statearr_34816_34831 = state_34810__$1;
(statearr_34816_34831[(2)] = null);

(statearr_34816_34831[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34811 === (7))){
var inst_34806 = (state_34810[(2)]);
var state_34810__$1 = state_34810;
var statearr_34817_34832 = state_34810__$1;
(statearr_34817_34832[(2)] = inst_34806);

(statearr_34817_34832[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34811 === (8))){
var inst_34802 = (state_34810[(2)]);
var state_34810__$1 = (function (){var statearr_34818 = state_34810;
(statearr_34818[(8)] = inst_34802);

return statearr_34818;
})();
var statearr_34819_34833 = state_34810__$1;
(statearr_34819_34833[(2)] = null);

(statearr_34819_34833[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__29898__auto___34827,ch))
;
return ((function (switch__29786__auto__,c__29898__auto___34827,ch){
return (function() {
var figwheel$client$heads_up_plugin_$_state_machine__29787__auto__ = null;
var figwheel$client$heads_up_plugin_$_state_machine__29787__auto____0 = (function (){
var statearr_34823 = [null,null,null,null,null,null,null,null,null];
(statearr_34823[(0)] = figwheel$client$heads_up_plugin_$_state_machine__29787__auto__);

(statearr_34823[(1)] = (1));

return statearr_34823;
});
var figwheel$client$heads_up_plugin_$_state_machine__29787__auto____1 = (function (state_34810){
while(true){
var ret_value__29788__auto__ = (function (){try{while(true){
var result__29789__auto__ = switch__29786__auto__.call(null,state_34810);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29789__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29789__auto__;
}
break;
}
}catch (e34824){if((e34824 instanceof Object)){
var ex__29790__auto__ = e34824;
var statearr_34825_34834 = state_34810;
(statearr_34825_34834[(5)] = ex__29790__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34810);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34824;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29788__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34835 = state_34810;
state_34810 = G__34835;
continue;
} else {
return ret_value__29788__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_$_state_machine__29787__auto__ = function(state_34810){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_$_state_machine__29787__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_$_state_machine__29787__auto____1.call(this,state_34810);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$heads_up_plugin_$_state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_$_state_machine__29787__auto____0;
figwheel$client$heads_up_plugin_$_state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_$_state_machine__29787__auto____1;
return figwheel$client$heads_up_plugin_$_state_machine__29787__auto__;
})()
;})(switch__29786__auto__,c__29898__auto___34827,ch))
})();
var state__29900__auto__ = (function (){var statearr_34826 = f__29899__auto__.call(null);
(statearr_34826[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29898__auto___34827);

return statearr_34826;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29900__auto__);
});})(c__29898__auto___34827,ch))
);


figwheel.client.heads_up.ensure_container.call(null);

return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.enforce_project_plugin = (function figwheel$client$enforce_project_plugin(opts){
return (function (msg_hist){
if(((1) < cljs.core.count.call(null,cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"project-id","project-id",206449307),cljs.core.take.call(null,(5),msg_hist)))))){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different project. Shutting socket down.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__29898__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29898__auto__){
return (function (){
var f__29899__auto__ = (function (){var switch__29786__auto__ = ((function (c__29898__auto__){
return (function (state_34856){
var state_val_34857 = (state_34856[(1)]);
if((state_val_34857 === (1))){
var inst_34851 = cljs.core.async.timeout.call(null,(3000));
var state_34856__$1 = state_34856;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34856__$1,(2),inst_34851);
} else {
if((state_val_34857 === (2))){
var inst_34853 = (state_34856[(2)]);
var inst_34854 = figwheel.client.heads_up.display_system_warning.call(null,"Connection from different project","Shutting connection down!!!!!");
var state_34856__$1 = (function (){var statearr_34858 = state_34856;
(statearr_34858[(7)] = inst_34853);

return statearr_34858;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34856__$1,inst_34854);
} else {
return null;
}
}
});})(c__29898__auto__))
;
return ((function (switch__29786__auto__,c__29898__auto__){
return (function() {
var figwheel$client$enforce_project_plugin_$_state_machine__29787__auto__ = null;
var figwheel$client$enforce_project_plugin_$_state_machine__29787__auto____0 = (function (){
var statearr_34862 = [null,null,null,null,null,null,null,null];
(statearr_34862[(0)] = figwheel$client$enforce_project_plugin_$_state_machine__29787__auto__);

(statearr_34862[(1)] = (1));

return statearr_34862;
});
var figwheel$client$enforce_project_plugin_$_state_machine__29787__auto____1 = (function (state_34856){
while(true){
var ret_value__29788__auto__ = (function (){try{while(true){
var result__29789__auto__ = switch__29786__auto__.call(null,state_34856);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29789__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29789__auto__;
}
break;
}
}catch (e34863){if((e34863 instanceof Object)){
var ex__29790__auto__ = e34863;
var statearr_34864_34866 = state_34856;
(statearr_34864_34866[(5)] = ex__29790__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34856);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34863;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29788__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34867 = state_34856;
state_34856 = G__34867;
continue;
} else {
return ret_value__29788__auto__;
}
break;
}
});
figwheel$client$enforce_project_plugin_$_state_machine__29787__auto__ = function(state_34856){
switch(arguments.length){
case 0:
return figwheel$client$enforce_project_plugin_$_state_machine__29787__auto____0.call(this);
case 1:
return figwheel$client$enforce_project_plugin_$_state_machine__29787__auto____1.call(this,state_34856);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$enforce_project_plugin_$_state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_project_plugin_$_state_machine__29787__auto____0;
figwheel$client$enforce_project_plugin_$_state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_project_plugin_$_state_machine__29787__auto____1;
return figwheel$client$enforce_project_plugin_$_state_machine__29787__auto__;
})()
;})(switch__29786__auto__,c__29898__auto__))
})();
var state__29900__auto__ = (function (){var statearr_34865 = f__29899__auto__.call(null);
(statearr_34865[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29898__auto__);

return statearr_34865;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29900__auto__);
});})(c__29898__auto__))
);

return c__29898__auto__;
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.default_on_jsload = cljs.core.identity;
figwheel.client.default_on_compile_fail = (function figwheel$client$default_on_compile_fail(p__34868){
var map__34875 = p__34868;
var map__34875__$1 = ((((!((map__34875 == null)))?((((map__34875.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34875.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34875):map__34875);
var ed = map__34875__$1;
var formatted_exception = cljs.core.get.call(null,map__34875__$1,new cljs.core.Keyword(null,"formatted-exception","formatted-exception",-116489026));
var exception_data = cljs.core.get.call(null,map__34875__$1,new cljs.core.Keyword(null,"exception-data","exception-data",-512474886));
var cause = cljs.core.get.call(null,map__34875__$1,new cljs.core.Keyword(null,"cause","cause",231901252));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: Compile Exception");

var seq__34877_34881 = cljs.core.seq.call(null,figwheel.client.format_messages.call(null,exception_data));
var chunk__34878_34882 = null;
var count__34879_34883 = (0);
var i__34880_34884 = (0);
while(true){
if((i__34880_34884 < count__34879_34883)){
var msg_34885 = cljs.core._nth.call(null,chunk__34878_34882,i__34880_34884);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_34885);

var G__34886 = seq__34877_34881;
var G__34887 = chunk__34878_34882;
var G__34888 = count__34879_34883;
var G__34889 = (i__34880_34884 + (1));
seq__34877_34881 = G__34886;
chunk__34878_34882 = G__34887;
count__34879_34883 = G__34888;
i__34880_34884 = G__34889;
continue;
} else {
var temp__4425__auto___34890 = cljs.core.seq.call(null,seq__34877_34881);
if(temp__4425__auto___34890){
var seq__34877_34891__$1 = temp__4425__auto___34890;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__34877_34891__$1)){
var c__28344__auto___34892 = cljs.core.chunk_first.call(null,seq__34877_34891__$1);
var G__34893 = cljs.core.chunk_rest.call(null,seq__34877_34891__$1);
var G__34894 = c__28344__auto___34892;
var G__34895 = cljs.core.count.call(null,c__28344__auto___34892);
var G__34896 = (0);
seq__34877_34881 = G__34893;
chunk__34878_34882 = G__34894;
count__34879_34883 = G__34895;
i__34880_34884 = G__34896;
continue;
} else {
var msg_34897 = cljs.core.first.call(null,seq__34877_34891__$1);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_34897);

var G__34898 = cljs.core.next.call(null,seq__34877_34891__$1);
var G__34899 = null;
var G__34900 = (0);
var G__34901 = (0);
seq__34877_34881 = G__34898;
chunk__34878_34882 = G__34899;
count__34879_34883 = G__34900;
i__34880_34884 = G__34901;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(cause)){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str("Error on file "),cljs.core.str(new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(cause)),cljs.core.str(", line "),cljs.core.str(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(cause)),cljs.core.str(", column "),cljs.core.str(new cljs.core.Keyword(null,"column","column",2078222095).cljs$core$IFn$_invoke$arity$1(cause))].join(''));
} else {
}

return ed;
});
figwheel.client.default_on_compile_warning = (function figwheel$client$default_on_compile_warning(p__34902){
var map__34905 = p__34902;
var map__34905__$1 = ((((!((map__34905 == null)))?((((map__34905.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34905.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34905):map__34905);
var w = map__34905__$1;
var message = cljs.core.get.call(null,map__34905__$1,new cljs.core.Keyword(null,"message","message",-406056002));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),[cljs.core.str("Figwheel: Compile Warning - "),cljs.core.str(message)].join(''));

return w;
});
figwheel.client.default_before_load = (function figwheel$client$default_before_load(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: notified of file changes");

return files;
});
figwheel.client.default_on_cssload = (function figwheel$client$default_on_cssload(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded CSS files");

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),cljs.core.pr_str.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files)));

return files;
});
if(typeof figwheel.client.config_defaults !== 'undefined'){
} else {
figwheel.client.config_defaults = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947),new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430),new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036),new cljs.core.Keyword(null,"debug","debug",-1608172596),new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202),new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938),new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128),new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223),new cljs.core.Keyword(null,"eval-fn","eval-fn",-1111644294),new cljs.core.Keyword(null,"retry-count","retry-count",1936122875),new cljs.core.Keyword(null,"autoload","autoload",-354122500),new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318)],[figwheel.client.default_on_compile_warning,figwheel.client.default_on_jsload,true,figwheel.client.default_on_compile_fail,false,true,[cljs.core.str("ws://"),cljs.core.str((cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))?location.host:"localhost:3449")),cljs.core.str("/figwheel-ws")].join(''),figwheel.client.default_before_load,false,false,(100),true,figwheel.client.default_on_cssload]);
}
figwheel.client.handle_deprecated_jsload_callback = (function figwheel$client$handle_deprecated_jsload_callback(config){
if(cljs.core.truth_(new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config))){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,config,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config)),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369));
} else {
return config;
}
});
figwheel.client.base_plugins = (function figwheel$client$base_plugins(system_options){
var base = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"enforce-project-plugin","enforce-project-plugin",959402899),figwheel.client.enforce_project_plugin,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),figwheel.client.file_reloader_plugin,new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),figwheel.client.compile_fail_warning_plugin,new cljs.core.Keyword(null,"css-reloader-plugin","css-reloader-plugin",2002032904),figwheel.client.css_reloader_plugin,new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371),figwheel.client.repl_plugin], null);
var base__$1 = ((cljs.core.not.call(null,figwheel.client.utils.html_env_QMARK_.call(null)))?cljs.core.select_keys.call(null,base,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371)], null)):base);
var base__$2 = ((new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(system_options) === false)?cljs.core.dissoc.call(null,base__$1,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733)):base__$1);
if(cljs.core.truth_((function (){var and__27529__auto__ = new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(system_options);
if(cljs.core.truth_(and__27529__auto__)){
return figwheel.client.utils.html_env_QMARK_.call(null);
} else {
return and__27529__auto__;
}
})())){
return cljs.core.assoc.call(null,base__$2,new cljs.core.Keyword(null,"heads-up-display-plugin","heads-up-display-plugin",1745207501),figwheel.client.heads_up_plugin);
} else {
return base__$2;
}
});
figwheel.client.add_message_watch = (function figwheel$client$add_message_watch(key,callback){
return cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,key,(function (_,___$1,___$2,msg_hist){
return callback.call(null,cljs.core.first.call(null,msg_hist));
}));
});
figwheel.client.add_plugins = (function figwheel$client$add_plugins(plugins,system_options){
var seq__34913 = cljs.core.seq.call(null,plugins);
var chunk__34914 = null;
var count__34915 = (0);
var i__34916 = (0);
while(true){
if((i__34916 < count__34915)){
var vec__34917 = cljs.core._nth.call(null,chunk__34914,i__34916);
var k = cljs.core.nth.call(null,vec__34917,(0),null);
var plugin = cljs.core.nth.call(null,vec__34917,(1),null);
if(cljs.core.truth_(plugin)){
var pl_34919 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__34913,chunk__34914,count__34915,i__34916,pl_34919,vec__34917,k,plugin){
return (function (_,___$1,___$2,msg_hist){
return pl_34919.call(null,msg_hist);
});})(seq__34913,chunk__34914,count__34915,i__34916,pl_34919,vec__34917,k,plugin))
);
} else {
}

var G__34920 = seq__34913;
var G__34921 = chunk__34914;
var G__34922 = count__34915;
var G__34923 = (i__34916 + (1));
seq__34913 = G__34920;
chunk__34914 = G__34921;
count__34915 = G__34922;
i__34916 = G__34923;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq.call(null,seq__34913);
if(temp__4425__auto__){
var seq__34913__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__34913__$1)){
var c__28344__auto__ = cljs.core.chunk_first.call(null,seq__34913__$1);
var G__34924 = cljs.core.chunk_rest.call(null,seq__34913__$1);
var G__34925 = c__28344__auto__;
var G__34926 = cljs.core.count.call(null,c__28344__auto__);
var G__34927 = (0);
seq__34913 = G__34924;
chunk__34914 = G__34925;
count__34915 = G__34926;
i__34916 = G__34927;
continue;
} else {
var vec__34918 = cljs.core.first.call(null,seq__34913__$1);
var k = cljs.core.nth.call(null,vec__34918,(0),null);
var plugin = cljs.core.nth.call(null,vec__34918,(1),null);
if(cljs.core.truth_(plugin)){
var pl_34928 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__34913,chunk__34914,count__34915,i__34916,pl_34928,vec__34918,k,plugin,seq__34913__$1,temp__4425__auto__){
return (function (_,___$1,___$2,msg_hist){
return pl_34928.call(null,msg_hist);
});})(seq__34913,chunk__34914,count__34915,i__34916,pl_34928,vec__34918,k,plugin,seq__34913__$1,temp__4425__auto__))
);
} else {
}

var G__34929 = cljs.core.next.call(null,seq__34913__$1);
var G__34930 = null;
var G__34931 = (0);
var G__34932 = (0);
seq__34913 = G__34929;
chunk__34914 = G__34930;
count__34915 = G__34931;
i__34916 = G__34932;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.start = (function figwheel$client$start(var_args){
var args34933 = [];
var len__28599__auto___34936 = arguments.length;
var i__28600__auto___34937 = (0);
while(true){
if((i__28600__auto___34937 < len__28599__auto___34936)){
args34933.push((arguments[i__28600__auto___34937]));

var G__34938 = (i__28600__auto___34937 + (1));
i__28600__auto___34937 = G__34938;
continue;
} else {
}
break;
}

var G__34935 = args34933.length;
switch (G__34935) {
case 1:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34933.length)].join('')));

}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$1 = (function (opts){
if((goog.dependencies_ == null)){
return null;
} else {
if(typeof figwheel.client.__figwheel_start_once__ !== 'undefined'){
return null;
} else {
figwheel.client.__figwheel_start_once__ = setTimeout((function (){
var plugins_SINGLEQUOTE_ = new cljs.core.Keyword(null,"plugins","plugins",1900073717).cljs$core$IFn$_invoke$arity$1(opts);
var merge_plugins = new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370).cljs$core$IFn$_invoke$arity$1(opts);
var system_options = figwheel.client.handle_deprecated_jsload_callback.call(null,cljs.core.merge.call(null,figwheel.client.config_defaults,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"plugins","plugins",1900073717),new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370))));
var plugins = (cljs.core.truth_(plugins_SINGLEQUOTE_)?plugins_SINGLEQUOTE_:cljs.core.merge.call(null,figwheel.client.base_plugins.call(null,system_options),merge_plugins));
figwheel.client.utils._STAR_print_debug_STAR_ = new cljs.core.Keyword(null,"debug","debug",-1608172596).cljs$core$IFn$_invoke$arity$1(opts);

figwheel.client.add_plugins.call(null,plugins,system_options);

figwheel.client.file_reloading.patch_goog_base.call(null);

return figwheel.client.socket.open.call(null,system_options);
}));
}
}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$0 = (function (){
return figwheel.client.start.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

figwheel.client.start.cljs$lang$maxFixedArity = 1;
figwheel.client.watch_and_reload_with_opts = figwheel.client.start;
figwheel.client.watch_and_reload = (function figwheel$client$watch_and_reload(var_args){
var args__28606__auto__ = [];
var len__28599__auto___34944 = arguments.length;
var i__28600__auto___34945 = (0);
while(true){
if((i__28600__auto___34945 < len__28599__auto___34944)){
args__28606__auto__.push((arguments[i__28600__auto___34945]));

var G__34946 = (i__28600__auto___34945 + (1));
i__28600__auto___34945 = G__34946;
continue;
} else {
}
break;
}

var argseq__28607__auto__ = ((((0) < args__28606__auto__.length))?(new cljs.core.IndexedSeq(args__28606__auto__.slice((0)),(0))):null);
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(argseq__28607__auto__);
});

figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic = (function (p__34941){
var map__34942 = p__34941;
var map__34942__$1 = ((((!((map__34942 == null)))?((((map__34942.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34942.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34942):map__34942);
var opts = map__34942__$1;
return figwheel.client.start.call(null,opts);
});

figwheel.client.watch_and_reload.cljs$lang$maxFixedArity = (0);

figwheel.client.watch_and_reload.cljs$lang$applyTo = (function (seq34940){
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq34940));
});

//# sourceMappingURL=client.js.map