/*
 * Decompiled with CFR 0.152.
 */
package com.factual.honey;

import com.factual.driver.Factual;
import com.factual.driver.Query;
import com.factual.driver.ReadResponse;
import com.factual.driver.Tabular;
import com.factual.honey.parse.SqlParser;
import com.factual.honey.preprocess.Preprocessor;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HoneyStatement {
    private final String sql;
    private final Query query = new Query();
    private final String tableName;
    private boolean explain;
    private boolean isCount;
    private String describe;

    public HoneyStatement(String honeyql) {
        this.sql = this.preprocess(honeyql, this.query);
        this.tableName = this.isDescribe() ? this.describe : this.parseInto(this.sql, this.query);
    }

    private String preprocess(String sql, Query query) {
        Preprocessor prep = new Preprocessor();
        String prepped = prep.preprocess(sql);
        if (prep.hasDescribe()) {
            this.describe = prep.getDescribe();
            return "";
        }
        prep.applyTo(this, query);
        return prepped;
    }

    private String parseInto(String sql, Query query) {
        SqlParser parser = new SqlParser(query);
        parser.parse(sql);
        this.isCount = parser.hasCountFn();
        return parser.getTableName();
    }

    public void setExplain() {
        this.explain = true;
    }

    public boolean isExplain() {
        return this.explain;
    }

    public boolean isDescribe() {
        return this.describe != null;
    }

    public boolean isCount() {
        return this.isCount;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean hasSelectFields() {
        return this.query.getSelectFields() != null;
    }

    public String[] getSelectFields() {
        return this.query.getSelectFields();
    }

    public Tabular execute(Factual factual) {
        if (this.isDescribe()) {
            return factual.schema(this.tableName);
        }
        if (this.isCount()) {
            return this.countResult(factual);
        }
        return factual.fetch(this.tableName, this.query);
    }

    private Tabular countResult(final Factual factual) {
        return new Tabular(){

            public List<Map<String, Object>> getData() {
                return HoneyStatement.this.makeCountData(factual);
            }
        };
    }

    private List<Map<String, Object>> makeCountData(Factual factual) {
        ReadResponse resp = factual.fetch(this.tableName, this.query);
        ArrayList countData = Lists.newArrayList();
        HashMap cell = Maps.newHashMap();
        cell.put("count", resp.getTotalRowCount());
        countData.add(cell);
        return countData;
    }

    public String getExplanation() {
        return "Read table: " + this.tableName + "\n" + this.query.toString();
    }
}

