/*
 * Decompiled with CFR 0.152.
 */
package com.factual.honey;

import com.factual.driver.Factual;
import com.factual.driver.Tabular;
import com.factual.honey.HoneyStatement;
import com.factual.honey.TabularFormatter;
import com.factual.honey.parse.ParseException;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import jline.ConsoleReader;
import jline.History;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public class HoneyCLI {
    private final ConsoleReader consoleReader;
    private Factual factual;
    private History commandHistory;

    public HoneyCLI() {
        try {
            this.ensureHoneyDir();
            this.consoleReader = new ConsoleReader();
            this.controlCmdHistory();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void controlCmdHistory() {
        try {
            this.consoleReader.setUseHistory(false);
            this.commandHistory = new History(new File(this.honeyDir(), "history"));
            this.consoleReader.setHistory(this.commandHistory);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) throws IOException {
        HoneyCLI cli = new HoneyCLI();
        cli.auth();
        cli.repl();
    }

    private void auth() throws IOException {
        if (this.savedAuth()) {
            this.loadAuthFromFiles();
        } else {
            this.getAuthFromUser();
        }
    }

    protected void loadAuthFromFiles() {
        String key = this.readKeyFile();
        String secret = this.readSecretFile();
        this.factual = new Factual(key, secret);
    }

    private void getAuthFromUser() throws IOException {
        String key = this.consoleReader.readLine("Your Factual API Key: ");
        String secret = this.consoleReader.readLine("Your Factual API Secret: ");
        if (this.userWantsAuthSaved()) {
            this.saveAuth(key, secret);
        }
        this.factual = new Factual(key, secret);
    }

    private boolean userWantsAuthSaved() {
        try {
            System.out.print("Save auth in " + this.honeyDir() + "? [Y/n]");
            boolean wants = this.consoleReader.readCharacter(new char[]{'Y', 'n'}) == 89;
            System.out.println();
            return wants;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void saveAuth(String key, String secret) {
        try {
            FileUtils.writeStringToFile((File)this.keyFile(), (String)key);
            FileUtils.writeStringToFile((File)this.secretFile(), (String)secret);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void ensureHoneyDir() {
        try {
            FileUtils.forceMkdir((File)this.honeyDir());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String readSecretFile() {
        return this.read(this.secretFile());
    }

    private String readKeyFile() {
        return this.read(this.keyFile());
    }

    private File keyFile() {
        return this.honeyUserFile("key");
    }

    private File secretFile() {
        return this.honeyUserFile("secret");
    }

    private File honeyUserFile(String filename) {
        return new File(this.honeyDir(), filename);
    }

    private File honeyDir() {
        return new File(System.getProperty("user.home"), ".honey");
    }

    private boolean savedAuth() {
        return this.keyFile().exists();
    }

    private void repl() {
        StringBuilder cmdbuf = new StringBuilder();
        while (true) {
            try {
                while (true) {
                    String line;
                    if (StringUtils.isBlank((String)(line = this.consoleReader.readLine("> ").trim()))) {
                        continue;
                    }
                    if (line.endsWith("\\")) {
                        cmdbuf.append(StringUtils.chop((String)line));
                        continue;
                    }
                    cmdbuf.append(line);
                    String cmd = cmdbuf.toString();
                    cmdbuf = new StringBuilder();
                    this.commandHistory.addToHistory(cmd);
                    this.evaluateLine(cmd);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void evaluateLine(String line) {
        if (line.equals("quit") || line.equals("exit")) {
            System.exit(0);
        }
        try {
            this.evaluateSql(line);
        }
        catch (ParseException pe) {
            String niceMsg = pe.getFirstLineOfMessage();
            if (StringUtils.isBlank((String)niceMsg)) {
                pe.printStackTrace();
            }
            System.out.println(niceMsg);
        }
    }

    protected void evaluateSql(String sql) {
        HoneyStatement stmt = new HoneyStatement(sql);
        if (stmt.isExplain()) {
            this.printExplain(stmt);
        } else {
            this.printResults(stmt);
        }
    }

    private void printResults(HoneyStatement stmt) {
        Tabular table = stmt.execute(this.factual);
        TabularFormatter formatter = new TabularFormatter();
        if (stmt.isDescribe()) {
            formatter.setFirstColumn("name");
        } else if (stmt.hasSelectFields()) {
            formatter.setColumns(Lists.newArrayList((Object[])stmt.getSelectFields()));
        }
        System.out.println();
        System.out.println(formatter.format(table));
    }

    private void printExplain(HoneyStatement stmt) {
        System.out.println(stmt.getExplanation());
    }

    private String read(File file) {
        try {
            return FileUtils.readFileToString((File)file).trim();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

