/*
 * Decompiled with CFR 0.152.
 */
package com.factual.honey.preprocess;

import com.factual.driver.Query;
import com.factual.honey.HoneyStatement;
import com.factual.honey.preprocess.Snip;
import com.factual.honey.preprocess.Snipper;
import org.apache.commons.lang.StringUtils;

public class Preprocessor {
    protected String near;
    protected String search;
    protected boolean explain;
    private String describe;

    public String preprocess(String sql) {
        if (StringUtils.startsWithIgnoreCase((String)sql, (String)"describe")) {
            this.describe = this.parseDescribe(sql);
            return "";
        }
        sql = this.prepExplain(sql);
        sql = this.prepNear(sql);
        sql = this.prepSearch(sql);
        sql = this.prepTableName(sql);
        return sql;
    }

    public boolean hasDescribe() {
        return this.describe != null;
    }

    public String getDescribe() {
        return this.describe;
    }

    private String parseDescribe(String sql) {
        String table = sql.substring(8);
        return table.trim();
    }

    private String prepTableName(String sql) {
        Snip snip = Snipper.in("from ", " ").snip(sql);
        if (snip != null) {
            sql = snip.splice("from " + snip.middle().replace('-', '_') + " ");
        } else {
            snip = Snipper.after("from ").snip(sql);
            if (snip != null) {
                sql = snip.splice(snip.middle().replace('-', '_'));
            }
        }
        return sql;
    }

    private String prepExplain(String sql) {
        if (StringUtils.startsWithIgnoreCase((String)sql, (String)"explain ")) {
            this.explain = true;
            sql = sql.substring(8);
        }
        return sql;
    }

    private String prepSearch(String sql) {
        Snip snip = Snipper.in("search", ")").snip(sql);
        if (snip != null) {
            sql = snip.splice();
            this.search = snip.middle();
            this.search = Snipper.in("'").snip(this.search).middle();
        }
        return sql;
    }

    private String prepNear(String sql) {
        Snip snip = Snipper.in("near", ")").snip(sql);
        if (snip != null) {
            sql = snip.splice();
            this.near = snip.middle();
            this.near = Snipper.in("'").snip(this.near).middle();
        }
        return sql;
    }

    public void applyTo(HoneyStatement stmt, Query query) {
        if (this.explain) {
            stmt.setExplain();
        }
        if (this.near != null) {
            query.near(this.near, 4800);
        }
        if (this.search != null) {
            query.search(this.search);
        }
    }
}

