package jre2;


public class StringUTF8Buffer {
	
	private byte[] bytes;
	private int fillLength = 0;


	public StringUTF8Buffer() {
		this(16);
	}
	
	public StringUTF8Buffer(int capacity) {
		bytes = new byte[capacity];
	}

	public void append(StringUTF8 s) {
		accommodate(s.length());
		System.arraycopy(s.bytes(), s.offset(), bytes, fillLength, s.length());
		fillLength += s.length();
	}

	public void append(byte b) {
		accommodate(1);
		bytes[fillLength] = b;
		fillLength++;
	}

	private void accommodate(int length) {
		if (bytes.length - fillLength < length) {
			int newLength = 2 * (length + bytes.length);
			byte[] newBytes = new byte[newLength];
			System.arraycopy(bytes, 0, newBytes, 0, fillLength);
			bytes = newBytes;
		}
	}
	
	public StringUTF8 toStringUTF8() {
		return new StringUTF8(bytes, 0, fillLength);
	}
}
