package jre2;

import java.nio.charset.Charset;


public class StringUTF8 {

	static final Charset UTF8_CHARSET = Charset.forName("UTF-8"); 
	
	private byte[] bytes;	
	private int offset;
	private int length;


	public StringUTF8(String s) {
		bytes = s.getBytes(UTF8_CHARSET);
		offset = 0;
		length = bytes.length;
	}

	public StringUTF8(StringUTF8 sUTF8, int offset) {
		if (offset < 0 || offset >= sUTF8.length)
			throw new IndexOutOfBoundsException("offset out of bounds");

		bytes = sUTF8.bytes;
		this.offset = sUTF8.offset + offset;
		length = sUTF8.length - offset;
	}

	public StringUTF8(StringUTF8 sUTF8, int offset, int length) {
		if (length < 0 || offset < 0 || offset + length > sUTF8.length)
			throw new IndexOutOfBoundsException("offset or length out of bounds");
		
		bytes = sUTF8.bytes;
		this.offset = sUTF8.offset + offset;
		this.length = length;
	}
	
	public StringUTF8(byte[] bytes, int offset, int length) {
		if (length < 0 || offset < 0 || offset + length > bytes.length)
			throw new IndexOutOfBoundsException("offset or length out of bounds");

		this.bytes = bytes;
		this.offset = offset;
		this.length = length;
	}
	
	
	public byte[] bytes() {
		return bytes;
	}
	
	public int offset() {
		return offset;
	}
	
	public int length() {
		return length;
	}

	
	public String toString() {
		return new String(bytes, offset, length, UTF8_CHARSET);
	}
}
