(ns leafgrabber.free-text.author
  (:use [leafgrabber.free-text.extractor :only (add-ext-group add-enum-regex)]
        [leafgrabber.free-text.author-common :only (review-xpath)]
        )
  (:require [leafgrabber.free-text.author-davidg])
  (:require [leafgrabber.free-text.author-shab])
  (:require [leafgrabber.free-text.author-donall])
  (:require [leafgrabber.free-text.author-gvelez])
  )

(add-ext-group :credit-cards #{:credit-card_1 :not_cash_only_1})
(add-ext-group :cash-only #{:cash_only_1 :cash_only_2 :cash_only_3})
(add-ext-group :cater #{:cater_1 :cater2})
(add-ext-group :deliver #{:deliver_1 :deliver_2})
(add-ext-group :alcohol #{:alcohol_1
                          :alcohol_byob_1
                          :alcohol_bar_1
                          :alcohol_beer-wine_1
                             })
(add-ext-group :prec-parking #{:parking_garage_1
                               :parking_off-street_1
                               :parking_free_1
                               :parking_lot_1
                               :parking_good_1
                               :parking_validated_1
                               :parking_valet_1})
(add-ext-group :friendly-staff #{:friendly-staff_1 :cheerful-staff_1})
(add-ext-group :hours #{:raw_hours_1 :raw_hours_3})

(add-ext-group :round-1
               #{:24-hours_1 :accessible_1 :alcohol_1 :alcohol_beer-wine_1 :alcohol_byob_1 :alcohol_bar_1 :cash_only_1
                 :cash_only_2 :credit-card_1 :not_cash_only_1 :deliver_1 :deliver_2
                 :takeout_1 :groups_1 :kids_1 :meal_breakfast_1 :meal_dinner_1 :meal_gluten-free_1 :meal_halal_1
                 :meal_kosher_1 :meal_lunch_1 :meal_sushi_1 :meal_vegan_1 :meal_vegetarian_1 :outdoor_1 :reservations_1
                 :parking_garage_1 :parking_off-street_1 :parking_free_1 :parking_lot_1 :parking_valet_1
                 :parking_validated_1 :parking_good_1 :wifi_1})

(add-ext-group :meal_type #{:meal_breakfast_1 :meal_dinner_1 :meal_gluten-free_1 :meal_halal_1 :meal_kosher_1
                            :meal_lunch_1 :meal_sushi_1 :meal_vegan_1 :meal_vegetarian_1})
(add-ext-group :round-2
               #{:accessible_1 :cash_only_1 :cash_only_2 :cash_only_3 :not_cash_only_1 :meal_halal_1 :meal_kosher_1 :raw_chef_1 :raw_owner_1
                 :founded_1 :private_room_1 :cater_1 :cater_3 :meal_gluten-free_1 :meal_low-fat_1 :meal_low-salt_1 :meal_organic_1 
                 :meal_healthy_1 :24-hours_restaurant :24-hours_2 :24-hours_3 :smoking_allowed_1 :raw_smoking_any :raw_smoking_details 
                 :live-music_1 :live_music_2  :views_good   
                 :outdoor_1 :reservations_1 :raw_hours_of_operation :raw_price_1 :raw_price_2 :raw_rating_1 }
               )

(add-enum-regex {:name :parking_garage_1
                 :core #"garage"
                 :patterns [[#"=s*\"[^\"]*CORE" "no-evidence"]
                   [#"CORE\?" "no-evidence"]
                            ["do ?no?'?t have (?:a )?(?:parking )?CORE(?: parking)?" false]
                            ["parking CORE" true]
                            ["BusinessParking\">CORE" true]
                            ["park(?:ing)?(?: in (?:a|the))? CORE" true]
                            ["CORE parking" true]]
                 :default "no-evidence"})

(add-enum-regex {:name :parking_off-street_1
                 :core #"off street parking"
                 :default true})

(add-enum-regex {:name :parking_free_1
                 :core #"parking"
                 :patterns [[#"=s*\"[^\"]*CORE" "no-evidence"]
                   [#"CORE\?" "no-evidence"]
                   ["not? (?:free|complimentary) CORE" false]
                            ["(free|complimentary) CORE" true]
                            ["CORE is (free|complimentary)" true]]
                 :default "no-evidence"})

(add-enum-regex {:name :parking_lot_1
                    :core #"parking lot|lot parking"
                    :patterns [
                   [#"=s*\"[^\"]*CORE" "no-evidence"]
                   [#"CORE\?" "no-evidence"]
                   ["not? CORE" false]
                   [#"CORE\s*:\s*yes" true]
                   [#"CORE\s*:" "no-evidence"]
                               ["do(?:es)? ?n(?:'|o)?t have CORE" false]


                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*yes" true]
                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*no" false]
                   [#"CORE\s*(?:<[^>]+>\s*)*:" "no-evidence"]
                    ]
                    :default true})

(add-enum-regex {:name :parking_good_1
                 :core #"parking"
                 :patterns [
                   [#"=s*\"[^\"]*CORE" "no-evidence"]
                   [#"CORE\?" "no-evidence"]
                   ["not? CORE" false]
                            ["easy CORE" true]
                            ["good CORE" true]
                            ["great CORE" true]
                            ["available CORE" true]
                            ["adequate CORE" true]
                            [#"cons?\s*:.{0,20}CORE" false]
                            [#"pros?\s*:.{0,20}CORE" true]]
                 :default "no-evidence"})

(add-enum-regex {:name :parking_valet_1
                 :core #"valet"
                 :patterns [[#"=s*\"[^\"]*CORE" "no-evidence"]
                   [#"CORE\?" "no-evidence"]
                   ["laundry" "no-evidence"]
                   ["not? CORE" false]
                            [#"(?:laundry|cleaning)/? ?CORE" "no-evidence"]
                   [#"CORE(?: parking)?\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*yes" true]
                   [#"CORE(?: parking)?\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*no" false]
                   [#"CORE(?: parking)?\s*(?:<[^>]+>\s*)*:" "no-evidence"]
                 ]
                 :default true})

(add-enum-regex {:name :parking_validated_1
                 :core #"validated? parking|parking(?: is)? validat(?:ed|ion)|with validation"
                 :patterns [[#"=s*\"[^\"]*CORE" "no-evidence"]
                   [#"CORE\?" "no-evidence"]
                   ["not? CORE" false]]
                 :default true})

(add-enum-regex {:name :parking_street_1
                 :core #"street[\-\s]parking|park(?:ing)? on (?:the )?street"
                 :patterns [[#"=s*\"[^\"]*CORE" "no-evidence"]
                   [#"CORE\?" "no-evidence"]
                   ["not? CORE" false]
                            ["off.CORE" false]
                            ["(?:hardly any|very little) CORE" false]]
                 :default true})

(add-enum-regex {:name :kids_1
                 :core #"kid'?s|children('s)?|family|families"
                 :patterns [[#"=s*\"[^\"]*CORE" "no-evidence"]
                   [#"CORE\?" "no-evidence"]
                   ["CORE meal" true]

                   [#"(?:good for )?CORE\s*(?:menu|\-?friendly)?\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*yes" true]
                   [#"(?:good for )?CORE\s*(?:menu|\-?friendly)?\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*no" false]
                   [#"(?:good for )?CORE\s*(?:menu|\-?friendly)?\s*(?:<[^>]+>\s*)*:" "no-evidence"]
                            [#"CORE\s*(?:menu|\-?friendly)" true]
                            ["CORE eat free" true]
                            ["good for CORE" true]
                    ]
                 :default "no-evidence"})

(add-enum-regex {:name :takeout_1
                 :core #"(?:carry|take)[ \-]?out"
                 :patterns [[#"=s*\"[^\"]*CORE" "no-evidence"]
                   [#"CORE\?" "no-evidence"]
                   ["(?:n't|not?|never|no longer) (?:(?:serves?|has|a|have|good for|offers?|do|does) ?)?a? ?CORE" false]
                   ["no CORE" false]
                   ["CORE not available" false]
                   [#"\bnot?\b.*CORE" "no-evidence"]
                   [#"CORE.*\bnot\b" "no-evidence"]
                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*yes" true]
                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*no" false]
                   [#"CORE\s*(?:<[^>]+>\s*)*:" "no-evidence"]
                 ]
                 :default true})

(add-enum-regex {:name :credit-card_1
                 :core #"credit cards?"
                 :patterns [ [ "CORE not accepted" false]
                            [ "no CORE" false]
                            [#"CORE(?: accepted)?\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*(?:no|false)" false]
                            [#"CORE(?: accepted)?\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*(?:yes|visa|mc|mastercard|discover|amex|american express|all|major|true)" true]
                            [#"CORE accepted[^:]*[,\.]" true]
                            [#"accepts(?:\sall)?(?:\smajor)? CORE" true]
                           ]
                 :default "no-evidence"})

(add-enum-regex {:name :not_cash_only_1
                 :core #"cash only"
                 :patterns [[#"=s*\"[^\"]*CORE" "no-evidence"]
                   [#"CORE\?" "no-evidence"]
                   [#"CORE,.*visa" "no-evidence"]
                   [#"visa,.*CORE" "no-evidence"]
                   [ "not? CORE" "no-evidence" ]]
                 :default false})

(add-enum-regex {:name :cash_only_1
                 :core #"cash only"
                 :patterns [[#"=s*\"[^\"]*CORE" "no-evidence"]
                   [#"CORE\?" "no-evidence"]
                   [#"CORE,.*visa" "no-evidence"]
                   [#"visa,.*CORE" "no-evidence"]
                   [ "not? CORE" false ]]
                 :default true})

(add-enum-regex {:name :cash_only_2
                 :core #"credit cards?"
                 :patterns [ [ "CORE not accepted" true]
                            [ "no CORE" true]
                            [#"CORE(?: accepted)?\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*(?:no|false)" true]
                            [#"CORE(?: accepted)?\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*(?:yes|visa|mc|mastercard|discover|amex|american express|all|major|true)" false]
                            [#"CORE accepted[^:]*[,\.]" false]
                            [#"accepts(?:\sall)?(?:\smajor)? CORE" false]
                           ]
                 :default "no-evidence"})

(add-enum-regex {:name :cash_only_3
                 :core #"checks?"
                 :patterns [ [ #"CORE\s+(?:payment\s*)?(?:ok|accepted)" false] 
                           ]
                 :default "no-evidence"})

(add-enum-regex {:name :groups_1
                 :core #"for groups"
                 :patterns [ 
                   [ #"not [^\.]*\s*CORE" "no-evidence" ] 
                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*yes" true]
                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*no" false]
                   [#"CORE\s*(?:<[^>]+>\s*)*:" "no-evidence"]
                  ]
                 :default true})

(add-enum-regex {:name :outdoor_1
                 :core #"(?:out(?:side|door)|patio|garden) (?:seating|tables?|dining|patio)"
                 :patterns [[#"=s*\"[^\"]*CORE" "no-evidence"]
                   [#"CORE\?" "no-evidence"]
                   ["[:/] CORE" "no-evidence"]
                            ["</option> CORE" "no-evidence"]
                            ["</a> CORE" "no-evidence"]
                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*yes" true]
                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*no" false]
                   [#"CORE\s*(?:<[^>]+>\s*)*:" "no-evidence"]
                   ]
                 :default true})

(add-enum-regex {:name :reservations_1
                 :core #"reservations?"
                 :patterns [[#"=s*\"[^\"]*CORE" "no-evidence"]
                   [#"CORE\?" "no-evidence"]
                   [#"CORE for .{0,40}(?:restaurants|locations|venues)" "no-evidence"]
                   [#"(?:made|had|make)\s*(?:a|our|the)? CORE" true]
                            ["</option> CORE" "no-evidence"]
                            ["</a> CORE" "no-evidence"]
                   [#"(?:takes|accepts)\s*?CORE(?: accepted)?\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*yes" true]
                   [#"(?:takes|accepts)\s*?CORE(?: accepted)?\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*no" false]
                   [#"(?:takes|accepts)\s*?CORE(?: accepted)?\s*(?:<[^>]+>\s*)*:" "no-evidence"]
                   [#"(?:not|n't) (?:take|accept)\s*?CORE" false]
                   [#"(?:not|n't|never).{0,30}CORE" "no-evidence"]
                   [#"(?:take|accept)\s*?CORE" true]
                   [#"CORE not accepted" false]
                   [#"CORE accepted" true]
                   ]
                 :default "no-evidence"})

(add-enum-regex {:name :wifi_1
                 :core #"wi[- ]?fi"
                 :patterns [[#"=s*\"[^\"]*CORE" "no-evidence"]
                   [#"CORE\?" "no-evidence"]
                   ["at&t CORE" "no-evidence"]
                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*yes" true]
                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*no" false]
                   [#"CORE\s*(?:<[^>]+>\s*)*:" "no-evidence"]
                  ]
                 :default true})

(add-enum-regex {:name :cater_1
                 :core #"caterers|catering"
                :patterns [[#"=s*\"[^\"]*CORE" "no-evidence"]
                   [#"navmenu" "no-evidence"]
                   [#"CORE\?" "no-evidence"]
                   [#"CORE restaurants" "no-evidence"]
                   [#"find(?: a)? CORE" "no-evidence"]
                   [#"CORE menu" true]
                   ["CORE food services" "no-evidence"]
                   ["get information, directions and reviews" "no-evidence"]
                   ["find (?:restaurants|locations|venues)" "no-evidence"]
                   [#"(?:\bnot?|n't) CORE" "no-evidence"]
                  ]
                 :default true})


(add-enum-regex {:name :cater_3
                 :core #"cater(?:ed)?"
                 :patterns [
                            ["(?:we|they) CORE" true]
                            ["CORE (our|my|the|lunch|dinner)" true]
                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*yes" true]
                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*no" false]
                   [#"CORE\s*(?:<[^>]+>\s*)*:" "no-evidence"]
                           ]
                 :default "no-evidence"})


(add-enum-regex {:name :cater_2
                 :core #"catering"
                 :context 10
                 :patterns [[#"=s*\"[^\"]*CORE" "no-evidence"]
                   [#"CORE\?" "no-evidence"]
                   ["CORE services" true]
                   [#"CORE (service)? (was|is)" true]
                   ["CORE menu" true]

                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*yes" true]
                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*no" false]
                 ]
                 :default "no-evidence"})

(add-enum-regex {:name :deliver_1
                 :core #"delivery"
                 :patterns [[#"=s*\"[^\"]*CORE" "no-evidence"]
                   [#"CORE\?" "no-evidence"]
                            ["minimum order for CORE" true]
                            ["all day CORE" true]
                            ["call for CORE" true]
                            ["all day CORE" true]
                            ["CORE hours" true]
                            ["CORE until" true]
                            ["CORE only" true]
                            ["CORE all day" true]
                            ["CORE order online" true]
                            [#"waited ([^\.]*)? for CORE" true]
                   [#"CORE(?: service)?\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*yes" true]
                   [#"online CORE(?: service)?\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*no" "no-evidence"]
                   [#"CORE(?: service)?\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*no" false]
                            [#"CORE(?: service)?\s*(?:<[^>]+>\s*)*[:/]" "no-evidence"]
                   ["take-out & CORE" true]
                   [#"CORE service" true]
                   ["free CORE" true]
                 ]
                 :default "no-evidence"})

(add-enum-regex {:name :deliver_2
                 :core #"delivers?"
                 :patterns [[#"=s*\"[^\"]*CORE" "no-evidence"]
                   [#"CORE\?" "no-evidence"]
                   [#"(?:we|they)(?:'ll|\scan|\swill)?(?:\salso|\seven) CORE" true]
                            ["CORE for free" true]
                            ["we CORE" true]
                            ["now CORE" true]
                            ["also CORE" true]
                            ["do CORE" true]
                            ["(?:may|would|did) not" "no-evidence"]
                            ["to your address" "no-evidence"]
                            ["does not CORE" "no-evidence"]
                            ["don'?t CORE" false]
                            ["do not CORE" false]
                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*yes" true]
                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*no" false]
                 ]
                 :default "no-evidence"})

(add-enum-regex {:name :meal_kosher_1
                 :core #"kosher"
                 :patterns [[#"=s*\"[^\"]*CORE" "no-evidence"]
                   [#"CORE\?" "no-evidence"]
                   [#"glatt CORE" true]
                   [#"non\-? ?CORE" false]
                            ["(?:n't|\bnot?|never|no longer) (?:(?:serves?|has|a|have|good for|offers?) ?)?a? CORE" false]
                   ["not CORE" false]
                   ["CORE pickle" "no-evidence"]
                   [#"not [^\.]+ CORE" "no-evidence"]
                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*yes" true]
                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*no" false]
                   [#"CORE\s*(?:<[^>]+>\s*)*:" "no-evidence"]
                   [#"(?:n't\b|not)(?:.{0,50})?CORE" "no-evidence"]
                 ]
                 :default true})

(add-enum-regex {:name :meal_halal_1
                 :core #"halal"
                 :patterns [[#"=s*\"[^\"]*CORE" "no-evidence"]
                   [#"CORE\?" "no-evidence"]
                   [#"(?:non|not)\-? ?CORE" false]
                   ["(?:n't|\bnot?|never|no longer) (?:(?:serves?|has|a|have|good for|offers?) ?)?a? CORE" false]
                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*yes" true]
                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*no" false]
                   [#"CORE\s*(?:<[^>]+>\s*)*:" "no-evidence"]
                   [#"(?:n't\b|not)(?:.{0,50})?CORE" "no-evidence"]
                 ]
                 :default true})

(add-enum-regex {:name :meal_vegetarian_1
                 :core #"vegetarian"
                 :patterns [[#"=s*\"[^\"]*CORE" "no-evidence"]
                   [#"CORE\?" "no-evidence"]
                   [#"(?:do(?:n't)|aren't)(?:\s*\S+)? any? CORE" false]
                            [#"CORE \-? ?not" false]
                            [#"(?:am|be|was) (?:a )? vegetarian" "no-evidence"]
                            [#"has|is|(?:lots|plenty|selection) of CORE" true]
                            [#"vegetarian restaurants" "no-evidence"]
                            [#"CORE \-?friendly|options?|entrees?|selections?" true]
                            [#"CORE unfriendly" false]
                            [#"CORE (?:\S+ is|it's) not" false]
                            ["(?:n't|\bnot?|never|no longer) (?:(?:serves?|has|a|have|good for|offers?) ?)?a? ?CORE" false]
                            ["CORE's nightmare" false]
                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*yes" true]
                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*no" false]
                   [#"CORE\s*(?:<[^>]+>\s*)*:" "no-evidence"]
                         ]
                 :default true})

(add-enum-regex {:name :meal_vegan_1
                 :core #"vegan"
                 :patterns [[#"=s*\"[^\"]*CORE" "no-evidence"]
                   [#"CORE\?" "no-evidence"]
                   [#"non\-? ?CORE" false]
                            [#"(?:doesn't|not|aren't) \S+ any CORE" false]
                            [#"CORE \-? ?not" false]
                            [#"CORE unfriendly" false]
                            [#"CORE (?:\S+ is|it's) not" false]
                            [#"has|is|(?:lots|plenty|selection) of CORE" true]
                            [#"CORE friendly|options?|entrees?|selections?" true]
                            ["(?:n't|\bnot?|never|no longer) (?:(?:serves?|has|a|have|good for|offer) ?)?a? ?CORE" false]
                            [#"CORE's nightmare" false]
                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*yes" true]
                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*no" false]
                   [#"CORE\s*(?:<[^>]+>\s*)*:" "no-evidence"]
                       ]
                    :default true})

(add-enum-regex {:name :meal_gluten-free_1
                    :core #"gluten[\-\s]free"
                    :patterns [[#"=s*\"[^\"]*CORE" "no-evidence"]
                   [#"CORE\?" "no-evidence"]
                   ["(?:n't|\bnot?|never|no longer) (?:(?:serves?|has|a|have|good for|offers?) ?)?a? ?CORE" false]
                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*yes" true]
                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*no" false]
                   [#"CORE\s*(?:<[^>]+>\s*)*:" "no-evidence"]
                     ]
                    :default true})

(add-enum-regex {:name :meal_low-fat_1
                    :core #"low[\-\s]fat"
                    :patterns [[#"=s*\"[^\"]*CORE" "no-evidence"]
                   [#"CORE\?" "no-evidence"]
                   ["(?:n't|\bnot?|never|no longer) (?:(?:serves?|has|a|have|good for|offers?) ?)?a? ?CORE" false]
                               ["(?:(?:serves?|has|have|is|are|good for|offers?) ?)?a? ?CORE" true]

                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*yes" true]
                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*no" false]
                    ]
                    :default "no-evidence"})

(add-enum-regex {:name :meal_low-salt_1
                    :core #"low[\-\s](?:salt|sodium)"
                    :patterns [[#"=s*\"[^\"]*CORE" "no-evidence"]
                   [#"CORE\?" "no-evidence"]
                   ["(?:n't|\bnot?|never|no longer) (?:(?:serves?|has|a|have|good for|offers?) ?)?a? ?CORE" false]
                               ["(?:(?:serves?|has|have|is|are|good for|offers?) ?)?a? ?CORE" true]

                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*yes" true]
                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*no" false]
                    ]
                    :default "no-evidence"})

(add-enum-regex {:name :meal_organic_1
                    :core #"organic[\-\s]?\s*(?:option|entree|cuisine|produce|ingredient|food|choice|offering|menu item)s?"
                    :patterns [[#"=s*\"[^\"]*CORE" "no-evidence"]
                              ["data-type" "no-evidence"]
                   [#"CORE\?" "no-evidence"]
                   ["(?:n't|\bnot?|never|no longer) (?:(?:serves?|has|a|have|good for|offers?) ?)?a? ?CORE" false]
                   [#"(?:n't|not|no).{0,30}CORE" "no-evidence"]
                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*yes" true]
                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*no" false]
                   [#"CORE\s*(?:<[^>]+>\s*)*:" "no-evidence"]
                    ]
                    :default true})

(add-enum-regex {:name :meal_healthy_1
                    :core #"\bhealth(?:y|ful)?[\-\s](?:option|food|choice|menu|item|alternative|meal)s?"
                    :patterns [[#"=s*\"[^\"]*CORE" "no-evidence"]
                   [#"CORE\?" "no-evidence"]
                   ["unCORE" "no-evidence"]
                   ["(?:n't|\bnot?|never|no longer) (?:(?:serves?|has|a|have|good for|offers?) ?)?a? ?CORE" false]

                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*yes" true]
                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*no" false]
                   [#"CORE\s*(?:<[^>]+>\s*)*:" "no-evidence"]
                    ]
                    :default true})

(add-enum-regex {:name :meal_healthy_2
                    :core #"\bheart-healthy\b"
                    :patterns [[#"=s*\"[^\"]*CORE" "no-evidence"]
                   [#"CORE\?" "no-evidence"]
                   ["unCORE" "no-evidence"]
                   ["(?:n't|\bnot?|never|no longer) (?:(?:serves?|has|a|have|good for|offers?) ?)?a? ?CORE" false]

                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*yes" true]
                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*no" false]
                   [#"CORE\s*(?:<[^>]+>\s*)*:" "no-evidence"]
                    ]
                    :default true})

(add-enum-regex {:name :meal_sushi_1
                    :core #"sushi"
                    :patterns [[#"=s*\"[^\"]*CORE" "no-evidence"]
                   [#"CORE\?" "no-evidence"]
                   ["(?:n't|\bnot?|never|no longer) (?:(?:serves?|has|a|have|good for|offers?) ?)?a? ?CORE" false]

                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*yes" true]
                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*no" false]
                   [#"CORE\s*(?:<[^>]+>\s*)*:" "no-evidence"]
                 ]
                    :default true})

(add-enum-regex {:name :meal_breakfast_1
                    :core #"breakfast"
                    :patterns [[#"=s*\"[^\"]*CORE" "no-evidence"]
                   [#"range from.*CORE" "no-evidence"]
                   [#"CORE\?" "no-evidence"]
                   [#"wish [^\.] CORE" "no-evidence"]
                   ["(?:n't|\bnot?|never|no longer) (?:(?:serves?|has|a|have|good for|offers?) ?)?a? ?CORE" false]

                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*yes" true]
                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*no" false]
                   [#"CORE\s*(?:<[^>]+>\s*)*:" "no-evidence"]
                    ]
                    :default true})

(add-enum-regex {:name :meal_lunch_1
                    :core #"lunch"
                    :patterns [[#"=s*\"[^\"]*CORE" "no-evidence"]
                   [#"CORE\?" "no-evidence"]
                   [#"range from.*CORE" "no-evidence"]
                   [#"wish [^\.] CORE" "no-evidence"]
                   ["CORE (from leftovers|for tomorrow|for the next day)" "no-evidence"]
                   ["(?:n't|\bnot?|never|no longer) (?:(?:serves?|has|a|have|good for|offers?) ?)?a? ?CORE" false]

                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*yes" true]
                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*no" false]
                   [#"CORE\s*(?:<[^>]+>\s*)*:" "no-evidence"]
                   ]
                    :default true})

(add-enum-regex {:name :meal_dinner_1
                    :core #"(dinner|supper)"
                    :patterns [[#"=s*\"[^\"]*CORE" "no-evidence"]
                   [#"CORE\?" "no-evidence"]
                   [#"range from.*CORE" "no-evidence"]
                   [#"wish [^\.] CORE" "no-evidence"]
                   ["(?:n't|\bnot?|never|no longer) (?:(?:serves?|has|a|have|good for|offers?) ?)?a? ?CORE" false]

                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*yes" true]
                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*no" false]
                   [#"CORE\s*(?:<[^>]+>\s*)*:" "no-evidence"]
                    ]
                    :default true})

(add-enum-regex {:name :alcohol_1
                 :core #"alcohol"
                 :patterns [[#"=s*\"[^\"]*CORE" "no-evidence"]
                   [#"CORE\?" "no-evidence"]
                   ["(?:does not|doesn't|don't|no longer) serve CORE" false]
                            ["serve CORE" true]
                            [#"CORE\s?:\s?(?:served|yes)" true]
                            [#"\bnot? CORE" false]
                            [#"CORE\s?:\s?(?:none served|no)" false]
                            ["blood CORE" "no-evidence"]
                            ["CORE content" "no-evidence"]
                   [#"CORE(?:\s+served)?(?:\s*<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*yes" true]
                   [#"CORE(?:\s+served)?(?:\s*<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*no" false]
                   [#"CORE served\s*[^\s:]" true]
                   [#"CORE(?:\s*<[^>]+>)*\s*:" "no-evidence"]
                  ]
                 :default "no-evidence"})

(add-enum-regex {:name :alcohol_byob_1
                    :core #"(?:b[\.\-\s]?y[\.\-\s]?o[\.\-\s]?[bw][\.\-\s]?)|(?:Bring[\-\s]?Your[\-\s]?Own[\-\s]?(?:booze|beer|wine|liquor|alcohol))"
                    :patterns [[#"=s*\"[^\"]*CORE" "no-evidence"]
                   [#"CORE\?" "no-evidence"]
                   ["no more CORE" false]
                               ["(?:n't|\bnot?|never|no longer) (?:(?:serves?|has|a|have|good for|offers?) ?)?a? ?CORE" false]

                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*yes" true]
                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*no" false]
                   [#"CORE\s*(?:<[^>]+>\s*)*:" "no-evidence"]
                 ]
                    :default true})

(add-enum-regex {:name :alcohol_beer-wine_1
                    :core #"(?:beer|wine)[\-\s](?:and|&|\+|n)[\-\s](?:beer|wine)"
                    :patterns [[#"=s*\"[^\"]*CORE" "no-evidence"]
                   [#"CORE\?" "no-evidence"]
                   ["no more CORE" false]
                               ["(?:n't|\bnot?|never|no longer) (?:(?:serves?|has|a|have|good for|offers?) ?)?a? ?CORE" false]

                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*yes" true]
                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*no" false]
                   [#"CORE\s*(?:<[^>]+>\s*)*:" "no-evidence"]
                     ]
                    :default true})

(add-enum-regex {:name :alcohol_bar_1
                    :core #"\b(?:full bar|bartender|from the bar)\b"
                    :patterns [[#"=s*\"[^\"]*CORE" "no-evidence"]
                   [#"CORE\?" "no-evidence"]
                   ["(?:juice|coffee|breakfast|cafe)" "no-evidence"]
                               ["(?:n't|\bnot?|never|no (?:more|longer)) (?:(?:serves?|has|a|have|good for|offers?) ?)?a? ?CORE" false]

                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*yes" true]
                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*no" false]
                   [#"CORE\s*(?:<[^>]+>\s*)*:" "no-evidence"]
                    ]
                    :default true})

(add-enum-regex {:name :accessible_1
                 :core #"(?:handicap(?:ped)?|wheelchair|disabled)[\s\-]+access(?:ible)?"
                 :patterns [[#"=s*\"[^\"]*CORE" "no-evidence"]
                   [#"CORE\?" "no-evidence"]
                            [#"CORE \s*[,\.]" true]
                            ["not CORE" false]
                            ["not? CORE" false]
                            ["is CORE" true]
                            ["easy CORE" true]
                            ["CORE enforcement" "no-evidence"]

                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*yes" true]
                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*no obstacles" true]
                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*no" false]
                   [#"CORE\s*(?:<[^>]+>\s*)*:" "no-evidence"]

                     ]
                 :default "no-evidence"})

(add-enum-regex {:name :24-hours_1
                 :core #"(?:open(?: daily)?|hours[: ]*(?:<[^>]+>)*|daily:?) (?:24[ -](?:hours?|hrs\.?))"
                 :patterns [[#"=s*\"[^\"]*CORE" "no-evidence"]
                   [#"CORE\?" "no-evidence"]
                   [#"\batm\b" "no-evidence"]
                   [#"(?:many|locations).{0,30}CORE" "no-evidence"]
                   ["(?:not|n't) CORE" false]
                           [#"(?:should be|(?:mon(?:day)?|tue(?:sday)?|wed(?:nesday)?|thu(?:rsday)?|fri(?:day)?|sat(?:urday)?|sun(?:day)?):?|day</dt>\s+<dd>)\s*CORE", "no-evidence"]
                   [#"(?:few|some|number of|not all) (?:stores|locations|venues).*CORE" "no-evidence"]
                   [#"CORE\s+on" "no-evidence"]

                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*yes" true]
                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*no" false]
                   [#"CORE\s*(?:<[^>]+>\s*)*:" "no-evidence"]
                    ]
                 :default true})

(add-enum-regex {:name :24-hours_restaurant
                 :core #"(?:open(?: daily)?|hours[: ]*(?:<[^>]+>)*|daily:?) (?:24[ -](?:hours?|hrs\.?))"
                 :patterns [[#"=s*\"[^\"]*CORE" "no-evidence"]
                   [#"CORE\?" "no-evidence"]
                   [#"\batm\b" "no-evidence"] 
                   [#"(?:many|locations).{0,30}CORE" "no-evidence"]
                   [#"(?:front desk|switchboard).{0,30}CORE" "no-evidence"]
                   ["(?:not|n't) CORE" false]
                           [#"(?:should be|(?:mon(?:day)?|tue(?:sday)?|wed(?:nesday)?|thu(?:rsday)?|fri(?:day)?|sat(?:urday)?|sun(?:day)?):?|day</dt>\s+<dd>)\s*CORE", "no-evidence"]
                   [#"(?:few|some|number of|not all) (?:stores|locations|venues).*CORE" "no-evidence"]
                   [#"CORE\s+on" "no-evidence"]

                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*yes" true]
                   [#"CORE\s*(?:<[^>]+>\s*)*:\s*(?:<[^>]+>\s*)*no" false]
                   [#"CORE\s*(?:<[^>]+>\s*)*:" "no-evidence"]
                    ]
                 :default true})

(add-enum-regex {:name :24-hours_2
                 :core #"24[/-]7"
                 :patterns [[#"=s*\"[^\"]*CORE" "no-evidence"]
                   [#"CORE\?" "no-evidence"]
                   [#"\batm\b" "no-evidence"]
                   [#"CORE\s+on" "no-evidence"]
                   [#"(?:few|some|number of|not all) (?:stores|locations|venues).*CORE" "no-evidence"]
                   ["should be open CORE" "no-evidence"]
                            ["open CORE" true]
                            ["(?:not|aren't)(?: open)? CORE" false]]
                 :default "no-evidence"})

(add-enum-regex {:name :24-hours_3
                 :core #"(?:hours of operation|business hours|hours\s?:)"
                 :patterns [[#"=s*\"[^\"]*CORE" "no-evidence"]
                   [#"CORE\?" "no-evidence"]
                   [#"\batm\b" "no-evidence"]
                   [#"(?:<[^>]+>)*\s*24[ -](?:hours?|hrs\.?) CORE" true]
                            [#"CORE .{0,75}\d{1,2}(?::\d{2}|(?:a\.?m\.?|p\.?m\.?))" false]]
                 :context 80
                 :default "no-evidence"})

(add-enum-regex {:name :smoking_allowed_1
                 :core #"smoking"
                 :patterns [[#"=s*\"[^\"]*CORE" "no-evidence"]
                   [#"CORE\?" "no-evidence"]
                   [#"CORE[/,]\s*non[\s\-]CORE" true]
                   [#"CORE (?:and|or) non[\s\-]CORE" true]
                   [#"\bno CORE" false]
                   [#"CORE(\/dining)? (?:section|area|outside|permitted|allowed)" true]
                   [#"\bCORE yes" true]
                   [#"non[\s\-]CORE" false]
                 ]              
                 :default "no-evidence"})

(add-ext-group :restaurant_smoking #{:raw_smoking_any :raw_smoking_details})

(add-enum-regex {:name :raw_smoking_any
                 :core "smoking(?!:)"
                 :patterns [["non?[- ]?CORE (?:area|section|room)" "area"]
                            ["non?[- ]?CORE" false]
                            ["CORE (no|is not allowed)" false]
                            ["CORE(?: yes)?," true]
                            ["CORE (?:allowed|permitted)(?!:)" true]
                            ["CORE area \\(patio only\\)" "patio"]
                            ["no longer have a CORE" false]
                            ["CORE section" "section"]
                            ["CORE area(?![<:])" "area"]
                            ]
                 :default "no-evidence"})

(add-enum-regex {:name :raw_smoking_details
                 :core "smoking(?: allowed| permitted| area)?:"
                 :patterns [["CORE(?:&nbsp:|\\s)*(?:<[^>]+>(?:\\s|&nbsp;)*){0,3}([^<\\t\\n]+)\\s*[<,]" 1]
                            ]
                 :default "no-evidence"})

(add-enum-regex {:name :private_room_1
                 :core #"private (?:party )?rooms?"
                 :patterns [[#"=s*\"[^\"]*CORE" "no-evidence"]
                   [#"CORE\?" "no-evidence"]
                   [#"(?:\bno|(?:not|n't) have ?(?:a|any)?) CORE" false]
                 ]
                 :default true })

(add-enum-regex {:name :slow-service_1
                 :core #"service"
                 :patterns [[#"=s*\"[^\"]*CORE" "no-evidence"]
                   [#"CORE\?" "no-evidence"]
                   
                   [#"CORE (?:was|is|can be) ?(?:rude and )?(?:horribly|very|incredibly|always|seem(?:s|ed))? slow" true]
                   [#"CORE (?:was|is) (?:(?:very|always|incredibly|pretty|friendly and|attentive and|seem(?:s|ed)?) )*(?:fast|quick|efficient)" false]
                   ["took forever|terrible CORE" true]
                   [#"(?:no|not|n't).{0,30}CORE" "no-evidence"]
                   [#"CORE.{0,30}(?:no|not|n't)" "no-evidence"]
                   [#"\b(?:fast|efficient|quick) CORE" false]
                   [#"\bslow CORE" true]
                 ]
                 :default "no-evidence"})

(add-enum-regex {:name :small-portions_1
                 :core #"portions"
                 :patterns [[#"=s*\"[^\"]*CORE" "no-evidence"]
                   [#"CORE\?" "no-evidence"]
                   [#"(?:\bnot?|n't).{0,40} CORE" "no-evidence"]
                   [#"(?:small|tiny|miniscule|itty-bitty|stingy) CORE" true]
                   [#"(?:large|generous|huge|giant) CORE" false]
                   [#"CORE (are|were) (?:small|tiny|miniscule|itty-bitty|stingy)" true]
                   [#"CORE (are|were) not small" false]
                   [#"CORE (are|were) (?:large|generous|huge|giant)" false]
                 ]
                 :default "no-evidence"})

(add-enum-regex {:name :live-music_1
                 :core #"live (?:music|band|jazz|country)"
                 :patterns [[#"=s*\"[^\"]*CORE" "no-evidence"]
                   [#"CORE\?" "no-evidence"]
                   ["no(?:t| longer have)? CORE" false]
                            ["wasn't (?:any)? CORE" false]
                            [#"(?:did|do)n\'?t have(?: a)? CORE" false]]
                 :default true})

(add-enum-regex {:name :long-line_1
                 :core #"(?:long|slow|huge) lines?"   ; 'line' by itself is too widely used in markup
                 :patterns [[#"=s*\"[^\"]*CORE" "no-evidence"]
                   [#"CORE\?" "no-evidence"]
                   ["not? CORE" false]
                            ["n't CORE" false]
                            [#"CORE\-? ?not" false]
                            ["CORE (?:did|were|are|is)n't" "no-evidence"]
                            [#"expected.{0,30} CORE" "no-evidence"]
                            ["skip.{0,30} CORE" "no-evidence"]]
                 :default true})

(add-enum-regex {:name :long-line_2
                 :core #"(?:short|no|quick|fast) lines?"  
                 :default false})

(add-enum-regex {:name :long-line_3
                 :core #"lines? (?:is|are|were|seem(?:ed)?)"
                 :patterns [[#"=s*\"[^\"]*CORE" "no-evidence"]
                   [#"CORE\?" "no-evidence"]
                   ["CORE long" true]
                            ["CORE slow" true]
                            ["CORE short" false]
                            ["CORE quick" false]
                            ["CORE fast" false]]
                 :default "no-evidence"})

(add-enum-regex {:name :long-line_4
                 :core #"(?:stand|wait)(?:ing) in line"
                 :patterns [[#"=s*\"[^\"]*CORE" "no-evidence"]
                   [#"CORE\?" "no-evidence"]
                   ["long CORE" true]
                            ["not? CORE" false]
                            ["short CORE" false]
                            ["quick CORE" false]
                            ["CORE (?:for|seemed|took)? ?(?:what seemed like) ?(?:a|an)? ?(?:long|forever|hours?)" true]
                            ["CORE didn't take long" false]]
                 :default "no-evidence"}) 

(add-enum-regex {:name :views_good
                 :core #"views|the view"
                 :patterns [[#"=s*\"[^\"]*CORE" "no-evidence"]
                   [#"CORE\?" "no-evidence"]
                   [#"(?:good|awesome|great|fabulous|excellent|amazing|beautiful|pretty|unforgettable|sunset|go for the) CORE" true]
                   [#"CORE (?:was|were|is|was|are) (?:good|awesome|great|excellent|fabulous|beautiful|pretty|amazing|wonderful|unforgettable|sunset|worth it)" true]
                   [#"(?:with|enjoy(?:ed)?) CORE of" true]
                  ]
                 :default "no-evidence"})

(add-enum-regex {:name :meal_all-you-can-eat_1
                 :core #"all[\-\s]?you[\-\s]?can[\-\s]?eat"
                 :default true})

(add-ext-group :social_media #{:facebook :youtube :twitter-handle_recall})

(add-enum-regex {:name :facebook
                 :core "facebook\\.com/"
                 :patterns [["CORE[^ '\"]+\\." "no-evidence"]
                            ["CORE([^ '\"\\?#]+)['\"\\?#]" 1]]
                 :default "no-evidence"
                 :filter #{"select"}})

(add-enum-regex {:name :youtube
                 :core "youtube\\.com/user/"
                 :patterns [["CORE([^ '\"#\\?%/]+)['\"#\\?%/]" 1]]
                 :default "no-evidence"
                 :filter #{"select"}})

(add-enum-regex {:name :twitter-handle_recall
                 :core "twitter\\.com/[@!#/]*"
                 :patterns [[#"CORE([^ /\?'\"%]+)['\"%]" 1]]
                 :default "no-evidence"
                 :filter #{"select"}})

(add-enum-regex {:name :has-yellowbook-twitter
                 :core #"Twitter Account Name"
                 :default true
                 :filter #{"script" "select"}})

(add-enum-regex {:name :friendly
                 :core "friendly"
                 :default "no-evidence"
                 :patterns [["CORE (\\w+)" 1]]
                 :only-xpath review-xpath
                 :content-only true})

(add-enum-regex {:name :friendly-staff_1
                 :core #"friendly"
                 :default true
                 :patterns [[#"=s*\"[^\"]*CORE" "no-evidence"]
                   [#"CORE\?" "no-evidence"]
                   ["-CORE" "no-evidence" 1]
                            ["CORE-" "no-evidence" 1]
                            ["CORE'" "no-evidence" 1]
                            ["wheelchair CORE" "no-evidence" 1]
                            ["kid CORE" "no-evidence" 1]]})

(add-enum-regex {:name :cheerful-staff_1
                 :core #"cheerful"
                 :default true})

(add-enum-regex {:name :attire_casual_1
                 :core "casual"
                 :default "no-evidence"
                 :patterns [[#"=s*\"[^\"]*CORE" "no-evidence"]
                   [#"CORE\?" "no-evidence"]
                   ["attr-RestaurantsAttire\">CORE" true]]})


