(ns leafgrabber.free-text.author-shab
  (:use [leafgrabber.free-text.extractor :only (add-ext-group add-enum-regex)]
        )
  )

(add-enum-regex {:name :live_music_2
                 :core #"live music"
                 :patterns [
                            [#"CORE\s*(?:<[^>]+>\s*)*\s*(?:<[^>]+>\s*)*no" false]
                            ["bands, CORE, original bands" "no-evidence"]
                            ["festivals, CORE, and other things to do near you" "no-evidence"]
                            [#"shows,\s*CORE,\s*sports events" "no-evidence"]
                            [#"guide.+CORE" "no-evidence"]
                            [#"content=[^<]*CORE" "no-evidence"]
                            [#"find.+CORE" "no-evidence"]
                            ]
                 :default true})

(add-enum-regex {:name :meal_kosher_3
                 :core #"kosher"
                 :patterns [
                           ["non-CORE" false]
                           ["CORE food directory" "no-evidence"]
                           ["get more CORE restaurants" "no-evidence"]
                           [#"where do.+CORE" "no-evidence"]
                           [#"CORE menus,\s*[^>]+menus" "no-evidence"]
                           ["CORE blog" "no-evidence"]
                           [#"italian,\s*japanese,\s*CORE,\s*mexican" "no-evidence"]
                           [#"(?: supporting|any) CORE (traveler|community|options)" "no-evidence"]
                           [#"\/[^>]+CORE[^>]+\/" "no-evidence"]
                           [#"(alt|content)=[^<]*CORE" "no-evidence"]
                           ]
                 :default true})


(add-enum-regex {:name :meal_organic
                       :core #"organic"
                       :patterns [
                                 [#"\/[^>]+CORE[^>]+\/" "no-evidence"]
                                 [#"data-type=\s*\"\s*CORE\s*\"" "no-evidence"]
                                 [#"CORE\s*\"\s*data" "no-evidence"]
                                 [#"guide.+CORE" "no-evidence"]
                                 ["CORE.+directory" "no-evidence"]
                                 ]
                       :default true})

(add-enum-regex {:name :meal_lowfat_1
                 :core #"low fat"
                 :patterns [
                           [#"(1%|2%)\s*CORE\s*(?:chocolate)?\s*Milk" "no-evidence"]
                           [#"CORE.+dressing" "no-evidence"]
                           [#"CORE (ranch|thousand isand|blue cheese|balsamic|dijon)" "no-evidence"]
                           ]
                 :default true})

