(defproject factual/leafgrabber "1.0.1-SNAPSHOT"
  :description "Page analysis for structured content"
  :repositories {"factual" "http://maven.corp.factual.com/nexus/content/groups/public/"
                 "releases" "http://maven.corp.factual.com/nexus/content/repositories/releases"
                 "snapshots" "http://maven.corp.factual.com/nexus/content/repositories/snapshots"
                }
  :omit-default-repositories true
  :jar-exclusions [#"\.git"
                   #"(?:^|/).svn/" #"(?:^|/).DS_Store"]
  :dependencies [[org.clojure/clojure "1.3.0"]
                 [org.clojure/data.json "0.1.0"]
                 [org.clojure/tools.cli "0.1.0"]
                 [org.clojure/tools.logging "0.2.3"]
                 [org.clojure/math.combinatorics "0.0.2"]
                 [factual/mozilla-parser "0.3.0"]
                 [clj-http "0.2.7"]
                 [dom4j/dom4j "1.6.1"]
                 [factual/juiceful "1.1.2"]
                 [factual/cascalog-commons "1.1.1"]
                 [cascalog "1.8.6"]
                 [jline/jline "0.9.94"]
                 [clj-time "0.3.0"]
                 [org.apache.hadoop/hadoop-core "0.20.2-dev"]
                 [xalan "2.7.1"]
                 [clojure-opennlp "0.1.7"]
                 [egamble/let-else "1.0.3"]
                 [factual/jre2 "1.0.3"]
                 [jackknife "0.1.1"]
                 [factual/jagave "1.0-2012-04-20"]]
  :jvm-opts ["-Xmx1G"]
  :aot [leafgrabber.core
        leafgrabber.free-text.query]
  )
