(ns farbetter.freedomdb.test-helpers
  (:require
   [farbetter.utils :refer [#?@(:clj [inspect sym-map throws]) throw-far-error]]
   [farbetter.freedomdb :as fdb])
  #?(:cljs
     (:require-macros
      [farbetter.utils :refer [inspect sym-map throws]])))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;; Helper functions

;; Set the backend for the tests here
(def create-db #(fdb/create-db :mem))

(defn populate-db [db]
  (let [t :favs]
    (-> (fdb/create-table db
                          t {:name {:type :str1000
                                    :indexed true}
                             :fav-num {:type :int4
                                       :indexed true}})
        (fdb/insert t {:name "Alice" :fav-num 10})
        (fdb/insert t {:name "Bobby" :fav-num 10})
        (fdb/insert t {:name "Clarence" :fav-num 7})
        (fdb/insert t {:name "Diana" :fav-num 8})
        (fdb/insert t {:name "Edgar" :fav-num 8}))))

(defn make-name-set [results]
  (set (map :name results)))

(defn add-jobs-table-and-data [db]
  (-> db
      (fdb/create-table :jobs {:num {:type :int4}
                               :completed {:type :bool
                                           :default false}
                               :priority {:type :kw
                                          :default :normal}
                               :name {:type :str1000
                                      :default "No Name"}})
      (fdb/insert :jobs {:num 1})
      (fdb/insert :jobs {:num 2})
      (fdb/insert :jobs {:num 3 :priority :high})))

(defn make-db2 []
  (-> (create-db)
      (add-jobs-table-and-data)))

(defn make-multi-table-db []
  (-> (create-db)
      (populate-db)
      (add-jobs-table-and-data)))

(defn ordered? [coll & dir]
  (let [op (case  (first dir)
             :asc <=
             :desc >=
             <=)]
    (or (nil? coll)
        (apply op coll))))
