(ns farbetter.mu.transport
  (:require
   [#?(:clj clojure.core.async :cljs cljs.core.async) :as ca]
   [farbetter.utils :as u :refer
    [throw-far-error #?@(:clj [go-safe inspect sym-map])]]
   [farbetter.mu.state :as state]
   [farbetter.mu.utils :as mu :refer [Channel ConnId]]
   [farbetter.roe :as roe]
   [freedomdb.frontend :as fdb]
   [freedomdb.schemas :refer [DBType]]
   [schema.core :as s :include-macros true]
   [taoensso.timbre :as timbre
    #?(:clj :refer :cljs :refer-macros) [debugf errorf infof]])
  #?(:cljs
     (:require-macros
      [farbetter.utils :as u :refer [go-safe inspect sym-map]])))

(s/defn connect-to-gw :- DBType
  [db-atom :- (s/atom DBType)
   conn-id :- ConnId
   rcv-chan :- Channel
   conn-factory :- (s/=> s/Any)]
  (let [on-connect (fn []
                     (let [bytes (roe/edn->avro-byte-array
                                  :int mu/protocol-version)
                           connect (fn [db]
                                     (-> db
                                         (state/set-conn-state conn-id
                                                               :connected)
                                         (state/send-bytes conn-id bytes)))]
                       (swap! db-atom connect)))
        on-disconnect #(state/remove-conn db-atom conn-id)
        on-error #(do (debugf "Error: %s" %)
                      (on-disconnect))
        on-rcv #(ca/put! rcv-chan [conn-id %])
        {:keys [sender closer]} (conn-factory conn-id on-connect on-disconnect
                                              on-error on-rcv)
        type :gw]
    (swap! db-atom state/add-conn conn-id sender closer type)))
