(ns farbetter.mu.conn-mgr
  (:require
   [#?(:clj clojure.core.async :cljs cljs.core.async) :as ca]
   [schema.core :as s :include-macros true]))

(defprotocol ConnMgr
  (send-data [this conn-id data]))

(defrecord GWConnMgr [conn-id->chan]
  ConnMgr
  (send-data [this conn-id data]
    (ca/put! (conn-id->chan conn-id) data)))

(s/defn make-gw-conn-mgr :- (s/protocol ConnMgr)
  []
  ())
