(defproject farbetter/mu "0.1.22"
  :description "A microservices framework for Clojure and Clojurescript"
  :url "https://github.com/farbetter/mu"
  :license {:name "The Apache Software License, Version 2.0"
            :url "http://www.apache.org/licenses/LICENSE-2.0.txt"}
  :lein-release {:scm :git
                 :deploy-via :clojars}
  :pedantic? :abort

  :profiles
  {:dev
   {:global-vars {*warn-on-reflection* true}
    :plugins
    [[lein-ancient "0.6.10"]
     ;; Because of confusion with a defunct project also called
     ;; lein-release, we exclude lein-release from lein-ancient.
     [lein-release "1.0.9" :upgrade false :exclusions [org.clojure/clojure]]
     [lein-cljsbuild "1.1.6"]]}}

  :dependencies
  [[com.taoensso/timbre "4.10.0" :exclusions [org.clojure/tools.reader]]
   [farbetter/pete "0.1.12"]
   [farbetter/roe "0.1.21"]
   [farbetter/utils "0.1.63"]
   [farbetter/freedomdb "0.2.10"]
   [org.clojure/clojure "1.8.0"]
   [org.clojure/clojurescript "1.9.671"]
   [org.clojure/core.async "0.3.443"]
   [prismatic/schema "1.1.6"]
   [stylefruits/gniazdo "1.0.0"]]

  :cljsbuild
  {:builds
   [{:id "node-test-none"
     :source-paths ["src" "test"]
     :notify-command ["node" "target/test/node_test_none/test_main.js"]
     :compiler
     {:optimizations :none
      :main "farbetter.test-runner"
      :target :nodejs
      :output-to "target/test/node_test_none/test_main.js"
      :output-dir "target/test/node_test_none"
      :source-map true
      :parallel-build true}}
    {:id "node-test-adv"
     :source-paths ["src" "test"]
     :notify-command ["node" "target/test/node_test_adv/test_main.js"]
     :compiler
     {:optimizations :advanced
      :main "farbetter.test-runner"
      :target :nodejs
      :static-fns true
      :output-to  "target/test/node_test_adv/test_main.js"
      :output-dir "target/test/node_test_adv"
      :source-map "target/test/node_test_adv/map.js.map"
      :parallel-build true}}]}

  :test-selectors {:default (complement :integration)
                   :integration :integration
                   :the-one :the-one
                   :all (constantly true)}

  :aliases
  {"auto-test-cljs" ["do"
                     "clean,"
                     "cljsbuild" "auto" "node-test-none"]
   "auto-test-cljs-adv" ["do"
                         "clean,"
                         "cljsbuild" "auto" "node-test-adv"]})
