(defproject farbetter/pete "0.1.13"
  :description "Clojure/Clojurescript process supervisor"
  :url "http://www.farbetter.com"
  :license {:name "Apache License, Version 2.0"
            :url "http://www.apache.org/licenses/LICENSE-2.0"}
  :lein-release {:scm :git
                 :deploy-via :clojars}
  :deploy-repositories [["clojars" {:creds :gpg}]]

  :pedantic? :abort

  :profiles {:dev
             {:plugins
              [[lein-ancient "0.6.10"]
               [lein-cljsbuild "1.1.7"]
               ;; lein-release can't be automatically upgraded w/ lein-ancient
               ;; because a different project has the same name :-(
               [lein-release "1.0.9"
                :upgrade false
                :exclusions [org.clojure/clojure]]]}}

  :dependencies
  [[cljsjs/nodejs-externs "1.0.4-1"]
   [com.taoensso/timbre "4.10.0"]
   [farbetter/utils "0.1.64"]
   [org.clojure/clojure "1.8.0"]
   [org.clojure/clojurescript "1.9.908"]
   [org.clojure/core.async "0.3.443"]
   [prismatic/schema "1.1.6"]]

  :cljsbuild
  {:builds
   [{:id "node-test-none"
     :source-paths ["src" "test"]
     :notify-command ["node" "target/test/node_test_none/test_main.js"]
     :compiler
     {:optimizations :none
      :main "farbetter.test-runner"
      :target :nodejs
      :output-to "target/test/node_test_none/test_main.js"
      :output-dir "target/test/node_test_none"
      :source-map true
      :parallel-build true}}
    {:id "node-test-adv"
     :source-paths ["src" "test"]
     :notify-command ["node" "target/test/node_test_adv/test_main.js"]
     :compiler
     {:optimizations :advanced
      :main "farbetter.test-runner"
      :target :nodejs
      :static-fns true
      :output-to  "target/test/node_test_adv/test_main.js"
      :output-dir "target/test/node_test_adv"
      :source-map "target/test/node_test_adv/map.js.map"
      :parallel-build true}}]}

  :aliases
  {"auto-test-cljs" ["do"
                     "clean,"
                     "cljsbuild" "auto" "node-test-none"]
   "auto-test-cljs-adv" ["do"
                         "clean,"
                         "cljsbuild" "auto" "node-test-adv"]})
