(ns farbetter.roe.mutable-streams)

(defprotocol OutputStream
  (get-size [this])
  (write-byte [this b])
  (write-bytes [this bs num-bytes])
  (write-bytes-w-len-prefix [this bs])
  (write-utf8-string [this s])
  (write-long-varint-zz [this l])
  (write-float [this f])
  (write-double [this d])
  (to-byte-array [this])
  (to-b64-string [this])
  (to-utf8-string [this]))

(defprotocol InputStream
  (get-available-count [this])
  (read-byte [this])
  (read-bytes [this num-bytes])
  (read-len-prefixed-bytes [this])
  (read-utf8-string [this])
  (read-long-varint-zz [this])
  (read-float [this])
  (read-double [this])
  (mark [this read-limit])
  (reset [this]))
