(ns farbetter.roe.test-schemas)

(def w-schema
  {:type :array,
   :items
   {:name :flight-search-result,
    :type :record,
    :fields
    [{:name :search-params-id, :type :int, :default 891234567}
     {:name :cost-map,
      :type
      {:name :money-map,
       :type :record,
       :fields
       [{:name :currency-code,
         :type
         {:name :currency-codes, :type :enum, :symbols [:gbp :usd]},
         :default :usd}
        {:name :major, :type [:null :int], :default nil}
        {:name :minor, :type [:null :int], :default nil}]},
      :default {:currency-code :usd, :major nil, :minor nil}}
     {:name :route,
      :type
      {:name :flight-route,
       :type :record,
       :fields
       [{:name :key, :type :string, :default "no key"}
        {:name :segments,
         :type
         {:type :array,
          :items
          {:name :flight-segment,
           :type :record,
           :fields
           [{:name :key, :type :string, :default "no key"}
            {:name :orig-airport-code, :type :string, :default "no code"}
            {:name :dest-airport-code, :type :string, :default "no code"}
            {:name :departure-date-time-map,
             :type
             {:name :date-time-map,
              :doc "A date-time represented as a map/record",
              :type :record,
              :fields
              [{:name :offset-hours,
                :type :int,
                :doc "Hours offset from UTC",
                :default 0}
               {:name :offset-minutes,
                :type :int,
                :doc "Minutes offset from UTC",
                :default 0}
               {:name :year,
                :type :int,
                :doc "Four-digit year",
                :default 0}
               {:name :month,
                :type :int,
                :doc "Month as a number. 1=January, 12=December",
                :default 0}
               {:name :day,
                :type :int,
                :doc "Day of the month",
                :default 0}
               {:name :hour,
                :type [:null :int],
                :doc "Hour in 24-hour time format",
                :default nil}
               {:name :minute,
                :type [:null :int],
                :doc "Minute (0-59)",
                :default nil}
               {:name :second,
                :type [:null :int],
                :doc "Second (0-59)",
                :default nil}]},
             :default
             {:offset-hours 0,
              :offset-minutes 0,
              :year 0,
              :month 0,
              :day 0,
              :hour nil,
              :minute nil,
              :second nil}}
            {:name :arrival-date-time-map,
             :type
             {:name :date-time-map,
              :doc "A date-time represented as a map/record",
              :type :record,
              :fields
              [{:name :offset-hours,
                :type :int,
                :doc "Hours offset from UTC",
                :default 0}
               {:name :offset-minutes,
                :type :int,
                :doc "Minutes offset from UTC",
                :default 0}
               {:name :year,
                :type :int,
                :doc "Four-digit year",
                :default 0}
               {:name :month,
                :type :int,
                :doc "Month as a number. 1=January, 12=December",
                :default 0}
               {:name :day,
                :type :int,
                :doc "Day of the month",
                :default 0}
               {:name :hour,
                :type [:null :int],
                :doc "Hour in 24-hour time format",
                :default nil}
               {:name :minute,
                :type [:null :int],
                :doc "Minute (0-59)",
                :default nil}
               {:name :second,
                :type [:null :int],
                :doc "Second (0-59)",
                :default nil}]},
             :default
             {:offset-hours 0,
              :offset-minutes 0,
              :year 0,
              :month 0,
              :day 0,
              :hour nil,
              :minute nil,
              :second nil}}
            {:name :carrier, :type :string, :default "no carrier"}
            {:name :flight-num, :type :string, :default "no flight num"}
            {:name :equipment, :type :string, :default ""}
            {:name :group, :type :int, :default 1234567}
            {:name :cabin-class, :type [:null :string], :default nil}
            {:name :fare-code, :type [:null :string], :default nil}]}},
         :default []}
        {:name :price,
         :type
         [:null
          {:name :air-pricing,
           :type :record,
           :fields
           [{:name :booking-info,
             :type
             {:type :array,
              :items
              {:name :air-booking-info,
               :type :record,
               :fields
               [{:name :code, :type :string, :default "no code"}
                {:name :cabin-class, :type :string, :default "Economy"}
                {:name :fare-ref, :type :string, :default "no-ref"}
                {:name :segment-ref,
                 :type :string,
                 :default "no-ref"}]}},
             :default []}
            {:name :fare-info,
             :type
             {:type :array,
              :items
              {:name :air-fare-info,
               :type :record,
               :fields
               [{:name :key, :type :string, :default ""}
                {:name :origin, :type :string, :default ""}
                {:name :destination, :type :string, :default ""}
                {:name :fare-basis, :type :string, :default ""}
                {:name :passenger-type,
                 :type
                 {:name :traveler-types,
                  :type :enum,
                  :symbols
                  [:pfk
                   :zxq
                   :mbt
                   :zwa
                   :zfi
                   :cmx
                   :its
                   :prc
                   :dlu
                   :gst
                   :zrd
                   :jns
                   :ppb
                   :neg
                   :prb
                   :zab
                   :zya
                   :zpf
                   :itf
                   :arp
                   :mdp
                   :luv
                   :prf
                   :zcd
                   :wbc
                   :scc
                   :mnf
                   :zlu
                   :zsp
                   :zei
                   :fnt
                   :wfa
                   :prs
                   :psr
                   :srr
                   :tia
                   :mil
                   :bag
                   :wts
                   :zzd
                   :nta
                   :sep
                   :zmp
                   :wcr
                   :zzy
                   :rif
                   :ppf
                   :pfv
                   :stp
                   :snn
                   :zxl
                   :pnt
                   :sme
                   :bld
                   :tur
                   :spl
                   :mxs
                   :lif
                   :ppc
                   :pfy
                   :eav
                   :stc
                   :fba
                   :zsm
                   :prx
                   :psb
                   :zap
                   :api
                   :zwv
                   :chd
                   :mis
                   :tim
                   :ppt
                   :zor
                   :fnc
                   :zxn
                   :pra
                   :zzp
                   :oep
                   :pre
                   :zxv
                   :fgc
                   :ech
                   :clg
                   :asi
                   :ity
                   :zdm
                   :acp
                   :jep
                   :unv
                   :pft
                   :zzb
                   :prn
                   :ppj
                   :zvn
                   :epc
                   :sph
                   :pca
                   :pst
                   :zpg
                   :pfh
                   :ref
                   :zit
                   :ann
                   :ztp
                   :cpn
                   :cne
                   :pip
                   :pcf
                   :zzl
                   :zxj
                   :zah
                   :brv
                   :zad
                   :esc
                   :ytr
                   :cmp
                   :cur
                   :pcr
                   :mlz
                   :zpm
                   :ppr
                   :ema
                   :zef
                   :zpa
                   :acc
                   :pfi
                   :zar
                   :enn
                   :lbr
                   :pfq
                   :zjt
                   :zzs
                   :fha
                   :zaa
                   :xpa
                   :git
                   :zgb
                   :zxi
                   :nrr
                   :pfn
                   :ptt
                   :ppv
                   :zes
                   :zxt
                   :stn
                   :art
                   :pry
                   :isr
                   :asc
                   :zxy
                   :uda
                   :ffd
                   :oei
                   :dod
                   :agt
                   :srs
                   :cdt
                   :pnn
                   :mir
                   :udn
                   :msb
                   :cbo
                   :ppe
                   :pfl
                   :zzg
                   :fhc
                   :prp
                   :nat
                   :jcb
                   :rec
                   :zxr
                   :cms
                   :zfr
                   :zkr
                   :ppm
                   :jnn
                   :spr
                   :zxb
                   :prv
                   :zsa
                   :zxk
                   :pos
                   :ast
                   :ppi
                   :pfz
                   :ztw
                   :gbe
                   :pfr
                   :oec
                   :msg
                   :adr
                   :spa
                   :xnn
                   :adt
                   :pcp
                   :cnn
                   :zxg
                   :zss
                   :mif
                   :zco
                   :cnv
                   :cbc
                   :knn
                   :zzo
                   :ycr
                   :prg
                   :src
                   :zpr
                   :ada
                   :ppa
                   :ppx
                   :ztn
                   :zrc
                   :cmr
                   :ccm
                   :pfd
                   :nrf
                   :ppz
                   :stb
                   :mep
                   :pff
                   :pon
                   :gsp
                   :sps
                   :cnt
                   :ins
                   :prz
                   :pfb
                   :ppn
                   :mpa
                   :zfh
                   :zza
                   :jeb
                   :zae
                   :ppo
                   :gnn
                   :mss
                   :fga
                   :epu
                   :zzx
                   :zai
                   :ppu
                   :ppk
                   :fnn
                   :sdr
                   :pfa
                   :lns
                   :wbi
                   :zde
                   :zze
                   :pfc
                   :gct
                   :ppg
                   :zmy
                   :edt
                   :zcs
                   :jom
                   :crr
                   :pro
                   :mus
                   :zxp
                   :ntl
                   :pps
                   :zea
                   :zbp
                   :eno
                   :zlr
                   :pmp
                   :unr
                   :asb
                   :pnc
                   :pfg
                   :prq
                   :emi
                   :gmz
                   :mml
                   :ppy
                   :oeb
                   :ffy
                   :zso
                   :fbc
                   :inr
                   :hof
                   :ofs
                   :ots
                   :fly
                   :zdp
                   :aps
                   :cma
                   :zdd
                   :pcb
                   :ztr
                   :vfr
                   :inf
                   :pru
                   :prr
                   :str
                   :yth
                   :zie
                   :epi
                   :zsf
                   :ffp
                   :ppw
                   :vag
                   :lmg
                   :spt
                   :cch
                   :tnn
                   :pfx
                   :rnn
                   :gvm
                   :zfb
                   :zzm
                   :ctz
                   :zus
                   :zsg
                   :gvt
                   :dis
                   :ffa
                   :gex
                   :giy
                   :zec
                   :pfo
                   :pfw
                   :mcu
                   :zxe
                   :fbi
                   :zfa
                   :med
                   :fte
                   :ynn
                   :epa
                   :zbi
                   :zca
                   :mic
                   :inn
                   :mdr
                   :ltc
                   :unn
                   :zxo
                   :icp
                   :ggv
                   :zzu
                   :ysb
                   :tux
                   :gva
                   :bud
                   :pfj
                   :prm
                   :zxc
                   :zzk
                   :cfm
                   :qmy
                   :vdb
                   :znl
                   :mcs
                   :mcr
                   :emp
                   :zzj
                   :zxd
                   :wta
                   :vnn
                   :cmm
                   :aep
                   :pif
                   :znn
                   :nsb
                   :ppp
                   :zil
                   :eaq
                   :zzn
                   :mcp
                   :zzi
                   :zzc
                   :mre
                   :mns
                   :jwz
                   :prd
                   :pfp
                   :zsi
                   :zpc
                   :xma
                   :zed
                   :zxu
                   :ppq
                   :prl
                   :zep
                   :asf
                   :zzh
                   :sta
                   :php
                   :zui
                   :zxa
                   :fnf
                   :zzr
                   :gdp
                   :def
                   :mnn
                   :eat
                   :pfm
                   :tea
                   :pna
                   :eac
                   :zyc
                   :adv
                   :lnn
                   :sdb
                   :fif
                   :gvz
                   :csb
                   :pfe
                   :zce
                   :cbi
                   :zsk
                   :zci
                   :zxh
                   :zrg
                   :zzw
                   :jnf
                   :wbs
                   :zgs
                   :zxf
                   :zma
                   :pil
                   :prh
                   :add
                   :ppd
                   :zps
                   :zrs
                   :zzq
                   :ccr
                   :zsy
                   :pph
                   :zxw
                   :zch
                   :ffc
                   :pap
                   :bnn
                   :prw
                   :grp
                   :xes
                   :fff
                   :stu
                   :chr
                   :enf
                   :nur
                   :itx
                   :ggz
                   :vus
                   :zxx
                   :mai
                   :zzv
                   :jec
                   :zac
                   :zcc
                   :vac
                   :mam
                   :apa
                   :iny
                   :stf
                   :prj
                   :fgi
                   :ycb
                   :sea
                   :ine
                   :adn
                   :sky
                   :zzf
                   :prt
                   :wnn
                   :zgr
                   :zcu
                   :zzt
                   :zrr
                   :zag
                   :zxm
                   :apc
                   :pfs
                   :hnn
                   :prk
                   :gyt
                   :web
                   :cev
                   :ppl
                   :pri
                   :fcc
                   :gcf
                   :pfu
                   :dnn
                   :zbe
                   :psp
                   :kif
                   :job
                   :zaf
                   :ffe]},
                 :default :adt}
                {:name :effective-date,
                 :type
                 {:name :date-time-map,
                  :doc "A date-time represented as a map/record",
                  :type :record,
                  :fields
                  [{:name :offset-hours,
                    :type :int,
                    :doc "Hours offset from UTC",
                    :default 0}
                   {:name :offset-minutes,
                    :type :int,
                    :doc "Minutes offset from UTC",
                    :default 0}
                   {:name :year,
                    :type :int,
                    :doc "Four-digit year",
                    :default 0}
                   {:name :month,
                    :type :int,
                    :doc "Month as a number. 1=January, 12=December",
                    :default 0}
                   {:name :day,
                    :type :int,
                    :doc "Day of the month",
                    :default 0}
                   {:name :hour,
                    :type [:null :int],
                    :doc "Hour in 24-hour time format",
                    :default nil}
                   {:name :minute,
                    :type [:null :int],
                    :doc "Minute (0-59)",
                    :default nil}
                   {:name :second,
                    :type [:null :int],
                    :doc "Second (0-59)",
                    :default nil}]},
                 :default
                 {:offset-hours 0,
                  :offset-minutes 0,
                  :year 0,
                  :month 0,
                  :day 0,
                  :hour nil,
                  :minute nil,
                  :second nil}}
                {:name :fare-rule-key, :type :string, :default ""}]}},
             :default []}
            {:name :pricing-info,
             :type
             {:name :air-pricing-info,
              :type :record,
              :fields
              [{:name :key, :type :string, :default "no key"}
               {:name :provider, :type :string, :default "no provider"}
               {:name :pricing-method,
                :type :string,
                :default "no pricing method"}]},
             :default
             {:key "no key",
              :provider "no provider",
              :pricing-method "no pricing method"}}]}],
         :default nil}]},
      :default {:key "no key", :segments [], :price nil}}]}}
  )

(def return-schema
  {:type :array,
   :items
   {:name :flight-search-result,
    :type :record,
    :fields
    [{:name :search-params-id, :type :int, :default 891234567}
     {:name :cost-map,
      :type
      {:name :money-map,
       :type :record,
       :fields
       [{:name :currency-code,
         :type
         {:name :currency-codes, :type :enum, :symbols [:gbp :usd]},
         :default :usd}
        {:name :major, :type [:null :int], :default nil}
        {:name :minor, :type [:null :int], :default nil}]},
      :default {:currency-code :usd, :major nil, :minor nil}}
     {:name :route,
      :type
      {:name :flight-route,
       :type :record,
       :fields
       [{:name :key, :type :string, :default "no key"}
        {:name :segments,
         :type
         {:type :array,
          :items
          {:name :flight-segment,
           :type :record,
           :fields
           [{:name :key, :type :string, :default "no key"}
            {:name :orig-airport-code, :type :string, :default "no code"}
            {:name :dest-airport-code, :type :string, :default "no code"}
            {:name :departure-date-time-map,
             :type
             {:name :date-time-map,
              :doc "A date-time represented as a map/record",
              :type :record,
              :fields
              [{:name :offset-hours,
                :type :int,
                :doc "Hours offset from UTC",
                :default 0}
               {:name :offset-minutes,
                :type :int,
                :doc "Minutes offset from UTC",
                :default 0}
               {:name :year,
                :type :int,
                :doc "Four-digit year",
                :default 0}
               {:name :month,
                :type :int,
                :doc "Month as a number. 1=January, 12=December",
                :default 0}
               {:name :day,
                :type :int,
                :doc "Day of the month",
                :default 0}
               {:name :hour,
                :type [:null :int],
                :doc "Hour in 24-hour time format",
                :default nil}
               {:name :minute,
                :type [:null :int],
                :doc "Minute (0-59)",
                :default nil}
               {:name :second,
                :type [:null :int],
                :doc "Second (0-59)",
                :default nil}]},
             :default
             {:offset-hours 0,
              :offset-minutes 0,
              :year 0,
              :month 0,
              :day 0,
              :hour nil,
              :minute nil,
              :second nil}}
            {:name :arrival-date-time-map,
             :type
             {:name :date-time-map,
              :doc "A date-time represented as a map/record",
              :type :record,
              :fields
              [{:name :offset-hours,
                :type :int,
                :doc "Hours offset from UTC",
                :default 0}
               {:name :offset-minutes,
                :type :int,
                :doc "Minutes offset from UTC",
                :default 0}
               {:name :year,
                :type :int,
                :doc "Four-digit year",
                :default 0}
               {:name :month,
                :type :int,
                :doc "Month as a number. 1=January, 12=December",
                :default 0}
               {:name :day,
                :type :int,
                :doc "Day of the month",
                :default 0}
               {:name :hour,
                :type [:null :int],
                :doc "Hour in 24-hour time format",
                :default nil}
               {:name :minute,
                :type [:null :int],
                :doc "Minute (0-59)",
                :default nil}
               {:name :second,
                :type [:null :int],
                :doc "Second (0-59)",
                :default nil}]},
             :default
             {:offset-hours 0,
              :offset-minutes 0,
              :year 0,
              :month 0,
              :day 0,
              :hour nil,
              :minute nil,
              :second nil}}
            {:name :carrier, :type :string, :default "no carrier"}
            {:name :flight-num, :type :string, :default "no flight num"}
            {:name :equipment, :type :string, :default ""}
            {:name :group, :type :int, :default 1234567}
            {:name :cabin-class, :type [:null :string], :default nil}
            {:name :fare-code, :type [:null :string], :default nil}]}},
         :default []}
        {:name :price,
         :type
         [:null
          {:name :air-pricing,
           :type :record,
           :fields
           [{:name :booking-info,
             :type
             {:type :array,
              :items
              {:name :air-booking-info,
               :type :record,
               :fields
               [{:name :code, :type :string, :default "no code"}
                {:name :cabin-class, :type :string, :default "Economy"}
                {:name :fare-ref, :type :string, :default "no-ref"}
                {:name :segment-ref,
                 :type :string,
                 :default "no-ref"}]}},
             :default []}
            {:name :fare-info,
             :type
             {:type :array,
              :items
              {:name :air-fare-info,
               :type :record,
               :fields
               [{:name :key, :type :string, :default ""}
                {:name :origin, :type :string, :default ""}
                {:name :destination, :type :string, :default ""}
                {:name :fare-basis, :type :string, :default ""}
                {:name :passenger-type,
                 :type
                 {:name :traveler-types,
                  :type :enum,
                  :symbols
                  [:pfk
                   :zxq
                   :mbt
                   :zwa
                   :zfi
                   :cmx
                   :its
                   :prc
                   :dlu
                   :gst
                   :zrd
                   :jns
                   :ppb
                   :neg
                   :prb
                   :zab
                   :zya
                   :zpf
                   :itf
                   :arp
                   :mdp
                   :luv
                   :prf
                   :zcd
                   :wbc
                   :scc
                   :mnf
                   :zlu
                   :zsp
                   :zei
                   :fnt
                   :wfa
                   :prs
                   :psr
                   :srr
                   :tia
                   :mil
                   :bag
                   :wts
                   :zzd
                   :nta
                   :sep
                   :zmp
                   :wcr
                   :zzy
                   :rif
                   :ppf
                   :pfv
                   :stp
                   :snn
                   :zxl
                   :pnt
                   :sme
                   :bld
                   :tur
                   :spl
                   :mxs
                   :lif
                   :ppc
                   :pfy
                   :eav
                   :stc
                   :fba
                   :zsm
                   :prx
                   :psb
                   :zap
                   :api
                   :zwv
                   :chd
                   :mis
                   :tim
                   :ppt
                   :zor
                   :fnc
                   :zxn
                   :pra
                   :zzp
                   :oep
                   :pre
                   :zxv
                   :fgc
                   :ech
                   :clg
                   :asi
                   :ity
                   :zdm
                   :acp
                   :jep
                   :unv
                   :pft
                   :zzb
                   :prn
                   :ppj
                   :zvn
                   :epc
                   :sph
                   :pca
                   :pst
                   :zpg
                   :pfh
                   :ref
                   :zit
                   :ann
                   :ztp
                   :cpn
                   :cne
                   :pip
                   :pcf
                   :zzl
                   :zxj
                   :zah
                   :brv
                   :zad
                   :esc
                   :ytr
                   :cmp
                   :cur
                   :pcr
                   :mlz
                   :zpm
                   :ppr
                   :ema
                   :zef
                   :zpa
                   :acc
                   :pfi
                   :zar
                   :enn
                   :lbr
                   :pfq
                   :zjt
                   :zzs
                   :fha
                   :zaa
                   :xpa
                   :git
                   :zgb
                   :zxi
                   :nrr
                   :pfn
                   :ptt
                   :ppv
                   :zes
                   :zxt
                   :stn
                   :art
                   :pry
                   :isr
                   :asc
                   :zxy
                   :uda
                   :ffd
                   :oei
                   :dod
                   :agt
                   :srs
                   :cdt
                   :pnn
                   :mir
                   :udn
                   :msb
                   :cbo
                   :ppe
                   :pfl
                   :zzg
                   :fhc
                   :prp
                   :nat
                   :jcb
                   :rec
                   :zxr
                   :cms
                   :zfr
                   :zkr
                   :ppm
                   :jnn
                   :spr
                   :zxb
                   :prv
                   :zsa
                   :zxk
                   :pos
                   :ast
                   :ppi
                   :pfz
                   :ztw
                   :gbe
                   :pfr
                   :oec
                   :msg
                   :adr
                   :spa
                   :xnn
                   :adt
                   :pcp
                   :cnn
                   :zxg
                   :zss
                   :mif
                   :zco
                   :cnv
                   :cbc
                   :knn
                   :zzo
                   :ycr
                   :prg
                   :src
                   :zpr
                   :ada
                   :ppa
                   :ppx
                   :ztn
                   :zrc
                   :cmr
                   :ccm
                   :pfd
                   :nrf
                   :ppz
                   :stb
                   :mep
                   :pff
                   :pon
                   :gsp
                   :sps
                   :cnt
                   :ins
                   :prz
                   :pfb
                   :ppn
                   :mpa
                   :zfh
                   :zza
                   :jeb
                   :zae
                   :ppo
                   :gnn
                   :mss
                   :fga
                   :epu
                   :zzx
                   :zai
                   :ppu
                   :ppk
                   :fnn
                   :sdr
                   :pfa
                   :lns
                   :wbi
                   :zde
                   :zze
                   :pfc
                   :gct
                   :ppg
                   :zmy
                   :edt
                   :zcs
                   :jom
                   :crr
                   :pro
                   :mus
                   :zxp
                   :ntl
                   :pps
                   :zea
                   :zbp
                   :eno
                   :zlr
                   :pmp
                   :unr
                   :asb
                   :pnc
                   :pfg
                   :prq
                   :emi
                   :gmz
                   :mml
                   :ppy
                   :oeb
                   :ffy
                   :zso
                   :fbc
                   :inr
                   :hof
                   :ofs
                   :ots
                   :fly
                   :zdp
                   :aps
                   :cma
                   :zdd
                   :pcb
                   :ztr
                   :vfr
                   :inf
                   :pru
                   :prr
                   :str
                   :yth
                   :zie
                   :epi
                   :zsf
                   :ffp
                   :ppw
                   :vag
                   :lmg
                   :spt
                   :cch
                   :tnn
                   :pfx
                   :rnn
                   :gvm
                   :zfb
                   :zzm
                   :ctz
                   :zus
                   :zsg
                   :gvt
                   :dis
                   :ffa
                   :gex
                   :giy
                   :zec
                   :pfo
                   :pfw
                   :mcu
                   :zxe
                   :fbi
                   :zfa
                   :med
                   :fte
                   :ynn
                   :epa
                   :zbi
                   :zca
                   :mic
                   :inn
                   :mdr
                   :ltc
                   :unn
                   :zxo
                   :icp
                   :ggv
                   :zzu
                   :ysb
                   :tux
                   :gva
                   :bud
                   :pfj
                   :prm
                   :zxc
                   :zzk
                   :cfm
                   :qmy
                   :vdb
                   :znl
                   :mcs
                   :mcr
                   :emp
                   :zzj
                   :zxd
                   :wta
                   :vnn
                   :cmm
                   :aep
                   :pif
                   :znn
                   :nsb
                   :ppp
                   :zil
                   :eaq
                   :zzn
                   :mcp
                   :zzi
                   :zzc
                   :mre
                   :mns
                   :jwz
                   :prd
                   :pfp
                   :zsi
                   :zpc
                   :xma
                   :zed
                   :zxu
                   :ppq
                   :prl
                   :zep
                   :asf
                   :zzh
                   :sta
                   :php
                   :zui
                   :zxa
                   :fnf
                   :zzr
                   :gdp
                   :def
                   :mnn
                   :eat
                   :pfm
                   :tea
                   :pna
                   :eac
                   :zyc
                   :adv
                   :lnn
                   :sdb
                   :fif
                   :gvz
                   :csb
                   :pfe
                   :zce
                   :cbi
                   :zsk
                   :zci
                   :zxh
                   :zrg
                   :zzw
                   :jnf
                   :wbs
                   :zgs
                   :zxf
                   :zma
                   :pil
                   :prh
                   :add
                   :ppd
                   :zps
                   :zrs
                   :zzq
                   :ccr
                   :zsy
                   :pph
                   :zxw
                   :zch
                   :ffc
                   :pap
                   :bnn
                   :prw
                   :grp
                   :xes
                   :fff
                   :stu
                   :chr
                   :enf
                   :nur
                   :itx
                   :ggz
                   :vus
                   :zxx
                   :mai
                   :zzv
                   :jec
                   :zac
                   :zcc
                   :vac
                   :mam
                   :apa
                   :iny
                   :stf
                   :prj
                   :fgi
                   :ycb
                   :sea
                   :ine
                   :adn
                   :sky
                   :zzf
                   :prt
                   :wnn
                   :zgr
                   :zcu
                   :zzt
                   :zrr
                   :zag
                   :zxm
                   :apc
                   :pfs
                   :hnn
                   :prk
                   :gyt
                   :web
                   :cev
                   :ppl
                   :pri
                   :fcc
                   :gcf
                   :pfu
                   :dnn
                   :zbe
                   :psp
                   :kif
                   :job
                   :zaf
                   :ffe]},
                 :default :adt}
                {:name :effective-date,
                 :type
                 {:name :date-time-map,
                  :doc "A date-time represented as a map/record",
                  :type :record,
                  :fields
                  [{:name :offset-hours,
                    :type :int,
                    :doc "Hours offset from UTC",
                    :default 0}
                   {:name :offset-minutes,
                    :type :int,
                    :doc "Minutes offset from UTC",
                    :default 0}
                   {:name :year,
                    :type :int,
                    :doc "Four-digit year",
                    :default 0}
                   {:name :month,
                    :type :int,
                    :doc "Month as a number. 1=January, 12=December",
                    :default 0}
                   {:name :day,
                    :type :int,
                    :doc "Day of the month",
                    :default 0}
                   {:name :hour,
                    :type [:null :int],
                    :doc "Hour in 24-hour time format",
                    :default nil}
                   {:name :minute,
                    :type [:null :int],
                    :doc "Minute (0-59)",
                    :default nil}
                   {:name :second,
                    :type [:null :int],
                    :doc "Second (0-59)",
                    :default nil}]},
                 :default
                 {:offset-hours 0,
                  :offset-minutes 0,
                  :year 0,
                  :month 0,
                  :day 0,
                  :hour nil,
                  :minute nil,
                  :second nil}}
                {:name :fare-rule-key, :type :string, :default ""}]}},
             :default []}
            {:name :pricing-info,
             :type
             {:name :air-pricing-info,
              :type :record,
              :fields
              [{:name :key, :type :string, :default "no key"}
               {:name :provider, :type :string, :default "no provider"}
               {:name :pricing-method,
                :type :string,
                :default "no pricing method"}]},
             :default
             {:key "no key",
              :provider "no provider",
              :pricing-method "no pricing method"}}]}],
         :default nil}]},
      :default {:key "no key", :segments [], :price nil}}]}}
  )
