(ns farbetter.roe.test-helpers
  (:require
   [farbetter.roe :as r]
   [farbetter.roe.utils :as ru]
   #?(:clj [farbetter.utils :refer [inspect]])
   [farbetter.utils :as u :refer
    [#?@(:cljs [byte-array long] :clj [inspect sym-map throws])]]
   [taoensso.timbre :as timbre
    #?(:clj :refer :cljs :refer-macros) [debugf errorf infof]])
  #?(:cljs
     (:require-macros
      [farbetter.utils :as u :refer [inspect]])))

(defn round-trip? [schema edn]
  (let [encoded (r/edn->avro-b64-string schema edn)
        decoded (r/avro-b64-string->edn schema schema encoded)
        eq? (ru/equivalent? schema edn schema decoded)]
    (when-not eq?
      (errorf "######## round-trip? failed #########.\n%s"
              (u/inspect-str schema edn decoded)))
    eq?))
