(defproject farbetter/roe "0.1.21"
  :description "A Clojure/Clojurescript wrapper for Avro"
  :url "https://github.com/farbetter/roe"
  :license {:name "The Apache Software License, Version 2.0"
            :url "http://www.apache.org/licenses/LICENSE-2.0.txt"}
  :lein-release {:scm :git
                 :deploy-via :clojars}

  :pedantic? :abort

  :profiles
  {:dev
   {;; :global-vars {*warn-on-reflection* true}
    :dependencies
    [[org.apache.avro/avro "1.8.2"]]
    :plugins
    [[lein-ancient "0.6.10"]
     [lein-cljsbuild "1.1.6"]
     ;; Because of confusion with a defunct project also called
     ;; lein-release, we exclude lein-release from lein-ancient.
     [lein-release "1.0.9" :upgrade false :exclusions [org.clojure/clojure]]]}}

  :dependencies
  [[cheshire "5.7.1" :exclusions [com.fasterxml.jackson.core/jackson-core]]
   [cljsjs/bytebuffer "5.0.1-0"]
   [cljsjs/long "3.0.3-1"]
   [cljsjs/nodejs-externs "1.0.4-1"]
   ;; TODO: move any calls to guava to utils?
   [com.google.guava/guava "22.0" :exclusions [com.google.code.findbugs/jsr305]]
   [com.taoensso/timbre "4.10.0"]
   [farbetter/stockroom "0.1.10"]
   [farbetter/utils "0.1.63"]
   [org.clojure/clojure "1.8.0"]
   [org.clojure/clojurescript "1.9.671"]
   [org.clojure/test.check "0.9.0"]
   [prismatic/schema "1.1.6"]]

  :jvm-opts ^:replace ["-server" "-XX:+AggressiveOpts"]


  :test-selectors {:default (complement :perf)
                   :perf :perf
                   :selected :selected
                   :the-one :the-one
                   :all (constantly true)}

  :cljsbuild
  {:builds
   [{:id "node-test-none"
     :source-paths ["src" "test"]
     :notify-command ["node" "target/test/node_test_none/test_main.js"]
     :compiler
     {:optimizations :none
      :main "farbetter.test-runner"
      :target :nodejs
      :output-to "target/test/node_test_none/test_main.js"
      :output-dir "target/test/node_test_none"
      :source-map true}}
    {:id "node-perf"
     :source-paths ["src" "test"]
     :notify-command ["node" "target/test/node_perf/test_main.js" ":perf"]
     :compiler
     {:optimizations :advanced
      :target :nodejs
      :main "farbetter.test-runner"
      :static-fns true
      :output-to "target/test/node_perf/test_main.js"
      :output-dir "target/test/node_perf"
      :source-map "target/test/node_perf/map.js.map"}}]}

  :aliases
  {"auto-test-cljs" ["do"
                     "clean,"
                     "cljsbuild" "auto" "node-test-none"]
   "auto-perf-cljs" ["do"
                     "clean,"
                     "cljsbuild" "auto" "node-perf"]})
