(ns farbetter.string-store.mem-storage
  (:require
   [farbetter.string-store.storage :as storage]
   [farbetter.utils :as u :refer [sym-map]]
   [taoensso.timbre :as timbre :refer [debugf errorf infof tracef warnf]]))

(defrecord MemStorage [m version-map-atom chunk-size]
  storage/IStorage
  (inc-version [this name]
    (u/go-sf
      (-> (swap! version-map-atom
                 (fn [old-map]
                   (update old-map name #(if %
                                        (inc %)
                                        1))))
          (get name))))

  (get-version [this name]
    (u/go-sf
      (@version-map-atom name)))

  (get-row [this name]
    (u/go-sf
     (@m name)))

  (put-row [this name row]
    (u/go-sf
     (swap! m assoc name row)))

  (get-chunk-size [this]
    (u/go-sf
     chunk-size)))

(defn make-mem-storage
  ([]
   (make-mem-storage (* 1024 64)))
  ([chunk-size]
   (->MemStorage (atom {}) (atom {}) chunk-size)))
