(ns farbetter.string-store.storage
  (:require
   [schema.core :as s]))

(defn make-row-id [name version]
  (str name "#" version))

(defprotocol IStorage
  (get-version [this k])
  (get-row [this k])
  (put-header-row [this name stored-version timestamp chunk-ids])
  (put-chunk-row [this row-id chunk])
  (get-chunk-size [this]))

(def Storage (s/protocol IStorage))
