(defproject farbetter/utils "0.1.25"
  :description "Various utilities"
  :url "https://github.com/farbetter/utils"
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}
  :lein-release {:scm :git
                 :deploy-via :clojars}
  :deploy-repositories [["clojars" {:creds :gpg}]]

  :profiles {:dev
             {:plugins [[lein-cljsbuild "1.1.0"]
                        [lein-release "1.0.9"]]}}

  :dependencies
  [[clj-time "0.11.0"]
   [com.andrewmcveigh/cljs-time "0.3.14"]
   [com.cognitect/transit-clj "0.8.285"]
   [com.cognitect/transit-cljs "0.8.225"]
   [mvxcvi/puget "1.0.0"]
   [org.clojure/clojure "1.7.0"]
   [org.clojure/clojurescript "1.7.145"]
   [org.clojure/core.async "0.2.371"]]

  :repl-options
  {:init-ns farbetter.utils}

  :cljsbuild
  {:builds
   [{:id "node-dev"
     :source-paths ["src" "test"]
     :notify-command ["node" "target/test/node_dev/test_main.js"]
     :compiler
     {:optimizations :none
      :main "farbetter.test-runner"
      :target :nodejs
      :output-to "target/test/node_dev/test_main.js"
      :output-dir "target/test/node_dev"
      :source-map true}}]}

  :aliases
  {"auto-test-cljs" ["do"
                     "clean,"
                     "cljsbuild" "auto" "node-dev"]})
