(ns {{name}}.document.{{model}}.resource
    (:use [clj.faris.qed.resource.normal :only [get-list-resource
                                                get-one-by-slug-resource
                                                put-one-by-slug-resource
                                                delete-one-by-id-resource
                                                post-one-resource]]
          [clj.faris.qed.util :only [get-db]]
          [liberator.core :only [defresource]]
          [{{name}}.core :only [app-state]]))

(defresource get-list-{{model}}
  (get-list-resource (get-db app-state)
                     {{model}}->jsonable "{{model}}"))

(defresource get-one-{{model}}-by-slug
  [slug]
  (get-one-by-slug-resource (get-db app-state)
                            {{model}}->jsonable "{{model}}"))

(defresource put-one-{{model}}-by-slug
  [slug]
  (put-one-by-slug-resource (get-db app-state)
                            {{model}}->saveable
                            {{modell}}-validator
                            slug))

(defresource delete-one-{{model}}-by-slug
  [slug]
  (delete-one-by-slug-resource (get-db app-state) "{{model}}" slug))

(defn post-one-{{model}}
  (post-one-resource (get-db app-state)
                     {{model}}->jsonable
                     {{model}}->saveable
                     {{model}}-validator
                     "{{model}}"))
