(ns leiningen.serv
  (:require [leiningen.new.templates :refer [renderer name-to-path ->files]]
            [leiningen.core.main :as main]))

(def render (renderer "./"))

(defn serv
  "Scaffold the needed models file"
  [name & args]
  (let [data {:name name
              :sanitized (name-to-path name)
              :model (first args)}]
    (main/info "Generating templates for our models")
    (->files data
             ["src/{{sanitized}}/document/{{model}}/mapper.clj" (render "mapper.clj" data)]
             ["src/{{sanitized}}/document/{{model}}/validator.clj" (render "validator.clj" data)]
             ["src/{{sanitized}}/document/{{model}}/resource.clj" (render "resource.clj" data)]
             ["src/{{sanitized}}/document/{{model}}/admin-resource.clj" (render "admin_resource.clj" data)]
             ["src/{{sanitized}}/document/{{model}}/route.clj" (render "route.clj" data)])))
