(ns {{name}}.document.{{model}}.route
    (:use [compojure.core :only [defroutes
                                 context
                                 GET
                                 POST
                                 PUT
                                 DELETE]]
          [{{name}}.document.{{model}} resource admin-resource]))

(defroutes {{model}}-routes
  (context "{{model}}" []
           (GET "/" [] get-list-{{model}})
           (GET "/:slug" [slug] (get-one-{{model}}-by-slug slug))
           (POST "/" [] post-one-{{model}})
           (PUT "/:slug" [slug] (put-one-{{model}}-by-slug slug))
           (DELETE "/:slug" [slug] (delete-one-{{model}}-by-slug slug))))

(defroutes admin-{{model}}-routes
  (context "{{model}}" []
           (GET "/" [] admin-get-list-{{model}})
           (GET "/:slug" [slug] (admin-get-one-{{model}}-by-slug slug))
           (POST "/" [] admin-post-one-{{model}})
           (PUT "/:slug" [slug] (admin-put-one-{{model}}-by-slug slug))
           (DELETE "/:slug" [slug] (admin-delete-one-{{model}}-by-slug slug))))
