(ns struktur.hikari
  (:require
   [clojure.spec.alpha :as s]
   [com.stuartsierra.component :as c]
   [defn-spec.core :refer [defn-spec]]
   [hikari-cp.core :as hikari]))

(s/def ::adapter string?)
(s/def ::jdbc-url string?)
(s/def ::pool-spec (s/or :with-adapter (s/keys :req-un [::adapter])
                         :with-url (s/keys :req-un [::jdbc-url])))

(defrecord Hikari [pool-spec spec]
  c/Lifecycle
  (start [this]
    (let [datasource (hikari/make-datasource pool-spec)]
      (assoc this :spec {:datasource datasource})))
  (stop [this]
    (when-let [datasource (:datasource spec)]
      (hikari/close-datasource datasource))
    (assoc this :spec nil)))

(defn-spec new-hikari
  {::s/args (s/cat :pool-spec ::pool-spec)}
  [pool-spec]
  (map->Hikari {:pool-spec pool-spec}))
