(ns struktur.hikari
  (:require
   [clojure.spec.alpha :as s]
   [com.stuartsierra.component :as c]
   [hikari-cp.core :as hikari]))

(defrecord HikariCP [pool-spec spec]
  c/Lifecycle
  (start [this]
    (let [datasource (hikari/make-datasource pool-spec)]
      (assoc this :spec {:datasource datasource})))
  (stop [this]
    (when-let [datasource (:datasource spec)]
      (hikari/close-datasource datasource))
    (assoc this :spec nil)))

(defn new-hikari-cp
  [pool-spec]
  (map->HikariCP {:pool-spec pool-spec}))
