(ns struktur.reitit.ring
  (:require
   [com.stuartsierra.component :as c]
   [reitit.ring :as ring]))

;; ---------
;; / proto /
;; ---------

(defprotocol RoutesProvider
  (routes [this]))

;; ---------------
;; / ring router /
;; ---------------

(defrecord RingRouter [config options router]
  c/Lifecycle
  (start [this]
    (let [data (into []
                     (comp
                      (map val)
                      (filter #(satisfies? RoutesProvider %))
                      (mapcat routes))
                     this)
          options (assoc-in options [:data :env] this)
          router (ring/router data options)]
      (assoc this :router router)))
  (stop [this]
    (assoc this :router nil)))

(defn new-ring-router
  ([config]
   (map->RingRouter {:config config}))
  ([]
   (new-ring-router {})))

;; ----------------
;; / ring handler /
;; ----------------

(defrecord RingHandler [ring-router default-handler options handler]
  c/Lifecycle
  (start [this]
    (let [opts (if (nil? default-handler)
                 []
                 (if (nil? options)
                   [default-handler]
                   [default-handler options]))
          handler (apply ring/ring-handler (:router ring-router) opts)]
      (assoc this :handler handler)))
  (stop [this]
    (assoc this :handler nil)))

(defn new-ring-handler
  ([default-handler options]
   (map->RingHandler {:default-handler default-handler
                      :options options}))
  ([default-handler]
   (new-ring-handler default-handler nil))
  ([]
   (new-ring-handler nil)))
