(ns struktur.reitit.ring
  (:require
   [com.stuartsierra.component :as c]
   [reitit.ring :as ring]))

(defrecord RingRouter [config routes options router]
  c/Lifecycle
  (start [this]
    (let [options (assoc-in options [:data :env] this)
          router (ring/router routes options)]
      (assoc this :router router)))
  (stop [this]
    (assoc this :router nil)))

(defn new-ring-router
  ([routes config options]
   (map->RingRouter {:routes routes
                     :config config
                     :options options}))
  ([routes config]
   (new-ring-router routes config {}))
  ([routes]
   (new-ring-router routes {})))

(defrecord RingHandler [ring-router default-handler options handler]
  c/Lifecycle
  (start [this]
    (let [opts (if (nil? default-handler)
                 []
                 (if (nil? options)
                   [default-handler]
                   [default-handler options]))
          handler (apply ring/ring-handler (:router ring-router) opts)]
      (assoc this :handler handler)))
  (stop [this]
    (assoc this :handler nil)))

(defn new-ring-handler
  ([default-handler options]
   (map->RingHandler {:default-handler default-handler
                      :options options}))
  ([default-handler]
   (new-ring-handler default-handler nil))
  ([]
   (new-ring-handler nil)))
