(ns struktur.seql
  (:require
   [com.stuartsierra.component :as c]
   [seql.core :as seql]
   [seql.helpers :as seql.h]))

(defprotocol SeqlSchema
  (schema [this]))

(defn new-seql-schema
  [entity-schema]
  (reify SeqlSchema
    (schema [_]
      entity-schema)))

(defrecord Seql [db env]
  c/Lifecycle
  (start [this]
    (let [entity-schema (apply seql.h/make-schema
                               (into []
                                     (comp
                                      (map val)
                                      (filter #(satisfies? SeqlSchema %))
                                      (map schema))
                                     this))
          env {:schema entity-schema :jdbc (:spec db)}]
      (assoc this :env env)))
  (stop [this]
    (assoc this :env nil)))

(defn new-seql
  []
  (map->Seql {}))

(defn mutate!
  ([seql mutation params metadata]
   (seql/mutate! (:env seql) mutation params metadata))
  ([seql mutation params]
   (seql/mutate! (:env seql) mutation params)))

(defn add-listener!
  ([seql mutation key handler]
   (seql/add-listener! (:env seql) mutation key handler))
  ([seql mutation handler]
   (seql/add-listener! (:env seql) mutation handler)))

(defn find-listeners
  [seql mutation]
  (seql/find-listeners (:env seql) mutation))

(defn find-mutation
  [seql mutation]
  (seql/find-mutation (:env seql) mutation))

(defn remove-listener!
  ([seql mutation key]
   (seql/remove-listener! (:env seql) mutation key))
  ([seql mutation]
   (seql/remove-listener! (:env seql) mutation)))

(defn query
  ([seql entity fields conditions]
   (seql/query (:env seql) entity fields conditions))
  ([seql entity fields]
   (seql/query (:env seql) entity fields))
  ([seql entity]
   (seql/query (:env seql) entity)))
