(ns {{name}}.hx-stream
    (:use compojure.core)
    (:require [com.stuartsierra.component     :as component]
              [compojure.handler :as handler]
              [aleph.http :refer [start-http-server wrap-ring-handler]]
              [hystrix-event-stream-clj.core :as hystrix-event]))

(defroutes app-routes
  (GET "/hystrix.stream" [] (hystrix-event/stream)))

(def app
  (handler/site app-routes))

(defn server-start
  [port]
  (start-http-server (wrap-ring-handler app) {:port (Integer. port)}))


(defrecord HX [port server]
  component/Lifecycle

  (start [component]
    (let [server (server-start port)]
      (assoc component :server server)))

  (stop [component]
    (when server (server))
    (assoc component :server nil)))

(defn new-hx
  [port]
  (map->HX {:port port}))
