(ns {{name}}.api
  (:require [thrift-clj.core :as thrift]
            [com.stuartsierra.component :as component]))

(defrecord API [port hostname server]
  component/Lifecycle
  (start [component]
    ;; TODO: Uncomment this line and replace *YOUR_SERVICE_IMPL* with your service
    (comment
      (let [server (thrift/multi-threaded-server *YOUR_SERVICE_IMPL* port :bind hostname)]
        (thrift/serve! server)
        (assoc component :server server)))
    ;; TODO: Remove this line
    component)

  (stop [component]
    (when server
      (thrift/stop! server))
    (assoc component :server nil)))

(defn new-api [api-port api-hostname]
  (map->API {:port api-port
             :hostname api-hostname}))
