/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.AFn;
import clojure.lang.APersistentMap;
import clojure.lang.ASeq;
import clojure.lang.ATransientMap;
import clojure.lang.Counted;
import clojure.lang.IDeref;
import clojure.lang.IEditableCollection;
import clojure.lang.IFn;
import clojure.lang.IKVReduce;
import clojure.lang.IMapEntry;
import clojure.lang.IMapIterable;
import clojure.lang.IObj;
import clojure.lang.IPersistentMap;
import clojure.lang.ISeq;
import clojure.lang.ITransientMap;
import clojure.lang.Keyword;
import clojure.lang.MapEntry;
import clojure.lang.Obj;
import clojure.lang.PersistentHashMap;
import clojure.lang.RT;
import clojure.lang.Util;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class MMap
extends APersistentMap
implements IObj,
IEditableCollection,
IMapIterable,
IKVReduce {
    final Object[] array;
    static final int HASHTABLE_THRESHOLD = 128;
    public static final MMap EMPTY = new MMap();
    private final IPersistentMap _meta;
    static final IFn MAKE_ENTRY = new AFn(){

        public Object invoke(Object object, Object object2) {
            return MapEntry.create((Object)object, (Object)object2);
        }
    };
    static final IFn MAKE_KEY = new AFn(){

        public Object invoke(Object object, Object object2) {
            return object;
        }
    };
    static final IFn MAKE_VAL = new AFn(){

        public Object invoke(Object object, Object object2) {
            return object2;
        }
    };

    public static IPersistentMap create(Map map) {
        ITransientMap iTransientMap = EMPTY.asTransient();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            iTransientMap = iTransientMap.assoc(entry2.getKey(), entry2.getValue());
        }
        return iTransientMap.persistent();
    }

    protected MMap() {
        this.array = new Object[0];
        this._meta = null;
    }

    public MMap withMeta(IPersistentMap iPersistentMap) {
        if (this.meta() == iPersistentMap) {
            return this;
        }
        return new MMap(iPersistentMap, this.array);
    }

    MMap create(Object ... objectArray) {
        return new MMap(this.meta(), objectArray);
    }

    IPersistentMap createHT(Object[] objectArray) {
        return PersistentHashMap.create((IPersistentMap)this.meta(), (Object[])objectArray);
    }

    public static MMap createWithCheck(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; i += 2) {
            for (int j = i + 2; j < objectArray.length; j += 2) {
                if (!MMap.equalKey(objectArray[i], objectArray[j])) continue;
                throw new IllegalArgumentException("Duplicate key: " + objectArray[i]);
            }
        }
        return new MMap(objectArray);
    }

    public static MMap createAsIfByAssoc(Object[] objectArray) {
        int n;
        int n2;
        if ((objectArray.length & 1) == 1) {
            throw new IllegalArgumentException(String.format("No value supplied for key: %s", objectArray[objectArray.length - 1]));
        }
        int n3 = 0;
        for (int i = 0; i < objectArray.length; i += 2) {
            n2 = 0;
            for (n = 0; n < i; n += 2) {
                if (!MMap.equalKey(objectArray[i], objectArray[n])) continue;
                n2 = 1;
                break;
            }
            if (n2 != 0) continue;
            n3 += 2;
        }
        if (n3 < objectArray.length) {
            Object[] objectArray2 = new Object[n3];
            n2 = 0;
            for (n = 0; n < objectArray.length; n += 2) {
                int n4;
                boolean bl = false;
                for (n4 = 0; n4 < n2; n4 += 2) {
                    if (!MMap.equalKey(objectArray[n], objectArray2[n4])) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                for (n4 = objectArray.length - 2; n4 >= n && !MMap.equalKey(objectArray[n], objectArray[n4]); n4 -= 2) {
                }
                objectArray2[n2] = objectArray[n];
                objectArray2[n2 + 1] = objectArray[n4 + 1];
                n2 += 2;
            }
            if (n2 != n3) {
                throw new IllegalArgumentException("Internal error: m=" + n2);
            }
            objectArray = objectArray2;
        }
        return new MMap(objectArray);
    }

    public MMap(Object[] objectArray) {
        this.array = objectArray;
        this._meta = null;
    }

    public MMap(IPersistentMap iPersistentMap, Object[] objectArray) {
        this._meta = iPersistentMap;
        this.array = objectArray;
    }

    public int count() {
        return this.array.length / 2;
    }

    public boolean containsKey(Object object) {
        return this.indexOf(object) >= 0;
    }

    public IMapEntry entryAt(Object object) {
        int n = this.indexOf(object);
        if (n >= 0) {
            return MapEntry.create((Object)this.array[n], (Object)this.array[n + 1]);
        }
        return null;
    }

    public IPersistentMap assocEx(Object object, Object object2) {
        int n = this.indexOf(object);
        if (n >= 0) {
            throw Util.runtimeException((String)"Key already present");
        }
        if (this.array.length >= 128) {
            return this.createHT(this.array).assocEx(object, object2);
        }
        Object[] objectArray = new Object[this.array.length + 2];
        if (this.array.length > 0) {
            System.arraycopy(this.array, 0, objectArray, 2, this.array.length);
        }
        objectArray[0] = object;
        objectArray[1] = object2;
        return this.create(objectArray);
    }

    public IPersistentMap assoc(Object object, Object object2) {
        Object[] objectArray;
        int n = this.indexOf(object);
        if (n >= 0) {
            if (this.array[n + 1] == object2) {
                return this;
            }
            objectArray = (Object[])this.array.clone();
            objectArray[n + 1] = object2;
        } else {
            if (this.array.length >= 128) {
                return this.createHT(this.array).assoc(object, object2);
            }
            objectArray = new Object[this.array.length + 2];
            if (this.array.length > 0) {
                System.arraycopy(this.array, 0, objectArray, 0, this.array.length);
            }
            objectArray[objectArray.length - 2] = object;
            objectArray[objectArray.length - 1] = object2;
        }
        return this.create(objectArray);
    }

    public IPersistentMap without(Object object) {
        int n = this.indexOf(object);
        if (n >= 0) {
            int n2 = this.array.length - 2;
            if (n2 == 0) {
                return this.empty();
            }
            Object[] objectArray = new Object[n2];
            System.arraycopy(this.array, 0, objectArray, 0, n);
            System.arraycopy(this.array, n + 2, objectArray, n, n2 - n);
            return this.create(objectArray);
        }
        return this;
    }

    public IPersistentMap empty() {
        return EMPTY.withMeta(this.meta());
    }

    public final Object valAt(Object object, Object object2) {
        int n = this.indexOf(object);
        if (n >= 0) {
            return this.array[n + 1];
        }
        return object2;
    }

    public Object valAt(Object object) {
        return this.valAt(object, null);
    }

    public int capacity() {
        return this.count();
    }

    private int indexOfObject(Object object) {
        Util.EquivPred equivPred = Util.equivPred((Object)object);
        for (int i = 0; i < this.array.length; i += 2) {
            if (!equivPred.equiv(object, this.array[i])) continue;
            return i;
        }
        return -1;
    }

    private int indexOf(Object object) {
        if (object instanceof Keyword) {
            for (int i = 0; i < this.array.length; i += 2) {
                if (object != this.array[i]) continue;
                return i;
            }
            return -1;
        }
        return this.indexOfObject(object);
    }

    static boolean equalKey(Object object, Object object2) {
        if (object instanceof Keyword) {
            return object == object2;
        }
        return Util.equiv((Object)object, (Object)object2);
    }

    public Iterator iterator() {
        return new Iter(this.array, MAKE_ENTRY);
    }

    public Iterator keyIterator() {
        return new Iter(this.array, MAKE_KEY);
    }

    public Iterator valIterator() {
        return new Iter(this.array, MAKE_VAL);
    }

    public ISeq seq() {
        if (this.array.length > 0) {
            return new Seq(this.array, 0);
        }
        return null;
    }

    public IPersistentMap meta() {
        return this._meta;
    }

    public Object kvreduce(IFn iFn, Object object) {
        for (int i = 0; i < this.array.length; i += 2) {
            if (!RT.isReduced((Object)(object = iFn.invoke(object, this.array[i], this.array[i + 1])))) continue;
            return ((IDeref)object).deref();
        }
        return object;
    }

    public ITransientMap asTransient() {
        return new TransientArrayMap(this.array);
    }

    static final class TransientArrayMap
    extends ATransientMap {
        volatile int len;
        final Object[] array;
        volatile Thread owner = Thread.currentThread();

        public TransientArrayMap(Object[] objectArray) {
            this.array = new Object[Math.max(128, objectArray.length)];
            System.arraycopy(objectArray, 0, this.array, 0, objectArray.length);
            this.len = objectArray.length;
        }

        private int indexOf(Object object) {
            for (int i = 0; i < this.len; i += 2) {
                if (!MMap.equalKey(this.array[i], object)) continue;
                return i;
            }
            return -1;
        }

        ITransientMap doAssoc(Object object, Object object2) {
            int n = this.indexOf(object);
            if (n >= 0) {
                if (this.array[n + 1] != object2) {
                    this.array[n + 1] = object2;
                }
            } else {
                if (this.len >= this.array.length) {
                    return PersistentHashMap.create((Object[])this.array).asTransient().assoc(object, object2);
                }
                this.array[this.len++] = object;
                this.array[this.len++] = object2;
            }
            return this;
        }

        ITransientMap doWithout(Object object) {
            int n = this.indexOf(object);
            if (n >= 0) {
                if (this.len >= 2) {
                    this.array[n] = this.array[this.len - 2];
                    this.array[n + 1] = this.array[this.len - 1];
                }
                this.len -= 2;
            }
            return this;
        }

        Object doValAt(Object object, Object object2) {
            int n = this.indexOf(object);
            if (n >= 0) {
                return this.array[n + 1];
            }
            return object2;
        }

        int doCount() {
            return this.len / 2;
        }

        IPersistentMap doPersistent() {
            this.ensureEditable();
            this.owner = null;
            Object[] objectArray = new Object[this.len];
            System.arraycopy(this.array, 0, objectArray, 0, this.len);
            return new MMap(objectArray);
        }

        void ensureEditable() {
            if (this.owner == null) {
                throw new IllegalAccessError("Transient used after persistent! call");
            }
        }
    }

    static class Iter
    implements Iterator {
        IFn f;
        Object[] array;
        int i;

        Iter(Object[] objectArray, IFn iFn) {
            this(objectArray, -2, iFn);
        }

        Iter(Object[] objectArray, int n, IFn iFn) {
            this.array = objectArray;
            this.i = n;
            this.f = iFn;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.array.length - 2;
        }

        public Object next() {
            try {
                this.i += 2;
                return this.f.invoke(this.array[this.i], this.array[this.i + 1]);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class Seq
    extends ASeq
    implements Counted {
        final Object[] array;
        final int i;

        Seq(Object[] objectArray, int n) {
            this.array = objectArray;
            this.i = n;
        }

        public Seq(IPersistentMap iPersistentMap, Object[] objectArray, int n) {
            super(iPersistentMap);
            this.array = objectArray;
            this.i = n;
        }

        public Object first() {
            return MapEntry.create((Object)this.array[this.i], (Object)this.array[this.i + 1]);
        }

        public ISeq next() {
            if (this.i + 2 < this.array.length) {
                return new Seq(this.array, this.i + 2);
            }
            return null;
        }

        public int count() {
            return (this.array.length - this.i) / 2;
        }

        public Obj withMeta(IPersistentMap iPersistentMap) {
            if (this.meta() == iPersistentMap) {
                return this;
            }
            return new Seq(iPersistentMap, this.array, this.i);
        }
    }
}

