/*
 * Decompiled with CFR 0.152.
 */
package feign.ranger;

import com.fasterxml.jackson.databind.ObjectMapper;
import feign.Client;
import feign.Contract;
import feign.Feign;
import feign.InvocationHandlerFactory;
import feign.Logger;
import feign.Request;
import feign.RequestInterceptor;
import feign.Retryer;
import feign.Target;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.ranger.RangerTarget;
import feign.ranger.hystrix.HystrixDelegatingContract;
import feign.ranger.hystrix.HystrixInvocationHandler;
import org.apache.curator.framework.CuratorFramework;

public class RangerFeign {
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends Feign.Builder {
        private Contract contract = new Contract.Default();

        public <T> T target(Class<T> apiType, String environment, String namespace, String service, CuratorFramework curator, boolean secured, ObjectMapper objectMapper) throws Exception {
            super.invocationHandlerFactory((t, dispatch) -> new HystrixInvocationHandler((RangerTarget)t, dispatch, null));
            super.contract((Contract)new HystrixDelegatingContract(this.contract));
            return (T)this.target(new RangerTarget<T>(apiType, environment, namespace, service, curator, secured, objectMapper));
        }

        public <T> T target(Target<T> target, T fallback) {
            super.invocationHandlerFactory((t, dispatch) -> new HystrixInvocationHandler((RangerTarget)t, dispatch, fallback));
            super.contract((Contract)new HystrixDelegatingContract(this.contract));
            return (T)super.build().newInstance(target);
        }

        public <T> T target(Class<T> apiType, String url, T fallback) {
            return this.target((Target<T>)new Target.HardCodedTarget(apiType, url), fallback);
        }

        public Feign.Builder invocationHandlerFactory(InvocationHandlerFactory invocationHandlerFactory) {
            throw new UnsupportedOperationException();
        }

        public Builder contract(Contract contract) {
            this.contract = contract;
            return this;
        }

        public Feign build() {
            super.invocationHandlerFactory((InvocationHandlerFactory)new HystrixInvocationHandler.Factory());
            super.contract((Contract)new HystrixDelegatingContract(this.contract));
            return super.build();
        }

        public Builder logLevel(Logger.Level logLevel) {
            return (Builder)super.logLevel(logLevel);
        }

        public Builder client(Client client) {
            return (Builder)super.client(client);
        }

        public Builder retryer(Retryer retryer) {
            return (Builder)super.retryer(retryer);
        }

        public Builder logger(Logger logger) {
            return (Builder)super.logger(logger);
        }

        public Builder encoder(Encoder encoder) {
            return (Builder)super.encoder(encoder);
        }

        public Builder decoder(Decoder decoder) {
            return (Builder)super.decoder(decoder);
        }

        public Builder decode404() {
            return (Builder)super.decode404();
        }

        public Builder errorDecoder(ErrorDecoder errorDecoder) {
            return (Builder)super.errorDecoder(errorDecoder);
        }

        public Builder options(Request.Options options) {
            return (Builder)super.options(options);
        }

        public Builder requestInterceptor(RequestInterceptor requestInterceptor) {
            return (Builder)super.requestInterceptor(requestInterceptor);
        }

        public Builder requestInterceptors(Iterable<RequestInterceptor> requestInterceptors) {
            return (Builder)super.requestInterceptors(requestInterceptors);
        }
    }
}

