/*
 * Decompiled with CFR 0.152.
 */
package feign.ranger.hystrix;

import com.hystrix.configurator.core.BaseCommand;
import com.netflix.hystrix.HystrixCommand;
import feign.InvocationHandlerFactory;
import feign.Target;
import feign.Util;
import feign.ranger.RangerTarget;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import rx.Observable;
import rx.Single;

public class HystrixInvocationHandler<T>
implements InvocationHandler {
    private final RangerTarget<T> target;
    private final Map<Method, InvocationHandlerFactory.MethodHandler> dispatch;
    private final Object fallback;

    public HystrixInvocationHandler(RangerTarget<T> target, Map<Method, InvocationHandlerFactory.MethodHandler> dispatch, Object fallback) {
        this.target = (RangerTarget)Util.checkNotNull(target, (String)"target", (Object[])new Object[0]);
        this.dispatch = (Map)Util.checkNotNull(dispatch, (String)"dispatch", (Object[])new Object[0]);
        this.fallback = fallback;
    }

    @Override
    public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
        BaseCommand<Object> hystrixCommand = new BaseCommand<Object>(String.format("%s.%s", this.target.getService(), method.getName())){

            protected Object run() throws Exception {
                try {
                    return ((InvocationHandlerFactory.MethodHandler)HystrixInvocationHandler.this.dispatch.get(method)).invoke(args);
                }
                catch (Exception e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw (Error)t;
                }
            }

            protected Object getFallback() {
                if (HystrixInvocationHandler.this.fallback == null) {
                    return super.getFallback();
                }
                try {
                    Object result = method.invoke(HystrixInvocationHandler.this.fallback, args);
                    if (HystrixInvocationHandler.this.isReturnsHystrixCommand(method)) {
                        return ((HystrixCommand)result).execute();
                    }
                    if (HystrixInvocationHandler.this.isReturnsObservable(method)) {
                        return ((Observable)result).toBlocking().first();
                    }
                    if (HystrixInvocationHandler.this.isReturnsSingle(method)) {
                        return ((Single)result).toObservable().toBlocking().first();
                    }
                    return result;
                }
                catch (IllegalAccessException e) {
                    throw new AssertionError((Object)e);
                }
                catch (InvocationTargetException e) {
                    throw new AssertionError((Object)e.getCause());
                }
            }
        };
        if (this.isReturnsHystrixCommand(method)) {
            return hystrixCommand;
        }
        if (this.isReturnsObservable(method)) {
            return hystrixCommand.toObservable();
        }
        if (this.isReturnsSingle(method)) {
            return hystrixCommand.toObservable().toSingle();
        }
        return hystrixCommand.execute();
    }

    private boolean isReturnsHystrixCommand(Method method) {
        return HystrixCommand.class.isAssignableFrom(method.getReturnType());
    }

    private boolean isReturnsObservable(Method method) {
        return Observable.class.isAssignableFrom(method.getReturnType());
    }

    private boolean isReturnsSingle(Method method) {
        return Single.class.isAssignableFrom(method.getReturnType());
    }

    public String toString() {
        return "HystrixInvocationHandler(target=" + this.target + ", dispatch=" + this.dispatch + ", fallback=" + this.fallback + ")";
    }

    public static final class Factory
    implements InvocationHandlerFactory {
        public InvocationHandler create(Target target, Map<Method, InvocationHandlerFactory.MethodHandler> dispatch) {
            return new HystrixInvocationHandler((RangerTarget)target, dispatch, null);
        }
    }
}

