
class bounce final : public lambda_i {
  void (bounce::* fsm_state)();
  byte state;
  byte last_state;
  unsigned long t_debounce;
  unsigned long t_last_debounce;
  byte pin;
  mutex lock;
  
  void debounce(){
    int reading = digitalRead(pin);

    // reset the debouncing timer
    if (reading != last_state){
      t_last_debounce = millis();
      last_state = reading;
    }
    
    if ((::millis() - t_last_debounce) > t_debounce){
      if (reading == LOW)
        fsm_state = &bounce::off;
      else
        fsm_state = &bounce::on;
    }
  }
  
  void init(){
    pinMode(pin, INPUT);
    fsm_state = &bounce::debounce;
  }

  void on(){
    state = 1;
    fsm_state = &bounce::debounce;
  }

  void off(){
    state = 0;
    fsm_state = &bounce::debounce;
  }

  var step(){
    lock_guard guard(lock);
    (this->*fsm_state)();
    return obj<number>(state);
  }

 public:

  type_t type() const final { return type_id<bounce>; }

#if !defined(FERRET_DISABLE_STD_OUT)
  void stream_console() const final {
    runtime::print("bounce<");
    runtime::print(state);
    runtime::print(">");
  }
#endif

  explicit bounce(ref p, ref t_db) :
    fsm_state(&bounce::init),
    state(0),
    last_state(0),
    t_debounce(number::to<number_t>(t_db)),
    t_last_debounce(millis()),
    pin(number::to<number_t>(p))
    {}

  var invoke(ref args) const {
    return var((object*)this).cast<bounce>()->step();
  }
};
