
class fsm final : public lambda_i {
  mutex lock;
  var env;
  var state;
  var transitions;
public:

  fsm(ref e, ref t) : env(e), state(runtime::first(e)), transitions(t){ }

  type_t type() const { return type_id<fsm>; }

#if !defined(FERRET_DISABLE_STD_OUT)
  void stream_console() const {
    runtime::print("fsm<");
    const void* addr = this;
    runtime::print(addr);
    runtime::print(">");
  }
#endif

  var invoke(ref) const {
    return var((object*)this).cast<fsm>()->yield();
  }

  var yield() {
    lock_guard guard(lock);
    var value = run(state);
    var next = transitions.cast<lambda_i>()->invoke(runtime::list(env, state));

    if (next.is_nil())
      next = state;

    state = next;
    return value;
  }
  
};
