
class lazy_sequence final : public object, public seekable_i {
  mutex lock;
  var thunk;
  var data;
  var seq;

public:

  type_t type() const final { return type_id<lazy_sequence>; }

  bool equals(ref o) const final {
    return seekable_i::equals(var((object*)this), o);
  }

#if !defined(FERRET_DISABLE_STD_OUT)
  void stream_console() const final {
    var seq = var((object*)this);
    runtime::print("(");
    runtime::first(seq).stream_console();
    for_each(i, runtime::rest(seq)){
      runtime::print(" ");
      i.stream_console();
    }
    runtime::print(")");
  }
#endif

  explicit lazy_sequence(ref t) : thunk(t) {} 
  explicit lazy_sequence(ref d, ref t) : thunk(t), data(d) {} 

  virtual seekable_i* cast_seekable_i() { return this; }

  var cons(ref x) final {
    lock_guard guard(lock);

    if (data.is_nil())
      return obj<lazy_sequence>(x,thunk);

    return obj<sequence>(x, var((object*)this));
  }

  var first() final {
    lock_guard guard(lock);

    if (data.is_nil()){
      seq = run(thunk);
      data = runtime::first(seq);
      seq = runtime::rest(seq);
    }

    return data;
  }
  
  var rest() final {
    lock_guard guard(lock);

    if (seq.is_nil())
      seq = run(thunk);
    
    return seq;
  }
};
