
class string final : public object, public seekable_i {
  var data;

  void from_char_pointer(const char * str, int length){
    for (int i = --length; i >= 0; i--)
      data = runtime::cons(obj<number>((number_t)str[i]),data);
  }
  
public:

  type_t type() const final { return type_id<string>; }

  bool equals(ref other) const final {
    return (container() == other.cast<string>()->container());
  }

#if !defined(FERRET_DISABLE_STD_OUT)
  void stream_console() const final {
    for_each(it, data)
      runtime::print(number::to<byte>(it));
  }
#endif

  explicit string() : data(nullptr) {} 

  explicit string(ref s) : data(s) {}

  explicit string(const char * str) {
    int length = 0;
    for (length = 0; str[length] != '\0'; ++length);
    from_char_pointer(str,length);
  }

  explicit string(const char * str,number_t length) { from_char_pointer(str,length); }

  var container() const {
    return data;
  }

  virtual seekable_i* cast_seekable_i() { return this; }

  var cons(ref x) final {
    return obj<string>(runtime::cons(x,data));
  }

  var first() final {
    return runtime::first(data);
  }

  var rest() final {
    ref r = runtime::rest(data);

    if (r != runtime::list())
      return obj<string>(r);

    return runtime::list();
  }

  template <typename T>
  static T to(ref){
    T::unimplemented_function;
  }

};

#ifdef FERRET_STD_LIB
template<>
inline var obj<string>(std::string s) {
  void * storage = FERRET_ALLOCATOR::allocate<string>();
  return var(new(storage) string(s.c_str(), (number_t)s.size()));
}

template <> ::std::string string::to(ref v) { 
  ::std::stringstream ss;
  for_each(it, v.cast<string>()->container())
    ss << number::to<byte>(it);
  return ss.str();
}
#endif
