
template <typename T>
class value final : public object {
  T _value;
 public:

  type_t type() const final { return type_id<value>; }

#if !defined(FERRET_DISABLE_STD_OUT)
  void stream_console() const final {
    runtime::print("value<");
    const void* addr = this;
    runtime::print(addr);
    runtime::print(">");
  }
#endif

  template <typename... Args>
  explicit value(Args&&... args) : _value(static_cast<Args&&>(args)...) { } 

  T to_value() const {
    return _value;
  }
  
  static T to_value(ref v){
    return v.cast<value<T>>()->to_value();
  }

  T & to_reference() {
    return _value;
  }
  
  static T & to_reference(ref v) {
    return v.cast<value<T>>()->to_reference();
  }  
};
