/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.foursquare.api;

import fi.foyt.foursquare.api.FoursquareApiException;
import fi.foyt.foursquare.api.JSONFieldParser;
import fi.foyt.foursquare.api.NotificationsParser;
import fi.foyt.foursquare.api.Result;
import fi.foyt.foursquare.api.ResultMeta;
import fi.foyt.foursquare.api.entities.Badge;
import fi.foyt.foursquare.api.entities.BadgeSets;
import fi.foyt.foursquare.api.entities.Badges;
import fi.foyt.foursquare.api.entities.Category;
import fi.foyt.foursquare.api.entities.Checkin;
import fi.foyt.foursquare.api.entities.CheckinGroup;
import fi.foyt.foursquare.api.entities.Comment;
import fi.foyt.foursquare.api.entities.CompactUser;
import fi.foyt.foursquare.api.entities.CompactVenue;
import fi.foyt.foursquare.api.entities.CompleteSpecial;
import fi.foyt.foursquare.api.entities.CompleteTip;
import fi.foyt.foursquare.api.entities.CompleteUser;
import fi.foyt.foursquare.api.entities.CompleteVenue;
import fi.foyt.foursquare.api.entities.GeoCode;
import fi.foyt.foursquare.api.entities.KeywordGroup;
import fi.foyt.foursquare.api.entities.LeaderboardItemGroup;
import fi.foyt.foursquare.api.entities.LinkGroup;
import fi.foyt.foursquare.api.entities.MiniVenue;
import fi.foyt.foursquare.api.entities.Photo;
import fi.foyt.foursquare.api.entities.PhotoGroup;
import fi.foyt.foursquare.api.entities.RecommendationGroup;
import fi.foyt.foursquare.api.entities.Recommended;
import fi.foyt.foursquare.api.entities.Setting;
import fi.foyt.foursquare.api.entities.SpecialGroup;
import fi.foyt.foursquare.api.entities.TipGroup;
import fi.foyt.foursquare.api.entities.Todo;
import fi.foyt.foursquare.api.entities.TodoGroup;
import fi.foyt.foursquare.api.entities.UserGroup;
import fi.foyt.foursquare.api.entities.VenueGroup;
import fi.foyt.foursquare.api.entities.VenueHistoryGroup;
import fi.foyt.foursquare.api.entities.VenuesAutocompleteResult;
import fi.foyt.foursquare.api.entities.VenuesSearchResult;
import fi.foyt.foursquare.api.entities.Warning;
import fi.foyt.foursquare.api.entities.notifications.Notification;
import fi.foyt.foursquare.api.io.DefaultIOHandler;
import fi.foyt.foursquare.api.io.IOHandler;
import fi.foyt.foursquare.api.io.Method;
import fi.foyt.foursquare.api.io.MultipartParameter;
import fi.foyt.foursquare.api.io.Response;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FoursquareApi {
    private static final String DEFAULT_VERSION = "20140701";
    private boolean skipNonExistingFields = true;
    private String clientId;
    private String clientSecret;
    private String redirectUrl;
    private String oAuthToken;
    private IOHandler ioHandler;
    private String version = "20140701";
    private boolean useCallback = true;
    private static final String apiUrl = "https://api.foursquare.com/v2/";

    public FoursquareApi(String clientId, String clientSecret, String redirectUrl) {
        this(clientId, clientSecret, redirectUrl, new DefaultIOHandler());
    }

    public FoursquareApi(String clientId, String clientSecret, String redirectUrl, IOHandler ioHandler) {
        this(clientId, clientSecret, redirectUrl, null, ioHandler);
    }

    public FoursquareApi(String clientId, String clientSecret, String redirectUrl, String oAuthToken, IOHandler ioHandler) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.redirectUrl = redirectUrl;
        this.oAuthToken = oAuthToken;
        this.ioHandler = ioHandler;
    }

    public String getOAuthToken() {
        return this.oAuthToken;
    }

    public void setoAuthToken(String oAuthToken) {
        this.oAuthToken = oAuthToken;
    }

    public void setSkipNonExistingFields(boolean skipNonExistingFields) {
        this.skipNonExistingFields = skipNonExistingFields;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setUseCallback(boolean useCallback) {
        this.useCallback = useCallback;
    }

    public boolean getUseCallback() {
        return this.useCallback;
    }

    public Result<CompleteUser> user(String userId) throws FoursquareApiException {
        try {
            if (userId == null) {
                userId = "self";
            }
            ApiRequestResponse response = this.doApiRequest(Method.GET, "users/" + userId, true, new Object[0]);
            CompleteUser result = null;
            if (response.getMeta().getCode() == 200) {
                result = (CompleteUser)JSONFieldParser.parseEntity(CompleteUser.class, response.getResponse().getJSONObject("user"), this.skipNonExistingFields);
            }
            return new Result<Object>(response.getMeta(), result);
        }
        catch (JSONException e) {
            throw new FoursquareApiException(e);
        }
    }

    public Result<LeaderboardItemGroup> usersLeaderboard(Integer neighbors) throws FoursquareApiException {
        try {
            ApiRequestResponse response = this.doApiRequest(Method.GET, "users/leaderboard", true, "neighbors", neighbors);
            LeaderboardItemGroup result = null;
            if (response.getMeta().getCode() == 200) {
                result = (LeaderboardItemGroup)JSONFieldParser.parseEntity(LeaderboardItemGroup.class, response.getResponse().getJSONObject("leaderboard"), this.skipNonExistingFields);
            }
            return new Result<Object>(response.getMeta(), result);
        }
        catch (JSONException e) {
            throw new FoursquareApiException(e);
        }
    }

    public Result<Badges> usersBadges(String userId) throws FoursquareApiException {
        try {
            if (userId == null) {
                userId = "self";
            }
            ApiRequestResponse response = this.doApiRequest(Method.GET, "users/" + userId + "/badges", true, new Object[0]);
            Badges result = null;
            if (response.getMeta().getCode() == 200) {
                BadgeSets sets = (BadgeSets)JSONFieldParser.parseEntity(BadgeSets.class, response.getResponse().getJSONObject("sets"), this.skipNonExistingFields);
                Badge[] badges = (Badge[])JSONFieldParser.parseEntitiesHash(Badge.class, response.getResponse().getJSONObject("badges"), this.skipNonExistingFields);
                String defaultSetType = response.getResponse().getString("defaultSetType");
                result = new Badges(sets, badges, defaultSetType);
            }
            return new Result<Object>(response.getMeta(), result);
        }
        catch (JSONException e) {
            throw new FoursquareApiException(e);
        }
    }

    public Result<CheckinGroup> usersCheckins(String userId, Integer limit, Integer offset, Long afterTimestamp, Long beforeTimestamp) throws FoursquareApiException {
        try {
            if (userId == null) {
                userId = "self";
            }
            ApiRequestResponse response = this.doApiRequest(Method.GET, "users/" + userId + "/checkins", true, "limit", limit, "offset", offset, "afterTimestamp", afterTimestamp, "beforeTimestamp", beforeTimestamp);
            CheckinGroup result = null;
            if (response.getMeta().getCode() == 200) {
                result = (CheckinGroup)JSONFieldParser.parseEntity(CheckinGroup.class, response.getResponse().getJSONObject("checkins"), this.skipNonExistingFields);
            }
            return new Result<Object>(response.getMeta(), result);
        }
        catch (JSONException e) {
            throw new FoursquareApiException(e);
        }
    }

    public Result<TipGroup> usersTips(String userId, String sort, String ll, Integer limit, Integer offset) throws FoursquareApiException {
        try {
            if (userId == null) {
                userId = "self";
            }
            ApiRequestResponse response = this.doApiRequest(Method.GET, "users/" + userId + "/tips", true, "sort", sort, "ll", ll, "limit", limit, "offset", offset);
            TipGroup result = null;
            if (response.getMeta().getCode() == 200) {
                result = (TipGroup)JSONFieldParser.parseEntity(TipGroup.class, response.getResponse().getJSONObject("tips"), this.skipNonExistingFields);
            }
            return new Result<Object>(response.getMeta(), result);
        }
        catch (JSONException e) {
            throw new FoursquareApiException(e);
        }
    }

    public Result<TodoGroup> usersTodos(String userId, String sort, String ll) throws FoursquareApiException {
        try {
            if (userId == null) {
                userId = "self";
            }
            ApiRequestResponse response = this.doApiRequest(Method.GET, "users/" + userId + "/todos", true, "sort", sort, "ll", ll);
            TodoGroup result = null;
            if (response.getMeta().getCode() == 200) {
                result = (TodoGroup)JSONFieldParser.parseEntity(TodoGroup.class, response.getResponse().getJSONObject("todos"), this.skipNonExistingFields);
            }
            return new Result<Object>(response.getMeta(), result);
        }
        catch (JSONException e) {
            throw new FoursquareApiException(e);
        }
    }

    public Result<VenueHistoryGroup> usersVenueHistory(String userId, Long beforeTimestamp, Long afterTimestamp) throws FoursquareApiException {
        try {
            if (userId == null) {
                userId = "self";
            }
            ApiRequestResponse response = this.doApiRequest(Method.GET, "users/" + userId + "/venuehistory", true, "beforeTimestamp", beforeTimestamp, "afterTimestamp", afterTimestamp);
            VenueHistoryGroup result = null;
            if (response.getMeta().getCode() == 200) {
                result = (VenueHistoryGroup)JSONFieldParser.parseEntity(VenueHistoryGroup.class, response.getResponse().getJSONObject("venues"), this.skipNonExistingFields);
            }
            return new Result<Object>(response.getMeta(), result);
        }
        catch (JSONException e) {
            throw new FoursquareApiException(e);
        }
    }

    public Result<CompleteUser> usersRequest(String id) throws FoursquareApiException {
        try {
            ApiRequestResponse response = this.doApiRequest(Method.POST, "users/" + id + "/request", true, new Object[0]);
            CompleteUser result = null;
            if (response.getMeta().getCode() == 200) {
                result = (CompleteUser)JSONFieldParser.parseEntity(CompleteUser.class, response.getResponse().getJSONObject("user"), this.skipNonExistingFields);
            }
            return new Result<Object>(response.getMeta(), result);
        }
        catch (JSONException e) {
            throw new FoursquareApiException(e);
        }
    }

    public Result<CompleteUser> usersUnfriend(String userId) throws FoursquareApiException {
        try {
            ApiRequestResponse response = this.doApiRequest(Method.POST, "users/" + userId + "/unfriend", true, new Object[0]);
            CompleteUser result = null;
            if (response.getMeta().getCode() == 200) {
                result = (CompleteUser)JSONFieldParser.parseEntity(CompleteUser.class, response.getResponse().getJSONObject("user"), this.skipNonExistingFields);
            }
            return new Result<Object>(response.getMeta(), result);
        }
        catch (JSONException e) {
            throw new FoursquareApiException(e);
        }
    }

    public Result<CompleteUser> usersApprove(String userId) throws FoursquareApiException {
        try {
            ApiRequestResponse response = this.doApiRequest(Method.POST, "users/" + userId + "/approve", true, new Object[0]);
            CompleteUser result = null;
            if (response.getMeta().getCode() == 200) {
                result = (CompleteUser)JSONFieldParser.parseEntity(CompleteUser.class, response.getResponse().getJSONObject("user"), this.skipNonExistingFields);
            }
            return new Result<Object>(response.getMeta(), result);
        }
        catch (JSONException e) {
            throw new FoursquareApiException(e);
        }
    }

    public Result<CompleteUser> usersDeny(String userId) throws FoursquareApiException {
        try {
            ApiRequestResponse response = this.doApiRequest(Method.POST, "users/" + userId + "/deny", true, new Object[0]);
            CompleteUser result = null;
            if (response.getMeta().getCode() == 200) {
                result = (CompleteUser)JSONFieldParser.parseEntity(CompleteUser.class, response.getResponse().getJSONObject("user"), this.skipNonExistingFields);
            }
            return new Result<Object>(response.getMeta(), result);
        }
        catch (JSONException e) {
            throw new FoursquareApiException(e);
        }
    }

    public Result<CompleteUser> usersSetPings(String userId, String value) throws FoursquareApiException {
        try {
            ApiRequestResponse response = this.doApiRequest(Method.POST, "users/" + userId + "/setpings", true, "value", value);
            CompleteUser result = null;
            if (response.getMeta().getCode() == 200) {
                result = (CompleteUser)JSONFieldParser.parseEntity(CompleteUser.class, response.getResponse().getJSONObject("user"), this.skipNonExistingFields);
            }
            return new Result<Object>(response.getMeta(), result);
        }
        catch (JSONException e) {
            throw new FoursquareApiException(e);
        }
    }

    public Result<CompactUser[]> usersSearch(String phone, String email, String twitter, String twitterSource, String fbid, String name) throws FoursquareApiException {
        try {
            ApiRequestResponse response = this.doApiRequest(Method.GET, "users/search", true, "phone", phone, "email", email, "twitter", twitter, "twitterSource", twitterSource, "fbid", fbid, "name", name);
            CompactUser[] result = null;
            if (response.getMeta().getCode() == 200) {
                result = (CompactUser[])JSONFieldParser.parseEntities(CompactUser.class, response.getResponse().getJSONArray("results"), this.skipNonExistingFields);
            }
            return new Result<Object>(response.getMeta(), result);
        }
        catch (JSONException e) {
            throw new FoursquareApiException(e);
        }
    }

    public Result<CompactUser[]> usersRequests() throws FoursquareApiException {
        try {
            ApiRequestResponse response = this.doApiRequest(Method.GET, "users/requests", true, new Object[0]);
            CompactUser[] result = null;
            if (response.getMeta().getCode() == 200) {
                result = (CompactUser[])JSONFieldParser.parseEntities(CompactUser.class, response.getResponse().getJSONArray("requests"), this.skipNonExistingFields);
            }
            return new Result<Object>(response.getMeta(), result);
        }
        catch (JSONException e) {
            throw new FoursquareApiException(e);
        }
    }

    public Result<UserGroup> usersFriends(String userId) throws FoursquareApiException {
        try {
            if (userId == null) {
                userId = "self";
            }
            ApiRequestResponse response = this.doApiRequest(Method.GET, "users/" + userId + "/friends", true, new Object[0]);
            UserGroup result = null;
            if (response.getMeta().getCode() == 200) {
                result = (UserGroup)JSONFieldParser.parseEntity(UserGroup.class, response.getResponse().getJSONObject("friends"), this.skipNonExistingFields);
            }
            return new Result<Object>(response.getMeta(), result);
        }
        catch (JSONException e) {
            throw new FoursquareApiException(e);
        }
    }

    public Result<CompleteVenue> venue(String venueId) throws FoursquareApiException {
        try {
            ApiRequestResponse response = this.doApiRequest(Method.GET, "venues/" + venueId, this.isAuthenticated(), new Object[0]);
            CompleteVenue result = null;
            if (response.getMeta().getCode() == 200) {
                result = (CompleteVenue)JSONFieldParser.parseEntity(CompleteVenue.class, response.getResponse().getJSONObject("venue"), this.skipNonExistingFields);
            }
            return new Result<Object>(response.getMeta(), result);
        }
        catch (JSONException e) {
            throw new FoursquareApiException(e);
        }
    }

    public Result<Recommended> venuesExplore(String ll, Double llAcc, Double alt, Double altAcc, Integer radius, String section, String query, Integer limit, String basis) throws FoursquareApiException {
        try {
            ApiRequestResponse response = this.doApiRequest(Method.GET, "venues/explore", this.isAuthenticated(), "ll", ll, "llAcc", llAcc, "alt", alt, "altAcc", altAcc, "radius", radius, "section", section, "query", query, "limit", limit, "basis", basis);
            Recommended result = null;
            if (response.getMeta().getCode() == 200) {
                KeywordGroup keywords = response.getResponse().has("keywords") ? (KeywordGroup)JSONFieldParser.parseEntity(KeywordGroup.class, response.getResponse().getJSONObject("keywords"), this.skipNonExistingFields) : null;
                RecommendationGroup[] groups = (RecommendationGroup[])JSONFieldParser.parseEntities(RecommendationGroup.class, response.getResponse().getJSONArray("groups"), this.skipNonExistingFields);
                Warning warning = response.getResponse().has("warning") ? (Warning)JSONFieldParser.parseEntity(Warning.class, response.getResponse().getJSONObject("warning"), this.skipNonExistingFields) : null;
                result = new Recommended(keywords, groups, warning);
            }
            return new Result<Object>(response.getMeta(), result);
        }
        catch (JSONException e) {
            throw new FoursquareApiException(e);
        }
    }

    public Result<CheckinGroup> venuesHereNow(String venueId, Integer limit, Integer offset, Long afterTimestamp) throws FoursquareApiException {
        try {
            ApiRequestResponse response = this.doApiRequest(Method.GET, "venues/" + venueId + "/herenow", this.isAuthenticated(), "limit", limit, "offset", offset, "afterTimestamp", afterTimestamp);
            CheckinGroup result = null;
            if (response.getMeta().getCode() == 200) {
                result = (CheckinGroup)JSONFieldParser.parseEntity(CheckinGroup.class, response.getResponse().getJSONObject("hereNow"), this.skipNonExistingFields);
            }
            return new Result<Object>(response.getMeta(), result);
        }
        catch (JSONException e) {
            throw new FoursquareApiException(e);
        }
    }

    public Result<TipGroup> venuesTips(String venueId, String sort, Integer limit, Integer offset) throws FoursquareApiException {
        try {
            ApiRequestResponse response = this.doApiRequest(Method.GET, "venues/" + venueId + "/tips", this.isAuthenticated(), "sort", sort, "limit", limit, "offset", offset);
            TipGroup result = null;
            if (response.getMeta().getCode() == 200) {
                result = (TipGroup)JSONFieldParser.parseEntity(TipGroup.class, response.getResponse().getJSONObject("tips"), this.skipNonExistingFields);
            }
            return new Result<Object>(response.getMeta(), result);
        }
        catch (JSONException e) {
            throw new FoursquareApiException(e);
        }
    }

    public Result<PhotoGroup> venuesPhotos(String venueId, String group, Integer limit, Integer offset) throws FoursquareApiException {
        try {
            ApiRequestResponse response = this.doApiRequest(Method.GET, "venues/" + venueId + "/photos", this.isAuthenticated(), "group", group, "limit", limit, "offset", offset);
            PhotoGroup result = null;
            if (response.getMeta().getCode() == 200) {
                result = (PhotoGroup)JSONFieldParser.parseEntity(PhotoGroup.class, response.getResponse().getJSONObject("photos"), this.skipNonExistingFields);
            }
            return new Result<Object>(response.getMeta(), result);
        }
        catch (JSONException e) {
            throw new FoursquareApiException(e);
        }
    }

    public Result<LinkGroup> venuesLinks(String id) throws FoursquareApiException {
        try {
            ApiRequestResponse response = this.doApiRequest(Method.GET, "venues/" + id + "/links", this.isAuthenticated(), new Object[0]);
            LinkGroup result = null;
            if (response.getMeta().getCode() == 200) {
                result = (LinkGroup)JSONFieldParser.parseEntity(LinkGroup.class, response.getResponse().getJSONObject("links"), this.skipNonExistingFields);
            }
            return new Result<Object>(response.getMeta(), result);
        }
        catch (JSONException e) {
            throw new FoursquareApiException(e);
        }
    }

    public Result<Todo> venuesMarkTodo(String venuesId, String text) throws FoursquareApiException {
        try {
            ApiRequestResponse response = this.doApiRequest(Method.POST, "venues/" + venuesId + "/marktodo", true, "text", text);
            Todo result = null;
            if (response.getMeta().getCode() == 200) {
                result = (Todo)JSONFieldParser.parseEntity(Todo.class, response.getResponse().getJSONObject("todo"), this.skipNonExistingFields);
            }
            return new Result<Object>(response.getMeta(), result);
        }
        catch (JSONException e) {
            throw new FoursquareApiException(e);
        }
    }

    public Result<Object> venuesFlag(String id, String problem, String venueId) throws FoursquareApiException {
        try {
            ApiRequestResponse response = this.doApiRequest(Method.POST, "venues/" + id + "/flag", true, "problem", problem, "venueId", venueId);
            return new Result<Object>(response.getMeta(), null);
        }
        catch (JSONException e) {
            throw new FoursquareApiException(e);
        }
    }

    public Result<Object> venuesProposeEdit(String id, String name, String address, String crossStreet, String city, String state, String zip, String phone, String ll, String primaryCategoryId) throws FoursquareApiException {
        try {
            ApiRequestResponse response = this.doApiRequest(Method.POST, "venues/" + id + "/proposeedit", true, "name", name, "address", address, "crossStreet", crossStreet, "city", city, "state", state, "zip", zip, "phone", phone, "ll", ll, "primaryCategoryId", primaryCategoryId);
            return new Result<Object>(response.getMeta(), null);
        }
        catch (JSONException e) {
            throw new FoursquareApiException(e);
        }
    }

    public Result<Object> venuesEdit(String id, String name, String address, String crossStreet, String city, String state, String zip, String phone, String ll, String categoryId, String twitter, String description, String url) throws FoursquareApiException {
        try {
            ApiRequestResponse response = this.doApiRequest(Method.POST, "venues/" + id + "/edit", true, "name", name, "address", address, "crossStreet", crossStreet, "city", city, "state", state, "zip", zip, "phone", phone, "ll", ll, "categoryId", categoryId, "twitter", twitter, "description", description, "url", url);
            return new Result<Object>(response.getMeta(), null);
        }
        catch (JSONException e) {
            throw new FoursquareApiException(e);
        }
    }

    public Result<CompleteVenue> venuesAdd(String name, String address, String crossStreet, String city, String state, String zip, String phone, String ll, String primaryCategoryId) throws FoursquareApiException {
        try {
            ApiRequestResponse response = this.doApiRequest(Method.POST, "venues/add", true, "name", name, "address", address, "crossStreet", crossStreet, "city", city, "state", state, "zip", zip, "phone", phone, "ll", ll, "primaryCategoryId", primaryCategoryId);
            CompleteVenue result = null;
            if (response.getMeta().getCode() == 200) {
                result = (CompleteVenue)JSONFieldParser.parseEntity(CompleteVenue.class, response.getResponse().getJSONObject("venue"), this.skipNonExistingFields);
            }
            return new Result<Object>(response.getMeta(), result);
        }
        catch (JSONException e) {
            throw new FoursquareApiException(e);
        }
    }

    public Result<Category[]> venuesCategories() throws FoursquareApiException {
        try {
            ApiRequestResponse response = this.doApiRequest(Method.GET, "venues/categories", this.isAuthenticated(), new Object[0]);
            Category[] result = null;
            if (response.getMeta().getCode() == 200) {
                result = (Category[])JSONFieldParser.parseEntities(Category.class, response.getResponse().getJSONArray("categories"), this.skipNonExistingFields);
            }
            return new Result<Object>(response.getMeta(), result);
        }
        catch (JSONException e) {
            throw new FoursquareApiException(e);
        }
    }

    public Result<VenuesSearchResult> venuesSearch(String ll, Double llAcc, Double alt, Double altAcc, String query, Integer limit, String intent, String categoryId, String url, String providerId, String linkedId, Integer radius, String near) throws FoursquareApiException {
        try {
            ApiRequestResponse response = this.doApiRequest(Method.GET, "venues/search", this.isAuthenticated(), "ll", ll, "llAcc", llAcc, "alt", alt, "altAcc", altAcc, "query", query, "limit", limit, "intent", intent, "categoryId", categoryId, "url", url, "providerId", providerId, "linkedId", linkedId, "radius", radius, "near", near);
            VenuesSearchResult result = null;
            if (response.getMeta().getCode() == 200) {
                CompactVenue[] venues = null;
                VenueGroup[] groups = null;
                if (response.getResponse().has("groups")) {
                    groups = (VenueGroup[])JSONFieldParser.parseEntities(VenueGroup.class, response.getResponse().getJSONArray("groups"), this.skipNonExistingFields);
                }
                if (response.getResponse().has("venues")) {
                    venues = (CompactVenue[])JSONFieldParser.parseEntities(CompactVenue.class, response.getResponse().getJSONArray("venues"), this.skipNonExistingFields);
                }
                result = new VenuesSearchResult(venues, groups);
            }
            return new Result<Object>(response.getMeta(), result);
        }
        catch (JSONException e) {
            throw new FoursquareApiException(e);
        }
    }

    private Result<VenuesSearchResult> handleVenueSearchResult(ApiRequestResponse response) throws FoursquareApiException, JSONException {
        VenuesSearchResult result = null;
        if (response.getMeta().getCode() == 200) {
            CompactVenue[] venues = null;
            VenueGroup[] groups = null;
            GeoCode geocode = null;
            if (response.getResponse().has("groups")) {
                groups = (VenueGroup[])JSONFieldParser.parseEntities(VenueGroup.class, response.getResponse().getJSONArray("groups"), this.skipNonExistingFields);
            }
            if (response.getResponse().has("venues")) {
                venues = (CompactVenue[])JSONFieldParser.parseEntities(CompactVenue.class, response.getResponse().getJSONArray("venues"), this.skipNonExistingFields);
            }
            if (response.getResponse().has("geocode")) {
                geocode = (GeoCode)JSONFieldParser.parseEntity(GeoCode.class, response.getResponse().getJSONObject("geocode"), this.skipNonExistingFields);
            }
            result = new VenuesSearchResult(venues, groups, geocode);
        }
        return new Result<Object>(response.getMeta(), result);
    }

    public Result<VenuesSearchResult> venuesSearch(Map<String, String> params) throws FoursquareApiException {
        ArrayList<String> argsList = new ArrayList<String>();
        for (String s : params.keySet()) {
            argsList.add(s);
            argsList.add(params.get(s));
        }
        Object[] args = argsList.toArray();
        try {
            ApiRequestResponse response = this.doApiRequest(Method.GET, "venues/search", this.isAuthenticated(), args);
            return this.handleVenueSearchResult(response);
        }
        catch (JSONException e) {
            throw new FoursquareApiException(e);
        }
    }

    public Result<VenuesSearchResult> venuesSearch(String near, String query, Integer limit, String intent, String categoryId, String url, String providerId, String linkedId) throws FoursquareApiException {
        try {
            ApiRequestResponse response = this.doApiRequest(Method.GET, "venues/search", this.isAuthenticated(), "near", near, "query", query, "limit", limit, "intent", intent, "categoryId", categoryId, "url", url, "providerId", providerId, "linkedId", linkedId);
            return this.handleVenueSearchResult(response);
        }
        catch (JSONException e) {
            throw new FoursquareApiException(e);
        }
    }

    public Result<VenuesAutocompleteResult> venuesSuggestCompletion(String ll, Double llAcc, Double alt, Double altAcc, String query, int limit) throws FoursquareApiException {
        try {
            ApiRequestResponse response = this.doApiRequest(Method.GET, "venues/suggestcompletion", this.isAuthenticated(), "ll", ll, "llAcc", llAcc, "alt", alt, "altAcc", altAcc, "query", query, "limit", limit);
            VenuesAutocompleteResult result = null;
            if (response.getMeta().getCode() == 200) {
                MiniVenue[] venues = null;
                if (response.getResponse().has("minivenues")) {
                    venues = (MiniVenue[])JSONFieldParser.parseEntities(MiniVenue.class, response.getResponse().getJSONArray("minivenues"), this.skipNonExistingFields);
                }
                result = new VenuesAutocompleteResult(venues);
            }
            return new Result<Object>(response.getMeta(), result);
        }
        catch (JSONException e) {
            throw new FoursquareApiException(e);
        }
    }

    public Result<CompactVenue[]> venuesTrending(String ll, Integer limit, Integer radius) throws FoursquareApiException {
        try {
            ApiRequestResponse response = this.doApiRequest(Method.GET, "venues/trending", this.isAuthenticated(), "ll", ll, "limit", limit, "radius", radius);
            CompactVenue[] result = null;
            if (response.getMeta().getCode() == 200) {
                result = (CompactVenue[])JSONFieldParser.parseEntities(CompactVenue.class, response.getResponse().getJSONArray("venues"), this.skipNonExistingFields);
            }
            return new Result<Object>(response.getMeta(), result);
        }
        catch (JSONException e) {
            throw new FoursquareApiException(e);
        }
    }

    public Result<Checkin> checkin(String checkinId, String signature) throws FoursquareApiException {
        try {
            ApiRequestResponse response = this.doApiRequest(Method.GET, "checkins/" + checkinId, true, "signature", signature);
            Checkin result = null;
            if (response.getMeta().getCode() == 200) {
                result = (Checkin)JSONFieldParser.parseEntity(Checkin.class, response.getResponse().getJSONObject("checkin"), this.skipNonExistingFields);
            }
            return new Result<Object>(response.getMeta(), result);
        }
        catch (JSONException e) {
            throw new FoursquareApiException(e);
        }
    }

    public Result<Checkin> checkinsAdd(String venueId, String venue, String shout, String broadcast, String ll, Double llAcc, Double alt, Double altAcc) throws FoursquareApiException {
        try {
            ApiRequestResponse response = this.doApiRequest(Method.POST, "checkins/add", true, "venueId", venueId, "venue", venue, "shout", shout, "broadcast", broadcast, "ll", ll, "llAcc", llAcc, "alt", alt, "altAcc", altAcc);
            Checkin result = null;
            List<Notification<?>> notifications = null;
            if (response.getMeta().getCode() == 200) {
                result = (Checkin)JSONFieldParser.parseEntity(Checkin.class, response.getResponse().getJSONObject("checkin"), this.skipNonExistingFields);
                notifications = NotificationsParser.parseNotifications(response.getNotifications(), this.skipNonExistingFields);
            }
            return new Result<Object>(response.getMeta(), result, notifications);
        }
        catch (JSONException e) {
            throw new FoursquareApiException(e);
        }
    }

    public Result<Checkin[]> checkinsRecent(String ll, Integer limit, Long afterTimestamp) throws FoursquareApiException {
        try {
            ApiRequestResponse response = this.doApiRequest(Method.GET, "checkins/recent", true, "ll", ll, "limit", limit, "afterTimestamp", afterTimestamp);
            Checkin[] result = null;
            if (response.getMeta().getCode() == 200) {
                result = (Checkin[])JSONFieldParser.parseEntities(Checkin.class, response.getResponse().getJSONArray("recent"), this.skipNonExistingFields);
            }
            return new Result<Object>(response.getMeta(), result);
        }
        catch (JSONException e) {
            throw new FoursquareApiException(e);
        }
    }

    public Result<Comment> checkinsAddComment(String checkinId, String text) throws FoursquareApiException {
        try {
            ApiRequestResponse response = this.doApiRequest(Method.POST, "checkins/" + checkinId + "/addcomment", true, "text", text);
            Comment result = null;
            if (response.getMeta().getCode() == 200) {
                result = (Comment)JSONFieldParser.parseEntity(Comment.class, response.getResponse().getJSONObject("comment"), this.skipNonExistingFields);
            }
            return new Result<Object>(response.getMeta(), result);
        }
        catch (JSONException e) {
            throw new FoursquareApiException(e);
        }
    }

    public Result<Checkin> checkinsDeleteComment(String checkinId, String commentId) throws FoursquareApiException {
        try {
            ApiRequestResponse response = this.doApiRequest(Method.POST, "checkins/" + checkinId + "/deletecomment", true, "commentId", commentId);
            Checkin result = null;
            if (response.getMeta().getCode() == 200) {
                result = (Checkin)JSONFieldParser.parseEntity(Checkin.class, response.getResponse().getJSONObject("checkin"), this.skipNonExistingFields);
            }
            return new Result<Object>(response.getMeta(), result, null);
        }
        catch (JSONException e) {
            throw new FoursquareApiException(e);
        }
    }

    public Result<CompleteTip> tip(String id) throws FoursquareApiException {
        try {
            ApiRequestResponse response = this.doApiRequest(Method.GET, "tips/" + id, false, new Object[0]);
            CompleteTip result = null;
            if (response.getMeta().getCode() == 200) {
                result = (CompleteTip)JSONFieldParser.parseEntity(CompleteTip.class, response.getResponse().getJSONObject("tip"), this.skipNonExistingFields);
            }
            return new Result<Object>(response.getMeta(), result);
        }
        catch (JSONException e) {
            throw new FoursquareApiException(e);
        }
    }

    public Result<CompleteTip> tipsAdd(String venueId, String text, String url) throws FoursquareApiException {
        try {
            ApiRequestResponse response = this.doApiRequest(Method.POST, "tips/add", true, "venueId", venueId, "text", text, "url", url);
            CompleteTip result = null;
            if (response.getMeta().getCode() == 200) {
                result = (CompleteTip)JSONFieldParser.parseEntity(CompleteTip.class, response.getResponse().getJSONObject("tip"), this.skipNonExistingFields);
            }
            return new Result<Object>(response.getMeta(), result);
        }
        catch (JSONException e) {
            throw new FoursquareApiException(e);
        }
    }

    public Result<CompleteTip[]> tipsSearch(String ll, Integer limit, Integer offset, String filter, String query) throws FoursquareApiException {
        try {
            ApiRequestResponse response = this.doApiRequest(Method.GET, "tips/search", this.isAuthenticated(), "ll", ll, "limit", limit, "offset", offset, "filter", filter, "query", query);
            CompleteTip[] result = null;
            if (response.getMeta().getCode() == 200) {
                result = (CompleteTip[])JSONFieldParser.parseEntities(CompleteTip.class, response.getResponse().getJSONArray("tips"), this.skipNonExistingFields);
            }
            return new Result<Object>(response.getMeta(), result);
        }
        catch (JSONException e) {
            throw new FoursquareApiException(e);
        }
    }

    public Result<Todo> tipsMarkTodo(String tipId) throws FoursquareApiException {
        try {
            ApiRequestResponse response = this.doApiRequest(Method.POST, "tips/" + tipId + "/marktodo", true, new Object[0]);
            Todo result = null;
            if (response.getMeta().getCode() == 200) {
                result = (Todo)JSONFieldParser.parseEntity(Todo.class, response.getResponse().getJSONObject("todo"), this.skipNonExistingFields);
            }
            return new Result<Object>(response.getMeta(), result);
        }
        catch (JSONException e) {
            throw new FoursquareApiException(e);
        }
    }

    public Result<CompleteTip> tipsMarkDone(String tipId) throws FoursquareApiException {
        try {
            ApiRequestResponse response = this.doApiRequest(Method.POST, "tips/" + tipId + "/markdone", true, new Object[0]);
            CompleteTip result = null;
            if (response.getMeta().getCode() == 200) {
                result = (CompleteTip)JSONFieldParser.parseEntity(CompleteTip.class, response.getResponse().getJSONObject("tip"), this.skipNonExistingFields);
            }
            return new Result<Object>(response.getMeta(), result);
        }
        catch (JSONException e) {
            throw new FoursquareApiException(e);
        }
    }

    public Result<CompleteTip> tipsUnmark(String tipId) throws FoursquareApiException {
        try {
            ApiRequestResponse response = this.doApiRequest(Method.POST, "tips/" + tipId + "/unmark", true, new Object[0]);
            CompleteTip result = null;
            if (response.getMeta().getCode() == 200) {
                result = (CompleteTip)JSONFieldParser.parseEntity(CompleteTip.class, response.getResponse().getJSONObject("tip"), this.skipNonExistingFields);
            }
            return new Result<Object>(response.getMeta(), result);
        }
        catch (JSONException e) {
            throw new FoursquareApiException(e);
        }
    }

    public Result<Photo> photo(String id) throws FoursquareApiException {
        try {
            ApiRequestResponse response = this.doApiRequest(Method.GET, "photos/" + id, true, new Object[0]);
            Photo result = null;
            if (response.getMeta().getCode() == 200) {
                result = (Photo)JSONFieldParser.parseEntity(Photo.class, response.getResponse().getJSONObject("photo"), this.skipNonExistingFields);
            }
            return new Result<Object>(response.getMeta(), result);
        }
        catch (JSONException e) {
            throw new FoursquareApiException(e);
        }
    }

    public Result<Photo> photosAdd(String checkinId, String tipId, String venueId, String broadcast, String ll, Double llAcc, Double alt, Double altAcc, byte[] data) throws FoursquareApiException {
        try {
            ApiRequestResponse response = this.doApiMultipartMimeRequest("photos/add", true, "checkinId", checkinId, "tipId", tipId, "venueId", venueId, "broadcast", broadcast, "ll", ll, "llAcc", llAcc, "alt", alt, "altAcc", altAcc, new MultipartParameter("photo", "image/jpeg", data));
            Photo result = null;
            if (response.getMeta().getCode() == 200) {
                result = (Photo)JSONFieldParser.parseEntity(Photo.class, response.getResponse().getJSONObject("photo"), this.skipNonExistingFields);
            }
            return new Result<Object>(response.getMeta(), result);
        }
        catch (JSONException e) {
            throw new FoursquareApiException(e);
        }
    }

    public Result<Setting> settingSet(String settingId, Boolean value) throws FoursquareApiException {
        try {
            ApiRequestResponse response = this.doApiRequest(Method.POST, "settings/" + settingId + "/set", true, "value", value != false ? 1 : 0);
            Setting result = null;
            if (response.getMeta().getCode() == 200) {
                result = (Setting)JSONFieldParser.parseEntity(Setting.class, response.getResponse().getJSONObject("settings"), this.skipNonExistingFields);
            }
            return new Result<Object>(response.getMeta(), result);
        }
        catch (JSONException e) {
            throw new FoursquareApiException(e);
        }
    }

    public Result<Setting> settingsAll() throws FoursquareApiException {
        try {
            ApiRequestResponse response = this.doApiRequest(Method.GET, "settings/all", true, new Object[0]);
            Setting result = null;
            if (response.getMeta().getCode() == 200) {
                result = (Setting)JSONFieldParser.parseEntity(Setting.class, response.getResponse().getJSONObject("settings"), this.skipNonExistingFields);
            }
            return new Result<Object>(response.getMeta(), result);
        }
        catch (JSONException e) {
            throw new FoursquareApiException(e);
        }
    }

    public Result<CompleteSpecial> special(String id, String venueId) throws FoursquareApiException {
        try {
            ApiRequestResponse response = this.doApiRequest(Method.GET, "specials/" + id, this.isAuthenticated(), "venueId", venueId);
            CompleteSpecial result = null;
            if (response.getMeta().getCode() == 200) {
                result = (CompleteSpecial)JSONFieldParser.parseEntity(CompleteSpecial.class, response.getResponse().getJSONObject("special"), this.skipNonExistingFields);
            }
            return new Result<Object>(response.getMeta(), result);
        }
        catch (JSONException e) {
            throw new FoursquareApiException(e);
        }
    }

    public Result<SpecialGroup> specialsSearch(String ll, Double llAcc, Double alt, Double altAcc, Integer limit) throws FoursquareApiException {
        try {
            ApiRequestResponse response = this.doApiRequest(Method.GET, "specials/search", true, "ll", ll, "llAcc", llAcc, "alt", alt, "altAcc", altAcc, "limit", limit);
            SpecialGroup result = null;
            if (response.getMeta().getCode() == 200) {
                result = (SpecialGroup)JSONFieldParser.parseEntity(SpecialGroup.class, response.getResponse().getJSONObject("specials"), this.skipNonExistingFields);
            }
            return new Result<Object>(response.getMeta(), result);
        }
        catch (JSONException e) {
            throw new FoursquareApiException(e);
        }
    }

    private boolean isAuthenticated() {
        return this.oAuthToken != null && !"".equals(this.oAuthToken);
    }

    public String getAuthenticationUrl() {
        return "https://foursquare.com/oauth2/authenticate?client_id=" + this.clientId + "&response_type=code" + "&redirect_uri=" + this.redirectUrl;
    }

    public void authenticateCode(String code) throws FoursquareApiException {
        StringBuilder urlBuilder = new StringBuilder("https://foursquare.com/oauth2/access_token?client_id=").append(this.clientId).append("&client_secret=").append(this.clientSecret).append("&grant_type=authorization_code").append("&redirect_uri=").append(this.redirectUrl).append("&code=").append(code);
        try {
            Response response = this.ioHandler.fetchData(urlBuilder.toString(), Method.GET);
            if (response.getResponseCode() != 200) {
                throw new IOException(response.getMessage());
            }
            JSONObject responseObject = new JSONObject(response.getResponseContent());
            this.oAuthToken = responseObject.getString("access_token");
        }
        catch (JSONException e) {
            throw new FoursquareApiException(e);
        }
        catch (IOException e) {
            throw new FoursquareApiException(e);
        }
    }

    public IOHandler getIOHandler() {
        return this.ioHandler;
    }

    private ApiRequestResponse doApiMultipartMimeRequest(String path, boolean auth, Object ... params) throws JSONException, FoursquareApiException {
        ArrayList<Object> parameters = new ArrayList<Object>();
        ArrayList<MultipartParameter> multipartParameters = new ArrayList<MultipartParameter>();
        for (Object param : params) {
            if (param instanceof MultipartParameter) {
                multipartParameters.add((MultipartParameter)param);
                continue;
            }
            parameters.add(param);
        }
        String url = this.getApiRequestUrl(path, auth, parameters.toArray());
        Response response = this.ioHandler.fetchDataMultipartMime(url, multipartParameters.toArray(new MultipartParameter[0]));
        if (this.useCallback) {
            return this.handleCallbackApiResponse(response);
        }
        return this.handleApiResponse(response);
    }

    private ApiRequestResponse doApiRequest(Method method, String path, boolean auth, Object ... params) throws JSONException, FoursquareApiException {
        String url = this.getApiRequestUrl(path, auth, params);
        Response response = this.ioHandler.fetchData(url, method);
        if (this.useCallback) {
            return this.handleCallbackApiResponse(response);
        }
        return this.handleApiResponse(response);
    }

    private String getApiRequestUrl(String path, boolean auth, Object ... params) throws FoursquareApiException {
        StringBuilder urlBuilder = new StringBuilder(apiUrl);
        urlBuilder.append(path);
        urlBuilder.append('?');
        if (params.length > 0) {
            try {
                for (int paramIndex = 0; paramIndex < params.length; paramIndex += 2) {
                    Object value = params[paramIndex + 1];
                    if (value == null) continue;
                    urlBuilder.append(params[paramIndex]);
                    urlBuilder.append('=');
                    urlBuilder.append(URLEncoder.encode(value.toString(), "UTF-8"));
                    urlBuilder.append('&');
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new FoursquareApiException(e);
            }
        }
        if (auth) {
            urlBuilder.append("oauth_token=");
            urlBuilder.append(this.getOAuthToken());
        } else {
            urlBuilder.append("client_id=");
            urlBuilder.append(this.clientId);
            urlBuilder.append("&client_secret=");
            urlBuilder.append(this.clientSecret);
        }
        urlBuilder.append("&v=" + this.version);
        if (this.useCallback) {
            urlBuilder.append("&callback=c");
        }
        return urlBuilder.toString();
    }

    private ApiRequestResponse handleApiResponse(Response response) throws JSONException {
        JSONObject responseJson = null;
        JSONArray notificationsJson = null;
        String errorDetail = null;
        if (response.getResponseCode() == 200) {
            JSONObject responseObject = new JSONObject(response.getResponseContent());
            responseJson = responseObject.getJSONObject("response");
            notificationsJson = responseObject.optJSONArray("notifications");
        } else {
            errorDetail = response.getMessage();
        }
        return new ApiRequestResponse(new ResultMeta(response.getResponseCode(), "", errorDetail), responseJson, notificationsJson);
    }

    private ApiRequestResponse handleCallbackApiResponse(Response response) throws JSONException {
        if (response.getResponseCode() == 200) {
            String responseContent = response.getResponseContent();
            String callbackPrefix = "c(";
            String callbackPostfix = ");";
            JSONObject responseObject = new JSONObject(responseContent.substring(callbackPrefix.length(), responseContent.length() - callbackPostfix.length()));
            JSONObject metaObject = responseObject.getJSONObject("meta");
            int code = metaObject.getInt("code");
            String errorType = metaObject.optString("errorType");
            String errorDetail = metaObject.optString("errorDetail");
            JSONObject responseJson = responseObject.getJSONObject("response");
            JSONArray notificationsJson = responseObject.optJSONArray("notifications");
            return new ApiRequestResponse(new ResultMeta(code, errorType, errorDetail), responseJson, notificationsJson);
        }
        return new ApiRequestResponse(new ResultMeta(response.getResponseCode(), "", response.getMessage()), null, null);
    }

    private class ApiRequestResponse {
        private JSONObject response;
        private JSONArray notifications;
        private ResultMeta meta;

        public ApiRequestResponse(ResultMeta meta, JSONObject response, JSONArray notifications) throws JSONException {
            this.meta = meta;
            this.response = response;
            this.notifications = notifications;
        }

        public JSONObject getResponse() {
            return this.response;
        }

        public JSONArray getNotifications() {
            return this.notifications;
        }

        public ResultMeta getMeta() {
            return this.meta;
        }
    }
}

