/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.foursquare.api;

import fi.foyt.foursquare.api.FoursquareApiException;
import fi.foyt.foursquare.api.FoursquareEntity;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONFieldParser {
    private JSONFieldParser() {
    }

    public static FoursquareEntity[] parseEntities(Class<?> clazz, JSONArray jsonArray, boolean skipNonExistingFields) throws FoursquareApiException {
        FoursquareEntity[] result = (FoursquareEntity[])Array.newInstance(clazz, jsonArray.length());
        int l = jsonArray.length();
        for (int i = 0; i < l; ++i) {
            try {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                result[i] = JSONFieldParser.parseEntity(clazz, jsonObject, skipNonExistingFields);
                continue;
            }
            catch (JSONException e) {
                throw new FoursquareApiException(e);
            }
        }
        return result;
    }

    public static FoursquareEntity[] parseEntitiesHash(Class<?> clazz, JSONObject jsonHashList, boolean skipNonExistingFields) throws FoursquareApiException {
        String[] keys = JSONFieldParser.getFieldNames(jsonHashList);
        FoursquareEntity[] result = (FoursquareEntity[])Array.newInstance(clazz, keys.length);
        int i = 0;
        for (String key : keys) {
            try {
                JSONObject jsonObject = jsonHashList.getJSONObject(key);
                result[i++] = JSONFieldParser.parseEntity(clazz, jsonObject, skipNonExistingFields);
            }
            catch (JSONException e) {
                throw new FoursquareApiException(e);
            }
        }
        return result;
    }

    public static FoursquareEntity parseEntity(Class<?> clazz, JSONObject jsonObject, boolean skipNonExistingFields) throws FoursquareApiException {
        FoursquareEntity entity = JSONFieldParser.createNewEntity(clazz);
        String[] objectFieldNames = JSONFieldParser.getFieldNames(jsonObject);
        if (objectFieldNames != null) {
            for (String objectFieldName : objectFieldNames) {
                Class<?> fieldClass = JSONFieldParser.getFieldClass(entity.getClass(), objectFieldName);
                if (fieldClass == null) {
                    Method setterMethod = JSONFieldParser.getSetterMethod(entity.getClass(), objectFieldName);
                    if (setterMethod == null) {
                        if (skipNonExistingFields) continue;
                        throw new FoursquareApiException("Could not find field " + objectFieldName + " from " + entity.getClass().getName() + " class");
                    }
                    Class<?>[] parameters = setterMethod.getParameterTypes();
                    if (parameters.length == 1) {
                        fieldClass = parameters[0];
                        try {
                            setterMethod.setAccessible(true);
                            setterMethod.invoke((Object)entity, JSONFieldParser.parseValue(fieldClass, jsonObject, objectFieldName, skipNonExistingFields));
                            continue;
                        }
                        catch (JSONException e) {
                            throw new FoursquareApiException(e);
                        }
                        catch (IllegalArgumentException e) {
                            throw new FoursquareApiException(e);
                        }
                        catch (IllegalAccessException e) {
                            throw new FoursquareApiException(e);
                        }
                        catch (InvocationTargetException e) {
                            throw new FoursquareApiException(e);
                        }
                    }
                    throw new FoursquareApiException("Could not find field " + objectFieldName + " from " + entity.getClass().getName() + " class");
                }
                try {
                    JSONFieldParser.setEntityFieldValue(entity, objectFieldName, JSONFieldParser.parseValue(fieldClass, jsonObject, objectFieldName, skipNonExistingFields));
                }
                catch (JSONException e) {
                    throw new FoursquareApiException(e);
                }
            }
        }
        return entity;
    }

    private static Object parseValue(Class<?> clazz, JSONObject jsonObject, String objectFieldName, boolean skipNonExistingFields) throws JSONException, FoursquareApiException {
        if (clazz.isArray()) {
            JSONArray jsonArray = jsonObject.getJSONArray(objectFieldName);
            Class<?> arrayClass = clazz.getComponentType();
            Object[] arrayValue = (Object[])Array.newInstance(arrayClass, jsonArray.length());
            int l = jsonArray.length();
            for (int i = 0; i < l; ++i) {
                if (arrayClass.equals(String.class)) {
                    arrayValue[i] = jsonArray.getString(i);
                    continue;
                }
                if (arrayClass.equals(Integer.class)) {
                    arrayValue[i] = jsonArray.getInt(i);
                    continue;
                }
                if (arrayClass.equals(Long.class)) {
                    arrayValue[i] = jsonArray.getLong(i);
                    continue;
                }
                if (arrayClass.equals(Double.class)) {
                    arrayValue[i] = jsonArray.getDouble(i);
                    continue;
                }
                if (arrayClass.equals(Boolean.class)) {
                    arrayValue[i] = jsonArray.getBoolean(i);
                    continue;
                }
                if (JSONFieldParser.isFoursquareEntity(arrayClass)) {
                    arrayValue[i] = JSONFieldParser.parseEntity(arrayClass, jsonArray.getJSONObject(i), skipNonExistingFields);
                    continue;
                }
                throw new FoursquareApiException("Unknown array type: " + arrayClass);
            }
            return arrayValue;
        }
        if (clazz.equals(String.class)) {
            return jsonObject.getString(objectFieldName);
        }
        if (clazz.equals(Integer.class)) {
            return jsonObject.getInt(objectFieldName);
        }
        if (clazz.equals(Long.class)) {
            return jsonObject.getLong(objectFieldName);
        }
        if (clazz.equals(Double.class)) {
            return jsonObject.getDouble(objectFieldName);
        }
        if (clazz.equals(Boolean.class)) {
            return jsonObject.getBoolean(objectFieldName);
        }
        if (JSONFieldParser.isFoursquareEntity(clazz)) {
            return JSONFieldParser.parseEntity(clazz, jsonObject.getJSONObject(objectFieldName), skipNonExistingFields);
        }
        throw new FoursquareApiException("Unknown type: " + clazz);
    }

    private static boolean isFoursquareEntity(Class<?> clazz) {
        for (Class<?> intrf : clazz.getInterfaces()) {
            if (!intrf.equals(FoursquareEntity.class)) continue;
            return true;
        }
        Class<?> superClass = clazz.getSuperclass();
        if (!superClass.equals(Object.class)) {
            return JSONFieldParser.isFoursquareEntity(superClass);
        }
        return false;
    }

    private static Field getField(Class<?> entityClass, String fieldName) {
        try {
            Field field = entityClass.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (SecurityException e) {
            return null;
        }
        catch (NoSuchFieldException e) {
            Class<?> superClass = entityClass.getSuperclass();
            if (superClass.equals(Object.class)) {
                return null;
            }
            return JSONFieldParser.getField(superClass, fieldName);
        }
    }

    private static List<Method> getMethods(Class<?> entityClass) {
        ArrayList<Method> result = new ArrayList<Method>(Arrays.asList(entityClass.getDeclaredMethods()));
        if (!entityClass.getSuperclass().equals(Object.class)) {
            result.addAll(JSONFieldParser.getMethods(entityClass.getSuperclass()));
        }
        return result;
    }

    private static Method getSetterMethod(Class<?> entityClass, String fieldName) {
        StringBuilder methodNameBuilder = new StringBuilder();
        methodNameBuilder.append("set");
        methodNameBuilder.append(Character.toUpperCase(fieldName.charAt(0)));
        methodNameBuilder.append(fieldName.substring(1));
        String methodName = methodNameBuilder.toString();
        List<Method> methods = JSONFieldParser.getMethods(entityClass);
        for (Method method : methods) {
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        return null;
    }

    private static Class<?> getFieldClass(Class<?> entityClass, String fieldName) {
        Field field = JSONFieldParser.getField(entityClass, fieldName);
        return field != null ? field.getType() : null;
    }

    private static void setEntityFieldValue(FoursquareEntity entity, String fieldName, Object value) throws FoursquareApiException {
        try {
            Field fieldProperty = JSONFieldParser.getField(entity.getClass(), fieldName);
            fieldProperty.setAccessible(true);
            fieldProperty.set(entity, value);
        }
        catch (Exception e) {
            throw new FoursquareApiException(e);
        }
    }

    private static FoursquareEntity createNewEntity(Class<?> clazz) {
        try {
            return (FoursquareEntity)clazz.newInstance();
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    private static String[] getFieldNames(JSONObject jsonObject) {
        int length = jsonObject.length();
        if (length == 0) {
            return null;
        }
        Iterator iterator = jsonObject.keys();
        String[] names = new String[length];
        int i = 0;
        while (iterator.hasNext()) {
            names[i] = (String)iterator.next();
            ++i;
        }
        return names;
    }
}

