;;tl;dr AGPLv3+
;;copyright info at bottom
(ns leiningen.new.flibbertigibbet
  (:require [leiningen.new.templates :refer
             [renderer name-to-path ->files year]]
            [leiningen.core.main :as main]
            [me.raynes.fs :as fs]
            [clojure.java.io :as io]
            [clojure.java.shell :refer [sh with-sh-dir]]))

(def render (renderer "flibbertigibbet"))

(defn flibbertigibbet
  "create new clojure projects"
  [name]
  (let [data {:name name
              :sanitized (name-to-path name)
              :year (year)
              :author (:out (sh "git" "config" "user.name"))
              :description (do
                             (println "one line description of " name)
                             (read-line))}]
    (main/info (str "Generating fresh 'lein new' flibbertigibbet project: "
                    name))
    (->files
     data
     ;;["{destination-project/}path/to/destination/file"
     ;; (render
     ;;  "{resources/leiningen/new/flibbertigibbet/}path/to/source/file"
     ;;  data)]
     ["test.bash" (render "test.bash" data)]
     ["test-staged.bash" (render "test-staged.bash" data)]
     ["src/{{sanitized}}/core.clj"
      (render "src/flibbertigibbet/core.clj" data)]
     ["project.clj" (render "project.clj" data)]
     ["test/{{sanitized}}/core_test.clj"
      (render "test/flibbertigibbet/core_test.clj" data)]
     ["COPYING" (render "COPYING" data)]
     ["makefile" (render "makefile" data)]
     ["notes.org" (render "notes.org" data)]
     [".gitignore" (render ".gitignore" data)])
    (fs/chmod "u+x" (io/file name "test.bash"))
    (fs/chmod "u+x" (io/file name "test-staged.bash"))
    (sh "ln" "-s" "COPYING" (.toString (io/file name "LICENSE")))
    (sh "ln" "-s" "notes.org" (.toString (io/file name "CHANGELOG.org")))
    (with-sh-dir name
      (sh "git" "init")
      (sh "git" "add" "."))
    (spit (io/file name ".git" "hooks" "pre-commit")
          "#! /usr/bin/env bash\nmake --quiet test-staged\n")
    (fs/chmod "u+x" (io/file name ".git" "hooks" "pre-commit"))))

;;flibbertigibbet is a lein new flibbertigibbet project-name
;;Copyright (C) 2016 daniel watson

;;This file is part of flibbertigibbet.

;;flibbertigibbet is free software: you can redistribute it and/or
;;modify it under the terms of the GNU Affero General Public License as
;;published by the Free Software Foundation, either version 3 of the
;;License, or (at your option) any later version.

;;flibbertigibbet is distributed in the hope that it
;;will be useful, but WITHOUT ANY WARRANTY; without even the implied
;;warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
;;the GNU General Affero Public License for more details.

;;You should have received a copy of the GNU Affero General Public License
;;along with flibbertigibbet.  If not, see
;;<http://www.gnu.org/licenses/>.
